package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView
import app.appnomix.sdk.internal.domain.machine.states.InsertCouponCodeNode.evaluateJs
import app.appnomix.sdk.internal.domain.machine.states.TreeNode.JsResult
import app.appnomix.sdk.internal.domain.model.Coupon
import app.appnomix.sdk.internal.utils.SLog

data object InsertCouponCodeNode : TreeNode() {

    override suspend fun execute() {
        val webView = inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        val couponsToVerify =
            inventory?.get<List<Coupon>>(TreeInventoryType.COUPON_LIST) ?: listOf()
        val couponIndexToVerify =
            inventory?.get<Int>(TreeInventoryType.COUPON_INDEX_BEING_VERIFIED) ?: 0
        if (config != null && webView != null && couponsToVerify.isNotEmpty()) {
            inventory?.save(TreeInventoryType.COUPON_INDEX_BEING_VERIFIED, couponIndexToVerify)

            val coupon = couponsToVerify[couponIndexToVerify]
            SLog.i("[aa] preparing to verify: $coupon")
            val didExecute = InsertCouponCodeExecutor.execute(
                inputJsSelector = config.selectorCouponInput ?: "",
                code = coupon.code,
                webView = webView
            )
            if (didExecute) {
                markReadyForTransition(TreeTransition.Positive)
            } else {
                markReadyForTransition(TreeTransition.Negative)
            }
        } else {
            markReadyForTransition(TreeTransition.Negative)
        }
    }

    override fun positiveChildNode(): TreeNode = ApplyCouponCodeNode
}

object InsertCouponCodeExecutor {

    suspend fun execute(
        inputJsSelector: String,
        code: String,
        webView: WebView
    ): Boolean {
        return evaluateSelector(
            webView = webView,
            selector = inputJsSelector,
            coupon = code
        )
    }

    private suspend fun evaluateSelector(
        webView: WebView,
        selector: String,
        coupon: String,
    ): Boolean {
        if (selector.isEmpty()) return false
        val jsCode = """
        (function() {
            var input = document.querySelector(`$selector`);
            if (input) {
                input.value = '$coupon';
                return true;
            }
            return false;
        })();
    """

        val result = evaluateJs<Boolean>(webView, jsCode)
        return if (result is JsResult.Success)
            result.value
        else false
    }
}
