package app.appnomix.sdk.internal.domain.machine.states

import android.webkit.WebView
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyCodeTriedFailureAnalytics
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyCodeTriedSuccessAnalytics
import app.appnomix.sdk.internal.ui.PopupDisplay
import app.appnomix.sdk.internal.ui.PopupViewData
import app.appnomix.sdk.internal.utils.SLog

data object NewTotalVerifierNode : GetCartTotalNode() {

    override suspend fun execute() {
        val lastTotal = inventory?.get<Double>(TreeInventoryType.CART_NEW_TOTAL)
            ?: inventory?.get<Double>(TreeInventoryType.CART_INITIAL_TOTAL)
            ?: 0.0
        val couponList = inventory?.get<List<String>>(TreeInventoryType.COUPON_LIST) ?: listOf()
        val couponIndexVerified =
            inventory?.get<Int>(TreeInventoryType.COUPON_INDEX_BEING_VERIFIED) ?: 0
        val webView = inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
        val popupDisplay = inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)
        webView?.let { waitForWebViewFinishedLoading(it) }

        val newTotal = getCartTotal() ?: 0.0
        val isNewTotalLower = newTotal > 0 && newTotal < lastTotal
        if (isNewTotalLower) {
            SLog.i("[aa] new lower total detected: $newTotal vs $lastTotal")
            inventory?.save(TreeInventoryType.CART_NEW_TOTAL, newTotal)
            inventory?.save(TreeInventoryType.BEST_COUPON_INDEX_DETECTED, couponIndexVerified)

            popupDisplay?.popupViewData?.copy()?.apply {
                val savings = "%.2f".format(lastTotal - newTotal).toDouble()
                set(PopupViewData.PopupViewDataType.TOTAL_SAVINGS, savings)
            }?.let {
                performInMainScope { popupDisplay.updateViewData(it) }
            }

            logAutoApplyCodeTriedSuccessAnalytics(lastTotal, newTotal)
        } else {
            logAutoApplyCodeTriedFailureAnalytics(lastTotal)
        }

        if (couponList.size > couponIndexVerified + 1) {
            inventory?.save(TreeInventoryType.COUPON_INDEX_BEING_VERIFIED, couponIndexVerified + 1)
            markReadyForTransition(TreeTransition.Positive)
        } else {
            markReadyForTransition(TreeTransition.Negative)
        }
    }

    override fun positiveChildNode(): TreeNode = RemoveCouponCodeNode

    override fun negativeChildNode(): TreeNode {
        val bestCouponIndex = inventory?.get<Int?>(TreeInventoryType.BEST_COUPON_INDEX_DETECTED)
        return if (bestCouponIndex == null) ShowNoSavingsFoundNode else ShowSavedMessageNode(
            bestCouponIndex
        )
    }
}
