package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView

data object RemoveCouponCodeNode : TreeNode() {

    override suspend fun execute() {
        val webView = inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)
        if (config != null && webView != null) {
            val couponRemoveSelector = config.selectorCouponRemoveButton ?: ""
            val didRemove = evaluateButtonTap(
                webView = webView,
                selector = couponRemoveSelector,
            )
            if (didRemove) {
                if (config.reloadOnRemove == true) {
                    waitForWebViewFinishedLoading(webView)
                }
            }

            markReadyForTransition(TreeTransition.Positive)
        }
    }

    private suspend fun evaluateButtonTap(
        webView: WebView,
        selector: String
    ): Boolean {
        if (selector.isEmpty()) return false
        val jsCode = """
        (function() {
            var button = document.querySelector(`$selector`);
            if (button) {
                button.click();
                return true;
            }
            return false;
        })();
    """

        val result = evaluateJs<Boolean>(webView, jsCode)
        return if (result is JsResult.Success)
            result.value
        else false
    }

    override fun positiveChildNode(): TreeNode = WaitBetweenCouponsApplyNode
}
