package app.appnomix.sdk.internal.domain.machine.states

import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyFinishedContinueToCheckoutAnalytics
import app.appnomix.sdk.internal.domain.machine.states.analytics.logAutoApplyFinishedWithSavingsAnalytics
import app.appnomix.sdk.internal.domain.model.Coupon
import app.appnomix.sdk.internal.ui.PopupDisplay
import app.appnomix.sdk.internal.ui.PopupViewData
import app.appnomix.sdk.internal.ui.PopupViewType
import app.appnomix.sdk.internal.utils.SLog

data class ShowSavedMessageNode(val bestCouponIndex: Int?) : UiTreeNode() {

    override suspend fun execute() {
        performInMainScope {
            if (bestCouponIndex == null) {
                markReadyForTransition(TreeTransition.Negative)
                return@performInMainScope
            }

            val popupDisplay = inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)
            popupDisplay?.hide()
            val bestCouponIndex = inventory?.get<Int>(TreeInventoryType.BEST_COUPON_INDEX_DETECTED)
            val currencySymbol = inventory?.get<String>(TreeInventoryType.CURRENCY_SYMBOL) ?: ""
            val initialTotal = inventory?.get<Double>(TreeInventoryType.CART_INITIAL_TOTAL)
                ?: 0.0
            val newTotal = inventory?.get<Double>(TreeInventoryType.CART_NEW_TOTAL) ?: 0.0
            val couponList = inventory?.get<List<Coupon>>(TreeInventoryType.COUPON_LIST)
            val savings = "%.2f".format(initialTotal - newTotal).toDoubleOrNull()

            if (bestCouponIndex != null) {
                val data = PopupViewData().apply {
                    set(PopupViewData.PopupViewDataType.CURRENCY_SYMBOL, currencySymbol)
                    couponList?.getOrNull(bestCouponIndex)
                        ?.let {
                            SLog.i("[aa] best coupon: $it")
                            set(PopupViewData.PopupViewDataType.COUPON, it)
                        }
                    set(
                        PopupViewData.PopupViewDataType.TOTAL_SAVINGS,
                        savings ?: 0
                    )
                }

                logAutoApplyFinishedWithSavingsAnalytics(
                    initialTotal = initialTotal,
                    newTotal = newTotal
                )
                popupDisplay?.show(
                    viewType = PopupViewType.APPLY_BEST_COUPON,
                    data = data,
                    onConfirmAction = {
                        popupDisplay.hide()
                        logAutoApplyFinishedContinueToCheckoutAnalytics()
                        markReadyForTransition(TreeTransition.Positive)
                    },
                )
            }
        }
    }

    override fun pause() {
        performInMainScope {
            inventory?.get<PopupDisplay>(TreeInventoryType.POPUP_DISPLAY)?.apply {
                if (activePopupType() == PopupViewType.AUTO_APPLY_ASK) {
                    hide()
                }
            }
        }
    }

    override fun positiveChildNode() = ApplyBestCouponCodeNode
}
