package app.appnomix.sdk.internal.domain.machine.states

import CheckoutPageConfig
import android.webkit.WebView
import kotlinx.coroutines.delay

data object WaitForCouponCodeApplyNode : TreeNode() {

    override suspend fun execute() {
        val config = inventory?.get<CheckoutPageConfig>(TreeInventoryType.CHECKOUT_CONFIG)

        val delayAfterCouponMs = config?.delayAfterCouponMs
        if (config != null && delayAfterCouponMs != null) {
            delay(delayAfterCouponMs.toLong())
            markReadyForTransition(TreeTransition.Positive)
        } else {
            inventory?.get<WebView>(TreeInventoryType.WEB_VIEW)
                ?.let { waitForWebViewFinishedLoading(it) }

            markReadyForTransition(TreeTransition.Positive)
        }
    }

    override fun positiveChildNode() = ApplyErrorVerifierNode
}
