package app.appnomix.sdk.internal.ui

import android.content.Context
import android.graphics.drawable.Drawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import app.appnomix.sdk.R
import app.appnomix.sdk.internal.domain.model.Coupon
import java.util.Locale

class ApplyBestCouponView(
    private val context: Context,
    private val logo: Drawable
) {
    private var titleWithAppName: TextView? = null
    private var actionButton: Button? = null

    fun create(data: PopupViewData, confirmAction: (Any?) -> Unit): View {
        val overlay =
            LayoutInflater.from(context).inflate(R.layout.apply_best_coupon_popup_window, null)
        return overlay.apply {
            val logoImageView: ImageView? = findViewById(R.id.logo_imageView)
            logoImageView?.setImageDrawable(logo)

            titleWithAppName = findViewById(R.id.title_part3_textView)
            titleWithAppName?.text = resources.getString(
                R.string.with_app,
                context.getString(context.applicationInfo.labelRes)
            )
            actionButton = findViewById(R.id.action_button)
            actionButton?.setOnClickListener { confirmAction(null) }

            val savingsTextView: TextView? = findViewById(R.id.savings_textView)
            val currency = data.get<String>(PopupViewData.PopupViewDataType.CURRENCY_SYMBOL) ?: ""
            val totalSavings = data.get<Double>(PopupViewData.PopupViewDataType.TOTAL_SAVINGS)
            totalSavings?.let {
                val savingsValue = String.format(Locale.getDefault(), "%.2f", it)
                savingsTextView?.text = String.format(Locale.getDefault(), "$currency$savingsValue")
            }

            data.get<Coupon>(PopupViewData.PopupViewDataType.COUPON)?.let { coupon ->
                val couponDescriptionTextView: TextView? =
                    findViewById(R.id.couponDescription_textView)
                couponDescriptionTextView?.text = coupon.description
                val couponCodeTextView: TextView? = findViewById(R.id.couponCode_textView)
                couponCodeTextView?.text = coupon.code
                findViewById<ViewGroup>(R.id.coupons_layout)?.setOnClickListener {
                    coupon.code.copyToClipboard(context)
                }
            }

        }
    }
}
