package app.appnomix.sdk.internal.ui

import android.content.Context
import android.graphics.drawable.Drawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.ScrollView
import android.widget.TextView
import app.appnomix.sdk.R
import app.appnomix.sdk.internal.analytics.Analytics
import app.appnomix.sdk.internal.analytics.AnalyticsEvent
import app.appnomix.sdk.internal.analytics.AnalyticsName
import app.appnomix.sdk.internal.domain.model.Coupon
import com.google.android.material.progressindicator.LinearProgressIndicator

class CouponsFoundView(
    private val context: Context,
    private val logo: Drawable
) {
    private var overlay: View? = null
    private var logoImageView: ImageView? = null
    private var titleTextView: TextView? = null
    private var descriptionTextView: TextView? = null
    private var laterButton: Button? = null
    private var couponsScrollView: ScrollView? = null
    private var couponsLayout: ViewGroup? = null
    private var progressBar: LinearProgressIndicator? = null

    fun create(
        data: PopupViewData,
        confirmAction: (Any?) -> Unit,
        dismissAction: () -> Unit,
    ): View {

        overlay =
            LayoutInflater.from(context).inflate(R.layout.coupons_found_list_popup_window, null)

        logoImageView = overlay?.findViewById(R.id.logo_imageView)
        titleTextView = overlay?.findViewById(R.id.title_textView)
        descriptionTextView = overlay?.findViewById(R.id.description_textView)
        laterButton = overlay?.findViewById(R.id.later_button)
        couponsScrollView = overlay?.findViewById(R.id.coupons_scrollView)
        couponsLayout = overlay?.findViewById(R.id.coupons_layout)
        progressBar = overlay?.findViewById(R.id.progress_bar)

        logoImageView?.setImageDrawable(logo)

        laterButton?.setOnClickListener {
            Analytics.trackEvent(
                AnalyticsEvent.Builder(
                    eventCategory = AnalyticsName.EventCategory.MONETIZATION
                ).apply { name = AnalyticsName.EventType.COPY_CODE_CLOSE_TAP }.build()
            )
            dismissAction()
        }

        configure(data = data, onConfirmAction = confirmAction)

        return overlay as View
    }

    private fun configure(
        data: PopupViewData,
        onConfirmAction: (Any?) -> Unit,
    ) {
        val couponList =
            data.get<List<Coupon>>(PopupViewData.PopupViewDataType.COUPON_LIST)
                ?: listOf()
        val couponsLayout = overlay?.findViewById<ViewGroup>(R.id.coupons_layout)
        if (couponsLayout?.childCount != couponList.size) {
            couponsLayout?.removeAllViews()
            couponList.forEach { item ->
                val itemLayout =
                    LayoutInflater.from(context).inflate(R.layout.coupon_item_with_copy, null)
                itemLayout.apply {
                    val couponDescription =
                        findViewById<TextView>(R.id.couponDescription_textView)
                    val couponCode = findViewById<TextView>(R.id.couponCode_textView)

                    couponDescription.text = item.description
                    couponCode.text = item.code
                    itemLayout.setOnClickListener {
                        item.code.copyToClipboard(context)

                        Analytics.trackEvent(
                            AnalyticsEvent.Builder(
                                eventCategory = AnalyticsName.EventCategory.MONETIZATION
                            ).apply { name = AnalyticsName.EventType.COPY_CODE_ACTION_TAP }.build()
                        )
                        onConfirmAction(item.code)
                    }
                }
                couponsLayout?.addView(itemLayout)
            }
        }
    }
}