package app.appnomix.sdk.internal.ui

import android.content.Context
import android.graphics.PixelFormat
import android.view.Gravity
import android.view.WindowManager

class PopupDisplay(val context: Context) {

    private val viewFactory = PopupViewFactory(context)
    private var currentViewData: Pair<PopupViewType, PopupView>? = null
    private val windowManager: WindowManager by lazy {
        context.getSystemService(Context.WINDOW_SERVICE) as WindowManager
    }
    private var currentPopupViewData: PopupViewData? = null
    val popupViewData: PopupViewData?
        get() = currentPopupViewData

    fun updateViewData(data: PopupViewData) {
        currentPopupViewData = data
        currentViewData?.second?.updateAction?.invoke(data)
    }

    fun show(
        viewType: PopupViewType,
        onCloseAction: () -> Unit = {},
        onConfirmAction: (Any?) -> Unit = {},
        onDismissAction: () -> Unit = {},
        data: PopupViewData? = null,
    ) {
        // we don't want to auto-hide here for the same view-type. let the caller hide it, if that's the desired behavior
        if (viewType == currentViewData?.first) return
        hide()

        val createdView = viewFactory.create(
            type = viewType,
            onCloseAction = onCloseAction,
            onConfirmAction = onConfirmAction,
            onDismissAction = onDismissAction,
            data = data,
            windowManager = windowManager
        )
        val newView = Pair(
            first = viewType,
            second = createdView
        )

        windowManager.addView(newView.second.view, createdView.params)
        currentPopupViewData = data
        currentViewData = newView
    }

    fun hide() {
        currentViewData?.let {
            windowManager.removeView(it.second.view)
            currentViewData = null
        }
    }

    fun activePopupType(): PopupViewType? = currentViewData?.first
}
