/*
 * Decompiled with CFR 0.152.
 */
package app.appnomix.sdk.internal.data.network.model;

import app.appnomix.sdk.internal.utils.SLog;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;

@Metadata(mv={2, 0, 0}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lapp/appnomix/sdk/internal/data/network/model/TimestampWithOffsetSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/time/OffsetDateTime;", "sdk_release"}, xi=48)
public final class TimestampWithOffsetSerializer
implements KSerializer<OffsetDateTime> {
    public final DateTimeFormatter a;
    public final SerialDescriptor b;

    public TimestampWithOffsetSerializer() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZ").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        this.a = dateTimeFormatter;
        this.b = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"Timestamp", (PrimitiveKind)PrimitiveKind.STRING.INSTANCE);
    }

    public final SerialDescriptor getDescriptor() {
        return this.b;
    }

    public final void serialize(Encoder encoder, Object object) {
        TimestampWithOffsetSerializer timestampWithOffsetSerializer = offsetDateTime;
        OffsetDateTime offsetDateTime = (OffsetDateTime)object;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)offsetDateTime, (String)"value");
        String string = timestampWithOffsetSerializer.a.format(offsetDateTime);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        encoder.encodeString(string);
    }

    public final Object deserialize(Decoder object) {
        TimestampWithOffsetSerializer timestampWithOffsetSerializer = object2;
        Decoder decoder = object;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Object object2 = "";
        object2 = decoder.decodeString();
        object = OffsetDateTime.from(timestampWithOffsetSerializer.a.parse((CharSequence)object2));
        try {
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"from(...)");
        }
        catch (Exception exception) {
            SLog.INSTANCE.e("Could not parse date: " + (String)object2, exception);
            object = OffsetDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"now(...)");
        }
        return object;
    }
}

