/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.internal;

import app.cash.backfila.client.BackfilaApi;
import app.cash.backfila.client.Backfill;
import app.cash.backfila.client.EnvoyConnectorData;
import app.cash.backfila.client.HttpConnectorData;
import app.cash.backfila.client.internal.BackfillOperatorFactory;
import app.cash.backfila.client.spi.BackfillOperator;
import app.cash.backfila.embedded.Backfila;
import app.cash.backfila.embedded.BackfillRun;
import app.cash.backfila.embedded.internal.EmbeddedBackfillRun;
import app.cash.backfila.protos.service.CheckBackfillStatusRequest;
import app.cash.backfila.protos.service.CheckBackfillStatusResponse;
import app.cash.backfila.protos.service.ConfigureServiceRequest;
import app.cash.backfila.protos.service.ConfigureServiceResponse;
import app.cash.backfila.protos.service.CreateAndStartBackfillRequest;
import app.cash.backfila.protos.service.CreateAndStartBackfillResponse;
import app.cash.backfila.protos.service.CreateBackfillRequest;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.KClassesJvm;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.mock.Calls;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u0014\u001a\u00020\u001aH\u0016JV\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000f\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001f2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0002JN\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000f\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0016JN\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000f\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0016J.\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000f\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001f2\u0006\u0010+\u001a\u00020,H\u0016J&\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000f\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lapp/cash/backfila/client/internal/EmbeddedBackfila;", "Lapp/cash/backfila/embedded/Backfila;", "Lapp/cash/backfila/client/BackfilaApi;", "operatorFactory", "Lapp/cash/backfila/client/internal/BackfillOperatorFactory;", "(Lapp/cash/backfila/client/internal/BackfillOperatorFactory;)V", "backfillRunIdGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "configureServiceData", "Lapp/cash/backfila/protos/service/ConfigureServiceRequest;", "getConfigureServiceData", "()Lapp/cash/backfila/protos/service/ConfigureServiceRequest;", "createdBackfillRuns", "", "", "Lapp/cash/backfila/embedded/BackfillRun;", "serviceData", "checkBackfillStatus", "Lretrofit2/Call;", "Lapp/cash/backfila/protos/service/CheckBackfillStatusResponse;", "request", "Lapp/cash/backfila/protos/service/CheckBackfillStatusRequest;", "configureService", "Lapp/cash/backfila/protos/service/ConfigureServiceResponse;", "createAndStartbackfill", "Lapp/cash/backfila/protos/service/CreateAndStartBackfillResponse;", "Lapp/cash/backfila/protos/service/CreateAndStartBackfillRequest;", "createBackfill", "Type", "Lapp/cash/backfila/client/Backfill;", "backfillType", "Lkotlin/reflect/KClass;", "dryRun", "", "parameters", "", "Lokio/ByteString;", "rangeStart", "rangeEnd", "createDryRun", "backfill", "createWetRun", "findExistingRun", "backfillRunId", "", "findLatestRun", "backfila-embedded"})
public final class EmbeddedBackfila
implements Backfila,
BackfilaApi {
    @NotNull
    private final BackfillOperatorFactory operatorFactory;
    @Nullable
    private ConfigureServiceRequest serviceData;
    @NotNull
    private AtomicInteger backfillRunIdGenerator;
    @NotNull
    private Map<String, BackfillRun<?>> createdBackfillRuns;

    @Inject
    public EmbeddedBackfila(@NotNull BackfillOperatorFactory operatorFactory) {
        Intrinsics.checkNotNullParameter((Object)operatorFactory, (String)"operatorFactory");
        this.operatorFactory = operatorFactory;
        this.backfillRunIdGenerator = new AtomicInteger(10);
        this.createdBackfillRuns = new LinkedHashMap();
    }

    @Override
    @Nullable
    public ConfigureServiceRequest getConfigureServiceData() {
        return this.serviceData;
    }

    @NotNull
    public Call<ConfigureServiceResponse> configureService(@NotNull ConfigureServiceRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(this.serviceData == null)) {
            boolean bl = false;
            String string = "Should only be configuring a single backfila service.";
            throw new IllegalStateException(string.toString());
        }
        Moshi moshi = new Moshi.Builder().add((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).build();
        String string = request.connector_type;
        if (Intrinsics.areEqual((Object)string, (Object)"HTTP")) {
            JsonAdapter connectorDataAdapter = moshi.adapter(HttpConnectorData.class);
            HttpConnectorData httpData = (HttpConnectorData)connectorDataAdapter.fromJson(request.connector_extra_data);
            if (httpData == null) {
                boolean bl = false;
                String string2 = "Must provide HTTP connector data for HTTP connector type.";
                throw new IllegalStateException(string2.toString());
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"ENVOY")) {
            JsonAdapter connectorDataAdapter = moshi.adapter(EnvoyConnectorData.class);
            connectorDataAdapter.fromJson(request.connector_extra_data);
        } else {
            throw new IllegalStateException("Backfila only supports HTTP and Envoy currently.".toString());
        }
        this.serviceData = request;
        Call call = Calls.response((Object)new ConfigureServiceResponse());
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"response(ConfigureServiceResponse())");
        return call;
    }

    @NotNull
    public Call<CreateAndStartBackfillResponse> createAndStartbackfill(@NotNull CreateAndStartBackfillRequest request) {
        Object v2;
        CreateBackfillRequest createRequest;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (this.serviceData == null) {
                boolean $i$a$-checkNotNull-EmbeddedBackfila$createAndStartbackfill$22 = false;
                String $i$a$-checkNotNull-EmbeddedBackfila$createAndStartbackfill$22 = "Must register the service before creating a backfill";
                throw new IllegalStateException($i$a$-checkNotNull-EmbeddedBackfila$createAndStartbackfill$22.toString());
            }
            createRequest = request.create_request;
            ConfigureServiceRequest configureServiceRequest = this.serviceData;
            Intrinsics.checkNotNull((Object)configureServiceRequest);
            List list = configureServiceRequest.backfills;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"serviceData!!.backfills");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ConfigureServiceRequest.BackfillData it = (ConfigureServiceRequest.BackfillData)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)createRequest.backfill_name)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if (v2 == null) {
            boolean $i$a$-checkNotNull-EmbeddedBackfila$createAndStartbackfill$42 = false;
            String $i$a$-checkNotNull-EmbeddedBackfila$createAndStartbackfill$42 = "Backfill " + createRequest.backfill_name + " was not registered properly";
            throw new IllegalStateException($i$a$-checkNotNull-EmbeddedBackfila$createAndStartbackfill$42.toString());
        }
        String backfillRunId = String.valueOf(this.backfillRunIdGenerator.getAndIncrement());
        String string = createRequest.backfill_name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createRequest.backfill_name");
        BackfillOperator operator = this.operatorFactory.create(string, backfillRunId);
        Boolean bl = createRequest.dry_run;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"createRequest.dry_run");
        boolean bl2 = bl;
        Map map = createRequest.parameter_map;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createRequest.parameter_map");
        ByteString byteString = createRequest.pkey_range_start;
        ByteString byteString2 = createRequest.pkey_range_end;
        EmbeddedBackfillRun run = new EmbeddedBackfillRun(operator, bl2, MapsKt.toMutableMap((Map)map), byteString != null ? byteString.utf8() : null, byteString2 != null ? byteString2.utf8() : null, backfillRunId, 0L, 0L, 0L, 448, null);
        this.createdBackfillRuns.put(backfillRunId, run);
        run.execute();
        Call call = Calls.response((Object)new CreateAndStartBackfillResponse(Long.valueOf(Long.parseLong(backfillRunId))));
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"response(CreateAndStartB\u2026(backfillRunId.toLong()))");
        return call;
    }

    @NotNull
    public Call<CheckBackfillStatusResponse> checkBackfillStatus(@NotNull CheckBackfillStatusRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.backfill_run_id == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        BackfillRun<?> backfillRun = this.createdBackfillRuns.get(String.valueOf(request.backfill_run_id));
        if (backfillRun == null) {
            throw new IllegalStateException(("No Backfill with id " + request.backfill_run_id + " found").toString());
        }
        BackfillRun<?> backfillRun2 = backfillRun;
        Call call = Calls.response((Object)new CheckBackfillStatusResponse(backfillRun2.complete() ? CheckBackfillStatusResponse.Status.COMPLETE : CheckBackfillStatusResponse.Status.RUNNING));
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"response(\n      CheckBac\u2026s.RUNNING,\n      ),\n    )");
        return call;
    }

    @Override
    @NotNull
    public <Type extends Backfill> BackfillRun<Type> createDryRun(@NotNull KClass<Type> backfill, @NotNull Map<String, ? extends ByteString> parameters, @Nullable String rangeStart, @Nullable String rangeEnd) {
        Intrinsics.checkNotNullParameter(backfill, (String)"backfill");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return this.createBackfill(backfill, true, parameters, rangeStart, rangeEnd);
    }

    @Override
    @NotNull
    public <Type extends Backfill> BackfillRun<Type> createWetRun(@NotNull KClass<Type> backfillType, @NotNull Map<String, ? extends ByteString> parameters, @Nullable String rangeStart, @Nullable String rangeEnd) {
        Intrinsics.checkNotNullParameter(backfillType, (String)"backfillType");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return this.createBackfill(backfillType, false, parameters, rangeStart, rangeEnd);
    }

    @Override
    @NotNull
    public <Type extends Backfill> BackfillRun<Type> findExistingRun(@NotNull KClass<Type> backfillType, long backfillRunId) {
        Intrinsics.checkNotNullParameter(backfillType, (String)"backfillType");
        BackfillRun<?> backfillRun = this.createdBackfillRuns.get(String.valueOf(backfillRunId));
        if (backfillRun == null) {
            throw new IllegalStateException(("No Backfill with id " + backfillRunId + " found").toString());
        }
        BackfillRun<?> untypedBackfill = backfillRun;
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(untypedBackfill.getBackfill().getClass()), backfillType)) {
            boolean bl = false;
            String string = "Backfill with run id " + backfillRunId + " is not of type " + backfillType;
            throw new IllegalStateException(string.toString());
        }
        return untypedBackfill;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <Type extends Backfill> BackfillRun<Type> findLatestRun(@NotNull KClass<Type> backfillType) {
        Object v0;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(backfillType, (String)"backfillType");
        Object object = this.createdBackfillRuns;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(((BackfillRun)it.getValue()).getBackfill().getClass()), backfillType)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable iterable = destination$iv$iv.entrySet();
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v0 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                long l = Long.parseLong((String)it.getKey());
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-EmbeddedBackfila$findLatestRun$untypedBackfill$2 = false;
                    long l2 = Long.parseLong((String)it2.getKey());
                    if (l >= l2) continue;
                    t = t2;
                    l = l2;
                } while (iterator.hasNext());
                v0 = t;
            }
        }
        Map.Entry entry = v0;
        if (entry == null || (object = (BackfillRun)entry.getValue()) == null) {
            throw new IllegalStateException(("No latest backfill of type " + backfillType + " found").toString());
        }
        Object untypedBackfill = object;
        return untypedBackfill;
    }

    /*
     * WARNING - void declaration
     */
    private final <Type extends Backfill> BackfillRun<Type> createBackfill(KClass<Type> backfillType, boolean dryRun, Map<String, ? extends ByteString> parameters, String rangeStart, String rangeEnd) {
        void $this$mapTo$iv$iv;
        if (this.serviceData == null) {
            boolean $i$a$-checkNotNull-EmbeddedBackfila$createBackfill$22 = false;
            String $i$a$-checkNotNull-EmbeddedBackfila$createBackfill$22 = "Must register the service before creating a backfill";
            throw new IllegalStateException($i$a$-checkNotNull-EmbeddedBackfila$createBackfill$22.toString());
        }
        ConfigureServiceRequest configureServiceRequest = this.serviceData;
        Intrinsics.checkNotNull((Object)configureServiceRequest);
        List list = configureServiceRequest.backfills;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"serviceData!!.backfills");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConfigureServiceRequest.BackfillData backfillData = (ConfigureServiceRequest.BackfillData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name);
        }
        if (!((List)destination$iv$iv).contains(KClassesJvm.getJvmName(backfillType))) {
            boolean $i$a$-check-EmbeddedBackfila$createBackfill$42 = false;
            String $i$a$-check-EmbeddedBackfila$createBackfill$42 = "Backfill " + KClassesJvm.getJvmName(backfillType) + " was not registered properly";
            throw new IllegalStateException($i$a$-check-EmbeddedBackfila$createBackfill$42.toString());
        }
        String backfillRunId = String.valueOf(this.backfillRunIdGenerator.getAndIncrement());
        BackfillOperator operator = this.operatorFactory.create(KClassesJvm.getJvmName(backfillType), backfillRunId);
        EmbeddedBackfillRun backfillRun = new EmbeddedBackfillRun(operator, dryRun, MapsKt.toMutableMap(parameters), rangeStart, rangeEnd, backfillRunId, 0L, 0L, 0L, 448, null);
        this.createdBackfillRuns.put(backfillRunId, backfillRun);
        return backfillRun;
    }
}

