/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.embedded.internal;

import app.cash.backfila.protos.clientservice.KeyRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001e"}, d2={"Lapp/cash/backfila/embedded/internal/BatchSnapshot;", "", "partitionName", "", "batchRange", "Lapp/cash/backfila/protos/clientservice/KeyRange;", "scannedRecordCount", "", "matchingRecordCount", "(Ljava/lang/String;Lapp/cash/backfila/protos/clientservice/KeyRange;JJ)V", "getBatchRange", "()Lapp/cash/backfila/protos/clientservice/KeyRange;", "getMatchingRecordCount", "()J", "getPartitionName", "()Ljava/lang/String;", "getScannedRecordCount", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "utf8RangeEnd", "utf8RangeStart", "backfila-embedded"})
public final class BatchSnapshot {
    @NotNull
    private final String partitionName;
    @NotNull
    private final KeyRange batchRange;
    private final long scannedRecordCount;
    private final long matchingRecordCount;

    public BatchSnapshot(@NotNull String partitionName, @NotNull KeyRange batchRange, long scannedRecordCount, long matchingRecordCount) {
        Intrinsics.checkNotNullParameter((Object)partitionName, (String)"partitionName");
        Intrinsics.checkNotNullParameter((Object)batchRange, (String)"batchRange");
        this.partitionName = partitionName;
        this.batchRange = batchRange;
        this.scannedRecordCount = scannedRecordCount;
        this.matchingRecordCount = matchingRecordCount;
    }

    @NotNull
    public final String getPartitionName() {
        return this.partitionName;
    }

    @NotNull
    public final KeyRange getBatchRange() {
        return this.batchRange;
    }

    public final long getScannedRecordCount() {
        return this.scannedRecordCount;
    }

    public final long getMatchingRecordCount() {
        return this.matchingRecordCount;
    }

    @NotNull
    public final String utf8RangeStart() {
        return this.batchRange.start.utf8();
    }

    @NotNull
    public final String utf8RangeEnd() {
        return this.batchRange.end.utf8();
    }

    @NotNull
    public final String component1() {
        return this.partitionName;
    }

    @NotNull
    public final KeyRange component2() {
        return this.batchRange;
    }

    public final long component3() {
        return this.scannedRecordCount;
    }

    public final long component4() {
        return this.matchingRecordCount;
    }

    @NotNull
    public final BatchSnapshot copy(@NotNull String partitionName, @NotNull KeyRange batchRange, long scannedRecordCount, long matchingRecordCount) {
        Intrinsics.checkNotNullParameter((Object)partitionName, (String)"partitionName");
        Intrinsics.checkNotNullParameter((Object)batchRange, (String)"batchRange");
        return new BatchSnapshot(partitionName, batchRange, scannedRecordCount, matchingRecordCount);
    }

    public static /* synthetic */ BatchSnapshot copy$default(BatchSnapshot batchSnapshot, String string, KeyRange keyRange, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            string = batchSnapshot.partitionName;
        }
        if ((n & 2) != 0) {
            keyRange = batchSnapshot.batchRange;
        }
        if ((n & 4) != 0) {
            l = batchSnapshot.scannedRecordCount;
        }
        if ((n & 8) != 0) {
            l2 = batchSnapshot.matchingRecordCount;
        }
        return batchSnapshot.copy(string, keyRange, l, l2);
    }

    @NotNull
    public String toString() {
        return "BatchSnapshot(partitionName=" + this.partitionName + ", batchRange=" + this.batchRange + ", scannedRecordCount=" + this.scannedRecordCount + ", matchingRecordCount=" + this.matchingRecordCount + ")";
    }

    public int hashCode() {
        int result = this.partitionName.hashCode();
        result = result * 31 + this.batchRange.hashCode();
        result = result * 31 + Long.hashCode(this.scannedRecordCount);
        result = result * 31 + Long.hashCode(this.matchingRecordCount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BatchSnapshot)) {
            return false;
        }
        BatchSnapshot batchSnapshot = (BatchSnapshot)other;
        if (!Intrinsics.areEqual((Object)this.partitionName, (Object)batchSnapshot.partitionName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.batchRange, (Object)batchSnapshot.batchRange)) {
            return false;
        }
        if (this.scannedRecordCount != batchSnapshot.scannedRecordCount) {
            return false;
        }
        return this.matchingRecordCount == batchSnapshot.matchingRecordCount;
    }
}

