/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.dynamodb.internal;

import app.cash.backfila.client.DeleteBy;
import app.cash.backfila.client.DeleteByKt;
import app.cash.backfila.client.Description;
import app.cash.backfila.client.dynamodb.DynamoDbBackfill;
import app.cash.backfila.client.dynamodb.ForDynamoDbBackend;
import app.cash.backfila.client.dynamodb.internal.DynamoDbBackfillOperator;
import app.cash.backfila.client.dynamodb.internal.DynamoDbKeyRangeCodec;
import app.cash.backfila.client.spi.BackfilaParametersOperator;
import app.cash.backfila.client.spi.BackfillBackend;
import app.cash.backfila.client.spi.BackfillOperator;
import app.cash.backfila.client.spi.BackfillRegistration;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.squareup.moshi.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012$\b\u0001\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J<\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u0019\"\b\b\u0000\u0010\u001a*\u00020\u001c\"\b\b\u0001\u0010\u001b*\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\bH\u0002J\u001a\u0010\u001e\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J2\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u0007\"\b\b\u0000\u0010!*\u00020\u001c2\u0018\u0010\"\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H!0\b0\u0007H\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lapp/cash/backfila/client/dynamodb/internal/DynamoDbBackend;", "Lapp/cash/backfila/client/spi/BackfillBackend;", "injector", "Lcom/google/inject/Injector;", "backfills", "", "", "Lkotlin/reflect/KClass;", "Lapp/cash/backfila/client/dynamodb/DynamoDbBackfill;", "dynamoDb", "Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;", "keyRangeCodec", "Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec;", "(Lcom/google/inject/Injector;Ljava/util/Map;Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec;)V", "getDynamoDb", "()Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;", "getKeyRangeCodec", "()Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec;", "", "Lapp/cash/backfila/client/spi/BackfillRegistration;", "create", "Lapp/cash/backfila/client/spi/BackfillOperator;", "backfillName", "backfillId", "createDynamoDbOperator", "Lapp/cash/backfila/client/dynamodb/internal/DynamoDbBackfillOperator;", "E", "Param", "", "backfill", "getBackfill", "name", "parametersClass", "P", "backfillClass", "client-dynamodb"})
public final class DynamoDbBackend
implements BackfillBackend {
    @NotNull
    private final Injector injector;
    @NotNull
    private final Map<String, KClass<? extends DynamoDbBackfill<?, ?>>> backfills;
    @NotNull
    private final DynamoDBMapper dynamoDb;
    @NotNull
    private final DynamoDbKeyRangeCodec keyRangeCodec;

    @Inject
    public DynamoDbBackend(@NotNull Injector injector, @ForDynamoDbBackend @NotNull Map<String, KClass<? extends DynamoDbBackfill<?, ?>>> backfills, @NotNull DynamoDBMapper dynamoDb, @NotNull DynamoDbKeyRangeCodec keyRangeCodec) {
        Intrinsics.checkNotNullParameter((Object)injector, (String)"injector");
        Intrinsics.checkNotNullParameter(backfills, (String)"backfills");
        Intrinsics.checkNotNullParameter((Object)dynamoDb, (String)"dynamoDb");
        Intrinsics.checkNotNullParameter((Object)keyRangeCodec, (String)"keyRangeCodec");
        this.injector = injector;
        this.backfills = backfills;
        this.dynamoDb = dynamoDb;
        this.keyRangeCodec = keyRangeCodec;
    }

    @NotNull
    public final DynamoDBMapper getDynamoDb() {
        return this.dynamoDb;
    }

    @NotNull
    public final DynamoDbKeyRangeCodec getKeyRangeCodec() {
        return this.keyRangeCodec;
    }

    private final DynamoDbBackfill<?, ?> getBackfill(String name) {
        DynamoDbBackfill dynamoDbBackfill;
        KClass<? extends DynamoDbBackfill<?, ?>> backfillClass = this.backfills.get(name);
        if (backfillClass != null) {
            Object object = this.injector.getInstance(JvmClassMappingKt.getJavaClass(backfillClass));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type app.cash.backfila.client.dynamodb.DynamoDbBackfill<*, *>");
            }
            dynamoDbBackfill = (DynamoDbBackfill)object;
        } else {
            dynamoDbBackfill = null;
        }
        return dynamoDbBackfill;
    }

    private final <E, Param> DynamoDbBackfillOperator<E, Param> createDynamoDbOperator(DynamoDbBackfill<E, Param> backfill) {
        return new DynamoDbBackfillOperator<E, Param>(this.dynamoDb, backfill, new BackfilaParametersOperator(this.parametersClass(Reflection.getOrCreateKotlinClass(backfill.getClass()))), this.keyRangeCodec);
    }

    @Nullable
    public BackfillOperator create(@NotNull String backfillName, @NotNull String backfillId) {
        Intrinsics.checkNotNullParameter((Object)backfillName, (String)"backfillName");
        Intrinsics.checkNotNullParameter((Object)backfillId, (String)"backfillId");
        DynamoDbBackfill<?, ?> backfill = this.getBackfill(backfillName);
        if (backfill != null) {
            return this.createDynamoDbOperator(backfill);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<BackfillRegistration> backfills() {
        void $this$mapTo$iv$iv;
        Map<String, KClass<DynamoDbBackfill<?, ?>>> $this$map$iv = this.backfills;
        boolean $i$f$map = false;
        Map<String, KClass<DynamoDbBackfill<?, ?>>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            Annotation annotation;
            Object v2;
            KClass kClass;
            Object object;
            Description description;
            String string;
            Collection collection;
            block4: {
                Object v0;
                boolean bl2;
                Annotation it$iv;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv$iv;
                KAnnotatedElement $this$findAnnotation$iv;
                boolean $i$f$findAnnotation;
                void it;
                block3: {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    KAnnotatedElement kAnnotatedElement = (KAnnotatedElement)it.getValue();
                    string = (String)it.getKey();
                    $i$f$findAnnotation = false;
                    $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                        it$iv = (Annotation)element$iv$iv;
                        bl2 = false;
                        if (!(it$iv instanceof Description)) continue;
                        v0 = element$iv$iv;
                        break block3;
                    }
                    v0 = null;
                }
                String string2 = (description = (Description)(object = (Annotation)((Description)v0))) == null ? null : description.text();
                $this$findAnnotation$iv = (KAnnotatedElement)it.getValue();
                kClass = this.parametersClass((KClass)it.getValue());
                object = string2;
                $i$f$findAnnotation = false;
                $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    it$iv = (Annotation)element$iv$iv;
                    bl2 = false;
                    if (!(it$iv instanceof DeleteBy)) continue;
                    v2 = element$iv$iv;
                    break block4;
                }
                v2 = null;
            }
            Instant instant = (description = (DeleteBy)(annotation = (Annotation)((DeleteBy)v2))) == null ? null : DeleteByKt.parseDeleteByDate((DeleteBy)description);
            KClass kClass2 = kClass;
            Object object2 = object;
            String string3 = string;
            BackfillRegistration backfillRegistration = new BackfillRegistration(string3, (String)object2, kClass2, instant);
            collection.add(backfillRegistration);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final <P> KClass<P> parametersClass(KClass<? extends DynamoDbBackfill<?, P>> backfillClass) {
        TypeLiteral thisType = TypeLiteral.get((Class)JvmClassMappingKt.getJavaClass(backfillClass));
        Type type = thisType.getSupertype(DynamoDbBackfill.class).getType();
        if (type == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        ParameterizedType supertype = (ParameterizedType)type;
        if ((type = Types.getRawType((Type)supertype.getActualTypeArguments()[1])) == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<P of app.cash.backfila.client.dynamodb.internal.DynamoDbBackend.parametersClass>");
        }
        return JvmClassMappingKt.getKotlinClass((Class)type);
    }
}

