/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.dynamodb.internal;

import app.cash.backfila.client.dynamodb.ForDynamoDbBackend;
import app.cash.backfila.client.dynamodb.internal.DynamoDbKeyRange;
import app.cash.backfila.protos.clientservice.KeyRange;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.inject.util.Types;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001e\u001f B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J=\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0016\b\u0002\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u001bJ0\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0016\b\u0002\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007H\u0002Rb\u0010\u0005\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t \n*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u0007 \n**\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t \n*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec;", "", "moshi", "Lcom/squareup/moshi/Moshi;", "(Lcom/squareup/moshi/Moshi;)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "", "", "Lcom/amazonaws/services/dynamodbv2/model/AttributeValue;", "kotlin.jvm.PlatformType", "decodeKeyRange", "Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRange;", "keyRange", "Lapp/cash/backfila/protos/clientservice/KeyRange;", "decodeKeyRange$client_dynamodb", "decodeSegment", "Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec$SegmentData;", "segment", "Lokio/ByteString;", "decodeSegment$client_dynamodb", "encodeKeyRange", "start", "", "end", "count", "lastEvaluatedKey", "encodeKeyRange$client_dynamodb", "encodeSegment", "offset", "AttributeValueJson", "Companion", "SegmentData", "client-dynamodb"})
public final class DynamoDbKeyRangeCodec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final JsonAdapter<Map<String, AttributeValue>> adapter;
    @NotNull
    public static final String VERSION = "v2";
    @NotNull
    public static final String INT_FORMAT = "%010d";

    @Inject
    public DynamoDbKeyRangeCodec(@ForDynamoDbBackend @NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Type[] typeArray = new Type[]{(Type)((Object)String.class), (Type)((Object)AttributeValue.class)};
        this.adapter = moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])typeArray));
    }

    @NotNull
    public final DynamoDbKeyRange decodeKeyRange$client_dynamodb(@NotNull KeyRange keyRange) {
        Intrinsics.checkNotNullParameter((Object)keyRange, (String)"keyRange");
        ByteString byteString = keyRange.start;
        Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"keyRange.start");
        SegmentData startSegment = this.decodeSegment$client_dynamodb(byteString);
        ByteString byteString2 = keyRange.end;
        Intrinsics.checkNotNullExpressionValue((Object)byteString2, (String)"keyRange.end");
        SegmentData endSegment = this.decodeSegment$client_dynamodb(byteString2);
        boolean bl = startSegment.getCount() == endSegment.getCount();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = endSegment.getLastEvaluatedKey() == null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new DynamoDbKeyRange(startSegment.getOffset(), endSegment.getOffset(), startSegment.getCount(), startSegment.getLastEvaluatedKey());
    }

    @NotNull
    public final SegmentData decodeSegment$client_dynamodb(@NotNull ByteString segment) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Buffer buffer = new Buffer().write(segment);
        String tag = buffer.readUtf8(2L);
        boolean bl3 = Intrinsics.areEqual((Object)tag, (Object)VERSION);
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl3) {
            boolean bl6 = false;
            String string = "Encountered an incorrect version " + tag + " instead of v2 . Make sure any deploys have completed and re-create the backfill.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl3 = Intrinsics.areEqual((Object)buffer.readUtf8(1L), (Object)":");
        bl4 = false;
        bl5 = false;
        bl5 = false;
        boolean bl7 = false;
        if (!bl3) {
            boolean bl8 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = buffer.readUtf8(10L);
        bl5 = false;
        int offset = Integer.parseInt(string);
        boolean bl9 = Intrinsics.areEqual((Object)buffer.readUtf8(1L), (Object)"/");
        bl5 = false;
        bl7 = false;
        bl7 = false;
        boolean bl10 = false;
        if (!bl9) {
            boolean bl11 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String string3 = buffer.readUtf8(10L);
        bl7 = false;
        int count = Integer.parseInt(string3);
        Map lastEvaluatedKey = null;
        if (!buffer.exhausted()) {
            bl7 = Intrinsics.areEqual((Object)buffer.readUtf8(1L), (Object)":");
            bl10 = false;
            bl2 = false;
            bl2 = false;
            bl = false;
            if (!bl7) {
                boolean bl12 = false;
                String string4 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
            lastEvaluatedKey = (Map)this.adapter.fromJson((BufferedSource)buffer);
        }
        bl7 = buffer.exhausted();
        bl10 = false;
        bl2 = false;
        bl2 = false;
        bl = false;
        if (!bl7) {
            boolean bl13 = false;
            String string5 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string5.toString());
        }
        return new SegmentData(offset, count, lastEvaluatedKey);
    }

    @NotNull
    public final KeyRange encodeKeyRange$client_dynamodb(int start, int end, int count, @Nullable Map<String, ? extends AttributeValue> lastEvaluatedKey) {
        KeyRange keyRange = new KeyRange.Builder().start(this.encodeSegment(start, count, lastEvaluatedKey)).end(DynamoDbKeyRangeCodec.encodeSegment$default(this, end, count, null, 4, null)).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyRange, (String)"Builder()\n      .start(e\u2026d, count))\n      .build()");
        return keyRange;
    }

    public static /* synthetic */ KeyRange encodeKeyRange$client_dynamodb$default(DynamoDbKeyRangeCodec dynamoDbKeyRangeCodec, int n, int n2, int n3, Map map, int n4, Object object) {
        if ((n4 & 8) != 0) {
            map = null;
        }
        return dynamoDbKeyRangeCodec.encodeKeyRange$client_dynamodb(n, n2, n3, map);
    }

    private final ByteString encodeSegment(int offset, int count, Map<String, ? extends AttributeValue> lastEvaluatedKey) {
        boolean bl = 0 <= offset ? offset <= count : false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = INT_FORMAT;
        Object object = new Object[]{offset};
        bl4 = false;
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        String stringOffset = string2;
        object = INT_FORMAT;
        Object object2 = new Object[]{count};
        boolean bl6 = false;
        String string3 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        String stringCount = string3;
        Buffer buffer = new Buffer().writeUtf8("v2:" + stringOffset + "/" + stringCount);
        if (lastEvaluatedKey != null) {
            Buffer buffer2 = buffer.writeUtf8(":");
            object2 = this.adapter.toJson(lastEvaluatedKey);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"adapter.toJson(lastEvaluatedKey)");
            buffer2.writeUtf8((String)object2);
        }
        return buffer.readByteString();
    }

    static /* synthetic */ ByteString encodeSegment$default(DynamoDbKeyRangeCodec dynamoDbKeyRangeCodec, int n, int n2, Map map, int n3, Object object) {
        if ((n3 & 4) != 0) {
            map = null;
        }
        return dynamoDbKeyRangeCodec.encodeSegment(n, n2, map);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec$Companion;", "", "()V", "INT_FORMAT", "", "VERSION", "client-dynamodb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006H\u00c6\u0003J5\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec$SegmentData;", "", "offset", "", "count", "lastEvaluatedKey", "", "", "Lcom/amazonaws/services/dynamodbv2/model/AttributeValue;", "(IILjava/util/Map;)V", "getCount", "()I", "getLastEvaluatedKey", "()Ljava/util/Map;", "getOffset", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "client-dynamodb"})
    public static final class SegmentData {
        private final int offset;
        private final int count;
        @Nullable
        private final Map<String, AttributeValue> lastEvaluatedKey;

        public SegmentData(int offset, int count, @Nullable Map<String, ? extends AttributeValue> lastEvaluatedKey) {
            this.offset = offset;
            this.count = count;
            this.lastEvaluatedKey = lastEvaluatedKey;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getCount() {
            return this.count;
        }

        @Nullable
        public final Map<String, AttributeValue> getLastEvaluatedKey() {
            return this.lastEvaluatedKey;
        }

        public final int component1() {
            return this.offset;
        }

        public final int component2() {
            return this.count;
        }

        @Nullable
        public final Map<String, AttributeValue> component3() {
            return this.lastEvaluatedKey;
        }

        @NotNull
        public final SegmentData copy(int offset, int count, @Nullable Map<String, ? extends AttributeValue> lastEvaluatedKey) {
            return new SegmentData(offset, count, lastEvaluatedKey);
        }

        public static /* synthetic */ SegmentData copy$default(SegmentData segmentData, int n, int n2, Map map, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = segmentData.offset;
            }
            if ((n3 & 2) != 0) {
                n2 = segmentData.count;
            }
            if ((n3 & 4) != 0) {
                map = segmentData.lastEvaluatedKey;
            }
            return segmentData.copy(n, n2, map);
        }

        @NotNull
        public String toString() {
            return "SegmentData(offset=" + this.offset + ", count=" + this.count + ", lastEvaluatedKey=" + this.lastEvaluatedKey + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.offset);
            result = result * 31 + Integer.hashCode(this.count);
            result = result * 31 + (this.lastEvaluatedKey == null ? 0 : ((Object)this.lastEvaluatedKey).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SegmentData)) {
                return false;
            }
            SegmentData segmentData = (SegmentData)other;
            if (this.offset != segmentData.offset) {
                return false;
            }
            if (this.count != segmentData.count) {
                return false;
            }
            return Intrinsics.areEqual(this.lastEvaluatedKey, segmentData.lastEvaluatedKey);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b#\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u00a1\u0001\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0000\u0018\u00010\f\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\b\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0011\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bH\u00c6\u0003J\u0011\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bH\u00c6\u0003J\u0011\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u00c6\u0003J\u0017\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0000\u0018\u00010\fH\u00c6\u0003J\u0011\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\bH\u00c6\u0003J\u0010\u0010-\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\u00aa\u0001\u0010.\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0000\u0018\u00010\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00c6\u0001\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\u00020\u000f2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0000\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u001f\u0010\u0015R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\"R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018\u00a8\u00065"}, d2={"Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec$AttributeValueJson;", "", "s", "", "n", "b", "Lokio/ByteString;", "sS", "", "nS", "bS", "m", "", "l", "nULLValue", "", "bOOL", "(Ljava/lang/String;Ljava/lang/String;Lokio/ByteString;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Map;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getB", "()Lokio/ByteString;", "getBOOL", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getBS", "()Ljava/util/List;", "getL", "getM", "()Ljava/util/Map;", "getN", "()Ljava/lang/String;", "getNS", "getNULLValue", "getS", "setS", "(Ljava/lang/String;)V", "getSS", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Lokio/ByteString;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Map;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec$AttributeValueJson;", "equals", "other", "hashCode", "", "toString", "client-dynamodb"})
    public static final class AttributeValueJson {
        @Nullable
        private String s;
        @Nullable
        private final String n;
        @Nullable
        private final ByteString b;
        @Nullable
        private final List<String> sS;
        @Nullable
        private final List<String> nS;
        @Nullable
        private final List<ByteString> bS;
        @Nullable
        private final Map<String, AttributeValueJson> m;
        @Nullable
        private final List<AttributeValueJson> l;
        @Nullable
        private final Boolean nULLValue;
        @Nullable
        private final Boolean bOOL;

        public AttributeValueJson(@Nullable String s, @Nullable String n, @Nullable ByteString b, @Nullable List<String> sS, @Nullable List<String> nS, @Nullable List<? extends ByteString> bS, @Nullable Map<String, AttributeValueJson> m, @Nullable List<AttributeValueJson> l, @Nullable Boolean nULLValue, @Nullable Boolean bOOL) {
            this.s = s;
            this.n = n;
            this.b = b;
            this.sS = sS;
            this.nS = nS;
            this.bS = bS;
            this.m = m;
            this.l = l;
            this.nULLValue = nULLValue;
            this.bOOL = bOOL;
        }

        public /* synthetic */ AttributeValueJson(String string, String string2, ByteString byteString, List list, List list2, List list3, Map map, List list4, Boolean bl, Boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                byteString = null;
            }
            if ((n & 8) != 0) {
                list = null;
            }
            if ((n & 0x10) != 0) {
                list2 = null;
            }
            if ((n & 0x20) != 0) {
                list3 = null;
            }
            if ((n & 0x40) != 0) {
                map = null;
            }
            if ((n & 0x80) != 0) {
                list4 = null;
            }
            if ((n & 0x100) != 0) {
                bl = null;
            }
            if ((n & 0x200) != 0) {
                bl2 = null;
            }
            this(string, string2, byteString, list, list2, list3, map, list4, bl, bl2);
        }

        @Nullable
        public final String getS() {
            return this.s;
        }

        public final void setS(@Nullable String string) {
            this.s = string;
        }

        @Nullable
        public final String getN() {
            return this.n;
        }

        @Nullable
        public final ByteString getB() {
            return this.b;
        }

        @Nullable
        public final List<String> getSS() {
            return this.sS;
        }

        @Nullable
        public final List<String> getNS() {
            return this.nS;
        }

        @Nullable
        public final List<ByteString> getBS() {
            return this.bS;
        }

        @Nullable
        public final Map<String, AttributeValueJson> getM() {
            return this.m;
        }

        @Nullable
        public final List<AttributeValueJson> getL() {
            return this.l;
        }

        @Nullable
        public final Boolean getNULLValue() {
            return this.nULLValue;
        }

        @Nullable
        public final Boolean getBOOL() {
            return this.bOOL;
        }

        @Nullable
        public final String component1() {
            return this.s;
        }

        @Nullable
        public final String component2() {
            return this.n;
        }

        @Nullable
        public final ByteString component3() {
            return this.b;
        }

        @Nullable
        public final List<String> component4() {
            return this.sS;
        }

        @Nullable
        public final List<String> component5() {
            return this.nS;
        }

        @Nullable
        public final List<ByteString> component6() {
            return this.bS;
        }

        @Nullable
        public final Map<String, AttributeValueJson> component7() {
            return this.m;
        }

        @Nullable
        public final List<AttributeValueJson> component8() {
            return this.l;
        }

        @Nullable
        public final Boolean component9() {
            return this.nULLValue;
        }

        @Nullable
        public final Boolean component10() {
            return this.bOOL;
        }

        @NotNull
        public final AttributeValueJson copy(@Nullable String s, @Nullable String n, @Nullable ByteString b, @Nullable List<String> sS, @Nullable List<String> nS, @Nullable List<? extends ByteString> bS, @Nullable Map<String, AttributeValueJson> m, @Nullable List<AttributeValueJson> l, @Nullable Boolean nULLValue, @Nullable Boolean bOOL) {
            return new AttributeValueJson(s, n, b, sS, nS, bS, m, l, nULLValue, bOOL);
        }

        public static /* synthetic */ AttributeValueJson copy$default(AttributeValueJson attributeValueJson, String string, String string2, ByteString byteString, List list, List list2, List list3, Map map, List list4, Boolean bl, Boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = attributeValueJson.s;
            }
            if ((n & 2) != 0) {
                string2 = attributeValueJson.n;
            }
            if ((n & 4) != 0) {
                byteString = attributeValueJson.b;
            }
            if ((n & 8) != 0) {
                list = attributeValueJson.sS;
            }
            if ((n & 0x10) != 0) {
                list2 = attributeValueJson.nS;
            }
            if ((n & 0x20) != 0) {
                list3 = attributeValueJson.bS;
            }
            if ((n & 0x40) != 0) {
                map = attributeValueJson.m;
            }
            if ((n & 0x80) != 0) {
                list4 = attributeValueJson.l;
            }
            if ((n & 0x100) != 0) {
                bl = attributeValueJson.nULLValue;
            }
            if ((n & 0x200) != 0) {
                bl2 = attributeValueJson.bOOL;
            }
            return attributeValueJson.copy(string, string2, byteString, list, list2, list3, map, list4, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "AttributeValueJson(s=" + this.s + ", n=" + this.n + ", b=" + this.b + ", sS=" + this.sS + ", nS=" + this.nS + ", bS=" + this.bS + ", m=" + this.m + ", l=" + this.l + ", nULLValue=" + this.nULLValue + ", bOOL=" + this.bOOL + ")";
        }

        public int hashCode() {
            int result = this.s == null ? 0 : this.s.hashCode();
            result = result * 31 + (this.n == null ? 0 : this.n.hashCode());
            result = result * 31 + (this.b == null ? 0 : this.b.hashCode());
            result = result * 31 + (this.sS == null ? 0 : ((Object)this.sS).hashCode());
            result = result * 31 + (this.nS == null ? 0 : ((Object)this.nS).hashCode());
            result = result * 31 + (this.bS == null ? 0 : ((Object)this.bS).hashCode());
            result = result * 31 + (this.m == null ? 0 : ((Object)this.m).hashCode());
            result = result * 31 + (this.l == null ? 0 : ((Object)this.l).hashCode());
            result = result * 31 + (this.nULLValue == null ? 0 : ((Object)this.nULLValue).hashCode());
            result = result * 31 + (this.bOOL == null ? 0 : ((Object)this.bOOL).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttributeValueJson)) {
                return false;
            }
            AttributeValueJson attributeValueJson = (AttributeValueJson)other;
            if (!Intrinsics.areEqual((Object)this.s, (Object)attributeValueJson.s)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.n, (Object)attributeValueJson.n)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.b, (Object)attributeValueJson.b)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sS, attributeValueJson.sS)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.nS, attributeValueJson.nS)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.bS, attributeValueJson.bS)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.m, attributeValueJson.m)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.l, attributeValueJson.l)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nULLValue, (Object)attributeValueJson.nULLValue)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.bOOL, (Object)attributeValueJson.bOOL);
        }

        public AttributeValueJson() {
            this(null, null, null, null, null, null, null, null, null, null, 1023, null);
        }
    }
}

