/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.dynamodb;

import app.cash.backfila.client.BackfillConfig;
import app.cash.backfila.client.dynamodb.DynamoDbBackfill;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\n\u001a\u00020\u000b2\u0011\u0010\f\u001a\r\u0012\t\u0012\u00078\u0000\u00a2\u0006\u0002\b\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010H\u0016J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010H&\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lapp/cash/backfila/client/dynamodb/UpdateInPlaceDynamoDbBackfill;", "I", "", "P", "Lapp/cash/backfila/client/dynamodb/DynamoDbBackfill;", "dynamoDb", "Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;", "(Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;)V", "getDynamoDb", "()Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;", "runBatch", "", "items", "", "Lkotlin/jvm/JvmSuppressWildcards;", "config", "Lapp/cash/backfila/client/BackfillConfig;", "runOne", "", "item", "(Ljava/lang/Object;Lapp/cash/backfila/client/BackfillConfig;)Z", "client-dynamodb"})
public abstract class UpdateInPlaceDynamoDbBackfill<I, P>
extends DynamoDbBackfill<I, P> {
    @NotNull
    private final DynamoDBMapper dynamoDb;

    public UpdateInPlaceDynamoDbBackfill(@NotNull DynamoDBMapper dynamoDb) {
        Intrinsics.checkNotNullParameter((Object)dynamoDb, (String)"dynamoDb");
        this.dynamoDb = dynamoDb;
    }

    @NotNull
    public final DynamoDBMapper getDynamoDb() {
        return this.dynamoDb;
    }

    @Override
    public void runBatch(@NotNull List<I> items, @NotNull BackfillConfig<P> config) {
        List failedBatch;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        List itemsToSave = new ArrayList();
        for (I item : items) {
            boolean saveItem = this.runOne(item, config);
            if (!saveItem) continue;
            ((Collection)itemsToSave).add(item);
        }
        if (!((Collection)itemsToSave).isEmpty() && !(failedBatch = this.dynamoDb.batchSave((Iterable)itemsToSave)).isEmpty()) {
            boolean bl = false;
            String string = "failed to save items: " + failedBatch;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public abstract boolean runOne(@NotNull I var1, @NotNull BackfillConfig<P> var2);
}

