//[client-dynamodb](../../../index.md)/[app.cash.backfila.client.dynamodb](../index.md)/[UpdateInPlaceDynamoDbBackfill](index.md)

# UpdateInPlaceDynamoDbBackfill

[jvm]\
abstract class [UpdateInPlaceDynamoDbBackfill](index.md)<[I](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [P](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)>(**dynamoDb**: DynamoDBMapper) : [DynamoDbBackfill](../-dynamo-db-backfill/index.md)<[I](index.md), [P](index.md)> 

A base class that may make it easier to mutate the items in the DynamoDB store.

If saving fails the batch will fail. If succeeded rows are part of a failed batch they will be retried so implementations must be idempotent.

## Constructors

| | |
|---|---|
| [UpdateInPlaceDynamoDbBackfill](-update-in-place-dynamo-db-backfill.md) | [jvm]<br>fun [UpdateInPlaceDynamoDbBackfill](-update-in-place-dynamo-db-backfill.md)(dynamoDb: DynamoDBMapper) |

## Functions

| Name | Summary |
|---|---|
| [expressionAttributeNames](../-dynamo-db-backfill/expression-attribute-names.md) | [jvm]<br>open fun [expressionAttributeNames](../-dynamo-db-backfill/expression-attribute-names.md)(config: BackfillConfig<[P](index.md)>): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>?<br>See ScanRequest.setExpressionAttributeNames. |
| [expressionAttributeValues](../-dynamo-db-backfill/expression-attribute-values.md) | [jvm]<br>open fun [expressionAttributeValues](../-dynamo-db-backfill/expression-attribute-values.md)(config: BackfillConfig<[P](index.md)>): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), AttributeValue>?<br>See ScanRequest.setExpressionAttributeValues. |
| [filterExpression](../-dynamo-db-backfill/filter-expression.md) | [jvm]<br>open fun [filterExpression](../-dynamo-db-backfill/filter-expression.md)(config: BackfillConfig<[P](index.md)>): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>See ScanRequest.setFilterExpression. |
| [fixedSegmentCount](../-dynamo-db-backfill/fixed-segment-count.md) | [jvm]<br>open fun [fixedSegmentCount](../-dynamo-db-backfill/fixed-segment-count.md)(config: PrepareBackfillConfig<[P](index.md)>): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)?<br>Override this to force Backfila to run this number of batches in total, divided among the partitions. |
| [indexName](../-dynamo-db-backfill/index-name.md) | [jvm]<br>open fun [indexName](../-dynamo-db-backfill/index-name.md)(config: BackfillConfig<[P](index.md)>): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>See ScanRequest.setIndexName. |
| [mustHaveProvisionedBillingMode](../-dynamo-db-backfill/must-have-provisioned-billing-mode.md) | [jvm]<br>open fun [mustHaveProvisionedBillingMode](../-dynamo-db-backfill/must-have-provisioned-billing-mode.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>It is rather easy to run a backfill against a dynamo instance that is configured expensively. |
| [partitionCount](../-dynamo-db-backfill/partition-count.md) | [jvm]<br>open fun [partitionCount](../-dynamo-db-backfill/partition-count.md)(config: PrepareBackfillConfig<[P](index.md)>): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The number of independent workers to perform the backfill. |
| [runBatch](run-batch.md) | [jvm]<br>open override fun [runBatch](run-batch.md)(items: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<@[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)()[I](index.md)>, config: BackfillConfig<[P](index.md)>)<br>Called for each batch of matching records. |
| [runOne](run-one.md) | [jvm]<br>abstract fun [runOne](run-one.md)(item: [I](index.md), config: BackfillConfig<[P](index.md)>): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Called for each matching record. |
| [validate](../-dynamo-db-backfill/validate.md) | [jvm]<br>open fun [validate](../-dynamo-db-backfill/validate.md)(config: PrepareBackfillConfig<[P](index.md)>)<br>Override this and throw an exception to prevent the backfill from being created. |

## Properties

| Name | Summary |
|---|---|
| [dynamoDb](dynamo-db.md) | [jvm]<br>val [dynamoDb](dynamo-db.md): DynamoDBMapper |
| [itemType](index.md#-1614638681%2FProperties%2F-583643256) | [jvm]<br>val [itemType](index.md#-1614638681%2FProperties%2F-583643256): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)<[I](index.md)> |
