//[client-dynamodb](../../../index.md)/[app.cash.backfila.client.dynamodb](../index.md)/[UpdateInPlaceDynamoDbBackfill](index.md)

# UpdateInPlaceDynamoDbBackfill

[jvm]\
abstract class [UpdateInPlaceDynamoDbBackfill](index.md)&lt;[I](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html), [P](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html)&gt;(val dynamoDb: DynamoDBMapper) : [DynamoDbBackfill](../-dynamo-db-backfill/index.md)&lt;[I](index.md), [P](index.md)&gt; 

A base class that may make it easier to mutate the items in the DynamoDB store.

If saving fails the batch will fail. If succeeded rows are part of a failed batch they will be retried so implementations must be idempotent.

## Constructors

| | |
|---|---|
| [UpdateInPlaceDynamoDbBackfill](-update-in-place-dynamo-db-backfill.md) | [jvm]<br>constructor(dynamoDb: DynamoDBMapper) |

## Properties

| Name | Summary |
|---|---|
| [dynamoDb](dynamo-db.md) | [jvm]<br>val [dynamoDb](dynamo-db.md): DynamoDBMapper |
| [itemType](../-dynamo-db-backfill/item-type.md) | [jvm]<br>val [itemType](../-dynamo-db-backfill/item-type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;[I](index.md)&gt; |

## Functions

| Name | Summary |
|---|---|
| [expressionAttributeNames](../-dynamo-db-backfill/expression-attribute-names.md) | [jvm]<br>open fun [expressionAttributeNames](../-dynamo-db-backfill/expression-attribute-names.md)(config: BackfillConfig&lt;[P](index.md)&gt;): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)&gt;?<br>See ScanRequest.setExpressionAttributeNames. |
| [expressionAttributeValues](../-dynamo-db-backfill/expression-attribute-values.md) | [jvm]<br>open fun [expressionAttributeValues](../-dynamo-db-backfill/expression-attribute-values.md)(config: BackfillConfig&lt;[P](index.md)&gt;): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), AttributeValue&gt;?<br>See ScanRequest.setExpressionAttributeValues. |
| [filterExpression](../-dynamo-db-backfill/filter-expression.md) | [jvm]<br>open fun [filterExpression](../-dynamo-db-backfill/filter-expression.md)(config: BackfillConfig&lt;[P](index.md)&gt;): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?<br>See ScanRequest.setFilterExpression. |
| [fixedSegmentCount](../-dynamo-db-backfill/fixed-segment-count.md) | [jvm]<br>open fun [fixedSegmentCount](../-dynamo-db-backfill/fixed-segment-count.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html)?<br>Override this to force Backfila to run this number of batches in total, divided among the partitions. |
| [indexName](../-dynamo-db-backfill/index-name.md) | [jvm]<br>open fun [indexName](../-dynamo-db-backfill/index-name.md)(config: BackfillConfig&lt;[P](index.md)&gt;): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?<br>See ScanRequest.setIndexName. |
| [mustHaveProvisionedBillingMode](../-dynamo-db-backfill/must-have-provisioned-billing-mode.md) | [jvm]<br>open fun [mustHaveProvisionedBillingMode](../-dynamo-db-backfill/must-have-provisioned-billing-mode.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html)<br>It is rather easy to run a backfill against a dynamo instance that is configured expensively. Update dynamo so the billing mode is PROVISIONED rather than PAY_PER_REQUEST as the latter can be very expensive. |
| [partitionCount](../-dynamo-db-backfill/partition-count.md) | [jvm]<br>open fun [partitionCount](../-dynamo-db-backfill/partition-count.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html)<br>The number of independent workers to perform the backfill. When the Backfill is executing, each worker runs 1 or more batches concurrently. Set a low number here to reduce the total tracking overhead in Backfila; set a higher number for more concurrency. The default of 8 means that the Backfill will run at least 8 batches concurrently. |
| [runBatch](run-batch.md) | [jvm]<br>open override fun [runBatch](run-batch.md)(items: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;@[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)[I](index.md)&gt;, config: BackfillConfig&lt;[P](index.md)&gt;)<br>Called for each batch of matching records. Override in a backfill to process all records in a batch. |
| [runOne](run-one.md) | [jvm]<br>abstract fun [runOne](run-one.md)(item: [I](index.md), config: BackfillConfig&lt;[P](index.md)&gt;): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html)<br>Called for each matching record. Returns true to save the item after returning; false to not save the item. |
| [validate](../-dynamo-db-backfill/validate.md) | [jvm]<br>open fun [validate](../-dynamo-db-backfill/validate.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;)<br>Override this and throw an exception to prevent the backfill from being created. This is also a good place to do any prep work before batches are run. |
