/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.dynamodb.internal;

import app.cash.backfila.client.Backfill;
import app.cash.backfila.client.BackfillConfig;
import app.cash.backfila.client.PrepareBackfillConfig;
import app.cash.backfila.client.dynamodb.DynamoDbBackfill;
import app.cash.backfila.client.dynamodb.internal.DynamoDbKeyRange;
import app.cash.backfila.client.dynamodb.internal.DynamoDbKeyRangeCodec;
import app.cash.backfila.client.spi.BackfilaParametersOperator;
import app.cash.backfila.client.spi.BackfillOperator;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeRequest;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeResponse;
import app.cash.backfila.protos.clientservice.KeyRange;
import app.cash.backfila.protos.clientservice.PrepareBackfillRequest;
import app.cash.backfila.protos.clientservice.PrepareBackfillResponse;
import app.cash.backfila.protos.clientservice.RunBatchRequest;
import app.cash.backfila.protos.clientservice.RunBatchResponse;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTableMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.ScanResultPage;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.google.common.base.Stopwatch;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004B9\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\"H\u0016J \u0010#\u001a\u00020$*\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lapp/cash/backfila/client/dynamodb/internal/DynamoDbBackfillOperator;", "I", "", "P", "Lapp/cash/backfila/client/spi/BackfillOperator;", "dynamoDb", "Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;", "backfill", "Lapp/cash/backfila/client/dynamodb/DynamoDbBackfill;", "parametersOperator", "Lapp/cash/backfila/client/spi/BackfilaParametersOperator;", "keyRangeCodec", "Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec;", "<init>", "(Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;Lapp/cash/backfila/client/dynamodb/DynamoDbBackfill;Lapp/cash/backfila/client/spi/BackfilaParametersOperator;Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec;)V", "getDynamoDb", "()Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;", "getBackfill", "()Lapp/cash/backfila/client/dynamodb/DynamoDbBackfill;", "getParametersOperator", "()Lapp/cash/backfila/client/spi/BackfilaParametersOperator;", "getKeyRangeCodec", "()Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRangeCodec;", "name", "", "prepareBackfill", "Lapp/cash/backfila/protos/clientservice/PrepareBackfillResponse;", "request", "Lapp/cash/backfila/protos/clientservice/PrepareBackfillRequest;", "getNextBatchRange", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeResponse;", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeRequest;", "runBatch", "Lapp/cash/backfila/protos/clientservice/RunBatchResponse;", "Lapp/cash/backfila/protos/clientservice/RunBatchRequest;", "toKeyRange", "Lapp/cash/backfila/protos/clientservice/KeyRange;", "", "Lcom/amazonaws/services/dynamodbv2/model/AttributeValue;", "originalRange", "Lapp/cash/backfila/client/dynamodb/internal/DynamoDbKeyRange;", "client-dynamodb"})
public final class DynamoDbBackfillOperator<I, P>
implements BackfillOperator {
    @NotNull
    private final DynamoDBMapper dynamoDb;
    @NotNull
    private final DynamoDbBackfill<I, P> backfill;
    @NotNull
    private final BackfilaParametersOperator<P> parametersOperator;
    @NotNull
    private final DynamoDbKeyRangeCodec keyRangeCodec;

    public DynamoDbBackfillOperator(@NotNull DynamoDBMapper dynamoDb, @NotNull DynamoDbBackfill<I, P> backfill, @NotNull BackfilaParametersOperator<P> parametersOperator, @NotNull DynamoDbKeyRangeCodec keyRangeCodec) {
        Intrinsics.checkNotNullParameter((Object)dynamoDb, (String)"dynamoDb");
        Intrinsics.checkNotNullParameter(backfill, (String)"backfill");
        Intrinsics.checkNotNullParameter(parametersOperator, (String)"parametersOperator");
        Intrinsics.checkNotNullParameter((Object)keyRangeCodec, (String)"keyRangeCodec");
        this.dynamoDb = dynamoDb;
        this.backfill = backfill;
        this.parametersOperator = parametersOperator;
        this.keyRangeCodec = keyRangeCodec;
    }

    @NotNull
    public final DynamoDBMapper getDynamoDb() {
        return this.dynamoDb;
    }

    @NotNull
    public DynamoDbBackfill<I, P> getBackfill() {
        return this.backfill;
    }

    @NotNull
    public final BackfilaParametersOperator<P> getParametersOperator() {
        return this.parametersOperator;
    }

    @NotNull
    public final DynamoDbKeyRangeCodec getKeyRangeCodec() {
        return this.keyRangeCodec;
    }

    @NotNull
    public String name() {
        String string = this.getBackfill().getClass().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public PrepareBackfillResponse prepareBackfill(@NotNull PrepareBackfillRequest request) {
        int segmentCount;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PrepareBackfillConfig config = this.parametersOperator.constructBackfillConfig(request);
        this.getBackfill().validate(config);
        if (!(request.range == null || request.range.start == null && request.range.end == null)) {
            boolean $i$a$-require-DynamoDbBackfillOperator$prepareBackfill$42 = false;
            String $i$a$-require-DynamoDbBackfillOperator$prepareBackfill$42 = "Range is not supported for this Dynamo Backfila client";
            throw new IllegalArgumentException($i$a$-require-DynamoDbBackfillOperator$prepareBackfill$42.toString());
        }
        DynamoDBTableMapper tableMapper = this.dynamoDb.newTableMapper(JvmClassMappingKt.getJavaClass(this.getBackfill().getItemType()));
        TableDescription tableDescription = tableMapper.describeTable();
        if (this.getBackfill().mustHaveProvisionedBillingMode() && !(tableDescription.getBillingModeSummary() == null || Intrinsics.areEqual((Object)tableDescription.getBillingModeSummary().getBillingMode(), (Object)"PROVISIONED"))) {
            boolean $i$a$-require-DynamoDbBackfillOperator$prepareBackfill$52 = false;
            String $i$a$-require-DynamoDbBackfillOperator$prepareBackfill$52 = "Trying to prepare a backfill on a Dynamo table named " + tableDescription.getTableName() + " with a billing mode that is not PROVISIONED, it is " + tableDescription.getBillingModeSummary().getBillingMode() + ". This can get very expensive. Please provision your dynamo capacity for this table and try again.";
            throw new IllegalArgumentException($i$a$-require-DynamoDbBackfillOperator$prepareBackfill$52.toString());
        }
        int partitionCount = this.getBackfill().partitionCount(config);
        long desiredSegmentCount = RangesKt.coerceIn((long)(tableDescription.getItemCount() / 100L), (long)partitionCount, (long)524288L);
        int defaultSegmentCount = (int)Long.highestOneBit(desiredSegmentCount);
        Integer n = this.getBackfill().fixedSegmentCount(config);
        int n2 = segmentCount = n != null ? n : defaultSegmentCount;
        if (!((1 <= partitionCount ? partitionCount <= segmentCount : false) && Integer.bitCount(partitionCount) == 1 && Integer.bitCount(segmentCount) == 1)) {
            boolean $i$a$-require-DynamoDbBackfillOperator$prepareBackfill$62 = false;
            String $i$a$-require-DynamoDbBackfillOperator$prepareBackfill$62 = "partitionCount and segmentCount must be positive powers of 2, and segmentCount must be greater than partitionCount (partitionCount=" + partitionCount + ", segmentCount=" + segmentCount + ")";
            throw new IllegalArgumentException($i$a$-require-DynamoDbBackfillOperator$prepareBackfill$62.toString());
        }
        int segmentsPerPartition = segmentCount / partitionCount;
        List partitions = new ArrayList();
        for (int i = 0; i < partitionCount; ++i) {
            int segmentStartInclusive = i * segmentsPerPartition;
            int segmentEndExclusive = (i + 1) * segmentsPerPartition;
            ((Collection)partitions).add(new PrepareBackfillResponse.Partition.Builder().partition_name(i + " of " + partitionCount).backfill_range(DynamoDbKeyRangeCodec.encodeKeyRange$client_dynamodb$default(this.keyRangeCodec, segmentStartInclusive, segmentEndExclusive, segmentCount, null, 8, null)).build());
        }
        PrepareBackfillResponse prepareBackfillResponse = new PrepareBackfillResponse.Builder().partitions(partitions).build();
        Intrinsics.checkNotNullExpressionValue((Object)prepareBackfillResponse, (String)"build(...)");
        return prepareBackfillResponse;
    }

    @NotNull
    public GetNextBatchRangeResponse getNextBatchRange(@NotNull GetNextBatchRangeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        KeyRange keyRange = request.backfill_range;
        Intrinsics.checkNotNullExpressionValue((Object)keyRange, (String)"backfill_range");
        DynamoDbKeyRange dynamoDbKeyRange = this.keyRangeCodec.decodeKeyRange$client_dynamodb(keyRange);
        int start = dynamoDbKeyRange.component1();
        int end = dynamoDbKeyRange.component2();
        int count = dynamoDbKeyRange.component3();
        if (request.previous_end_key != null) {
            ByteString byteString = request.previous_end_key;
            Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"previous_end_key");
            DynamoDbKeyRangeCodec.SegmentData segmentData = this.keyRangeCodec.decodeSegment$client_dynamodb(byteString);
            if (!(segmentData.getCount() == count)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(segmentData.getLastEvaluatedKey() == null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            start = segmentData.getOffset();
        }
        List batches = new ArrayList();
        int n = Math.min(start + 1, end);
        for (int i = start; i < n; ++i) {
            ((Collection)batches).add(new GetNextBatchRangeResponse.Batch.Builder().batch_range(DynamoDbKeyRangeCodec.encodeKeyRange$client_dynamodb$default(this.keyRangeCodec, i, i + 1, count, null, 8, null)).matching_record_count(Long.valueOf(1L)).scanned_record_count(Long.valueOf(1L)).build());
        }
        GetNextBatchRangeResponse getNextBatchRangeResponse = new GetNextBatchRangeResponse.Builder().batches(batches).build();
        Intrinsics.checkNotNullExpressionValue((Object)getNextBatchRangeResponse, (String)"build(...)");
        return getNextBatchRangeResponse;
    }

    @NotNull
    public RunBatchResponse runBatch(@NotNull RunBatchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        KeyRange keyRange = request.batch_range;
        Intrinsics.checkNotNullExpressionValue((Object)keyRange, (String)"batch_range");
        DynamoDbKeyRange keyRange2 = this.keyRangeCodec.decodeKeyRange$client_dynamodb(keyRange);
        if (!(keyRange2.getEnd() == keyRange2.getStart() + 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        BackfillConfig config = this.parametersOperator.constructBackfillConfig(request);
        Map lastEvaluatedKey = null;
        lastEvaluatedKey = keyRange2.getLastEvaluatedKey();
        Stopwatch stopwatch = Stopwatch.createStarted();
        do {
            DynamoDBScanExpression dynamoDBScanExpression;
            DynamoDBScanExpression $this$runBatch_u24lambda_u243 = dynamoDBScanExpression = new DynamoDBScanExpression();
            boolean bl = false;
            $this$runBatch_u24lambda_u243.setSegment(Integer.valueOf(keyRange2.getStart()));
            $this$runBatch_u24lambda_u243.setTotalSegments(Integer.valueOf(keyRange2.getCount()));
            $this$runBatch_u24lambda_u243.setLimit(Integer.valueOf((int)request.batch_size.longValue()));
            if (lastEvaluatedKey != null) {
                $this$runBatch_u24lambda_u243.setExclusiveStartKey(lastEvaluatedKey);
            }
            $this$runBatch_u24lambda_u243.setFilterExpression(this.getBackfill().filterExpression(config));
            $this$runBatch_u24lambda_u243.setExpressionAttributeValues(this.getBackfill().expressionAttributeValues(config));
            $this$runBatch_u24lambda_u243.setExpressionAttributeNames(this.getBackfill().expressionAttributeNames(config));
            $this$runBatch_u24lambda_u243.setIndexName(this.getBackfill().indexName(config));
            DynamoDBScanExpression scanRequest = dynamoDBScanExpression;
            ScanResultPage result = this.dynamoDb.scanPage(JvmClassMappingKt.getJavaClass(this.getBackfill().getItemType()), scanRequest);
            Backfill backfill = this.getBackfill();
            List list = result.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResults(...)");
            backfill.runBatch(list, config);
            lastEvaluatedKey = result.getLastEvaluatedKey();
        } while (stopwatch.elapsed().compareTo(Duration.ofMillis(1000L)) <= 0 && lastEvaluatedKey != null);
        Map map = lastEvaluatedKey;
        RunBatchResponse runBatchResponse = new RunBatchResponse.Builder().remaining_batch_range(map != null ? this.toKeyRange(map, keyRange2) : null).build();
        Intrinsics.checkNotNullExpressionValue((Object)runBatchResponse, (String)"build(...)");
        return runBatchResponse;
    }

    private final KeyRange toKeyRange(Map<String, ? extends AttributeValue> $this$toKeyRange, DynamoDbKeyRange originalRange) {
        if (!(originalRange.getStart() + 1 == originalRange.getEnd())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.keyRangeCodec.encodeKeyRange$client_dynamodb(originalRange.getStart(), originalRange.getEnd(), originalRange.getCount(), $this$toKeyRange);
    }
}

