/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.jooq.internal;

import app.cash.backfila.client.BackfillConfig;
import app.cash.backfila.client.jooq.JooqBackfill;
import app.cash.backfila.client.jooq.internal.OpenKeyRange;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeRequest;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeResponse;
import com.google.common.base.Stopwatch;
import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Record1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u00020\u00050\u0004B7\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0014J#\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lapp/cash/backfila/client/jooq/internal/BatchRangeIterator;", "K", "Param", "", "Lcom/google/common/collect/AbstractIterator;", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeResponse$Batch;", "jooqBackfill", "Lapp/cash/backfila/client/jooq/JooqBackfill;", "session", "Lorg/jooq/DSLContext;", "request", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeRequest;", "config", "Lapp/cash/backfila/client/BackfillConfig;", "(Lapp/cash/backfila/client/jooq/JooqBackfill;Lorg/jooq/DSLContext;Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeRequest;Lapp/cash/backfila/client/BackfillConfig;)V", "nextKeyRange", "Lapp/cash/backfila/client/jooq/internal/OpenKeyRange;", "timeElapsed", "Lkotlin/Function0;", "", "computeNext", "determineScannedCount", "", "keyRange", "end", "(Lapp/cash/backfila/client/jooq/internal/OpenKeyRange;Ljava/lang/Object;)I", "selectKeyValues", "", "timer", "timeLimitMs", "", "client-jooq"})
public final class BatchRangeIterator<K, Param>
extends AbstractIterator<GetNextBatchRangeResponse.Batch> {
    @NotNull
    private final JooqBackfill<K, Param> jooqBackfill;
    @NotNull
    private final DSLContext session;
    @NotNull
    private final GetNextBatchRangeRequest request;
    @NotNull
    private final BackfillConfig<Param> config;
    @NotNull
    private final Function0<Boolean> timeElapsed;
    @NotNull
    private OpenKeyRange<K> nextKeyRange;

    public BatchRangeIterator(@NotNull JooqBackfill<K, Param> jooqBackfill, @NotNull DSLContext session, @NotNull GetNextBatchRangeRequest request, @NotNull BackfillConfig<Param> config) {
        Function0<Boolean> function0;
        Intrinsics.checkNotNullParameter(jooqBackfill, (String)"jooqBackfill");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.jooqBackfill = jooqBackfill;
        this.session = session;
        this.request = request;
        this.config = config;
        if (this.request.compute_time_limit_ms == null) {
            function0 = 1.INSTANCE;
        } else {
            Long l = this.request.compute_time_limit_ms;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"request.compute_time_limit_ms");
            function0 = this.timer(((Number)l).longValue());
        }
        this.timeElapsed = function0;
        this.nextKeyRange = OpenKeyRange.Companion.initialRangeFor(this.jooqBackfill, this.request, this.session);
    }

    private final Function0<Boolean> timer(long timeLimitMs) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        return (Function0)new Function0<Boolean>(stopwatch, timeLimitMs){
            final /* synthetic */ Stopwatch $stopwatch;
            final /* synthetic */ long $timeLimitMs;
            {
                this.$stopwatch = $stopwatch;
                this.$timeLimitMs = $timeLimitMs;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$stopwatch.elapsed(TimeUnit.MILLISECONDS) > this.$timeLimitMs;
            }
        };
    }

    @Nullable
    protected GetNextBatchRangeResponse.Batch computeNext() {
        if (((Boolean)this.timeElapsed.invoke()).booleanValue() || this.request.backfill_range.start == null) {
            return (GetNextBatchRangeResponse.Batch)this.endOfData();
        }
        OpenKeyRange<K> keyRange = this.nextKeyRange;
        List<K> keyValues = this.selectKeyValues(keyRange);
        K start = keyRange.determineStart(keyValues);
        K end = keyRange.determineEnd(keyValues);
        int scannedCount = this.determineScannedCount(keyRange, end);
        if (scannedCount == 0) {
            return (GetNextBatchRangeResponse.Batch)this.endOfData();
        }
        this.nextKeyRange = keyRange.nextRangeFor(end);
        return new GetNextBatchRangeResponse.Batch.Builder().batch_range(this.jooqBackfill.buildKeyRange(start, end)).scanned_record_count(Long.valueOf(scannedCount)).matching_record_count(Long.valueOf(keyValues.size())).build();
    }

    private final List<K> selectKeyValues(OpenKeyRange<K> keyRange) {
        Long limit = Intrinsics.areEqual((Object)this.request.precomputing, (Object)true) ? this.request.scan_size : this.request.batch_size;
        List list = this.session.select((Collection)this.jooqBackfill.getCompoundKeyFields()).from(this.jooqBackfill.getTable()).where(this.jooqBackfill.filterCondition(this.config)).and(keyRange.betweenStartAndUpperBoundCondition()).orderBy((Collection)this.jooqBackfill.getCompoundKeyFields()).limit((Number)limit).fetch(arg_0 -> BatchRangeIterator.selectKeyValues$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"session.select(jooqBackf\u2026ackfill.recordToKey(it) }");
        return list;
    }

    private final int determineScannedCount(OpenKeyRange<K> keyRange, K end) {
        Integer n;
        Record1 record1 = (Record1)this.session.selectCount().from(this.jooqBackfill.getTable()).where(keyRange.betweenStartAndEndCondition(end)).fetchOne();
        Integer n2 = n = record1 != null ? (Integer)record1.value1() : null;
        if (n == null) {
            throw new IllegalStateException("A SQL count will always return back a row");
        }
        return n;
    }

    private static final Object selectKeyValues$lambda-0(BatchRangeIterator this$0, Record it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        JooqBackfill jooqBackfill = this$0.jooqBackfill;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return jooqBackfill.recordToKey(it);
    }
}

