/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.jooq.internal;

import app.cash.backfila.client.Backfill;
import app.cash.backfila.client.BackfillConfig;
import app.cash.backfila.client.jooq.BackfillBatch;
import app.cash.backfila.client.jooq.JooqBackfill;
import app.cash.backfila.client.jooq.internal.BatchRangeIterator;
import app.cash.backfila.client.jooq.internal.JooqBackfillOperator;
import app.cash.backfila.client.spi.BackfilaParametersOperator;
import app.cash.backfila.client.spi.BackfillOperator;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeRequest;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeResponse;
import app.cash.backfila.protos.clientservice.KeyRange;
import app.cash.backfila.protos.clientservice.PrepareBackfillRequest;
import app.cash.backfila.protos.clientservice.PrepareBackfillResponse;
import app.cash.backfila.protos.clientservice.RunBatchRequest;
import app.cash.backfila.protos.clientservice.RunBatchResponse;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.SelectConditionStep;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004B)\b\u0000\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J%\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u001cH\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/cash/backfila/client/jooq/internal/JooqBackfillOperator;", "K", "Param", "", "Lapp/cash/backfila/client/spi/BackfillOperator;", "backfill", "Lapp/cash/backfila/client/jooq/JooqBackfill;", "parametersOperator", "Lapp/cash/backfila/client/spi/BackfilaParametersOperator;", "(Lapp/cash/backfila/client/jooq/JooqBackfill;Lapp/cash/backfila/client/spi/BackfilaParametersOperator;)V", "getBackfill", "()Lapp/cash/backfila/client/jooq/JooqBackfill;", "computeOverallRange", "Lapp/cash/backfila/protos/clientservice/KeyRange;", "partitionName", "", "request", "Lapp/cash/backfila/protos/clientservice/PrepareBackfillRequest;", "computedRangeStart", "(Ljava/lang/String;Lapp/cash/backfila/protos/clientservice/PrepareBackfillRequest;Ljava/lang/Object;)Lapp/cash/backfila/protos/clientservice/KeyRange;", "getNextBatchRange", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeResponse;", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeRequest;", "name", "prepareBackfill", "Lapp/cash/backfila/protos/clientservice/PrepareBackfillResponse;", "runBatch", "Lapp/cash/backfila/protos/clientservice/RunBatchResponse;", "Lapp/cash/backfila/protos/clientservice/RunBatchRequest;", "client-jooq"})
public final class JooqBackfillOperator<K, Param>
implements BackfillOperator {
    @NotNull
    private final JooqBackfill<K, Param> backfill;
    @NotNull
    private final BackfilaParametersOperator<Param> parametersOperator;

    public JooqBackfillOperator(@NotNull JooqBackfill<K, Param> backfill, @NotNull BackfilaParametersOperator<Param> parametersOperator) {
        Intrinsics.checkNotNullParameter(backfill, (String)"backfill");
        Intrinsics.checkNotNullParameter(parametersOperator, (String)"parametersOperator");
        this.backfill = backfill;
        this.parametersOperator = parametersOperator;
    }

    @NotNull
    public JooqBackfill<K, Param> getBackfill() {
        return this.backfill;
    }

    @NotNull
    public String name() {
        String string = this.getBackfill().getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"backfill.javaClass.name");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PrepareBackfillResponse prepareBackfill(@NotNull PrepareBackfillRequest request) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.getBackfill().prepareAndValidateBackfill(this.parametersOperator.constructBackfillConfig(request));
        Iterable $this$map$iv = this.getBackfill().getShardedTransacterMap().keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void partitionName;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PrepareBackfillResponse.Partition.Builder().partition_name((String)partitionName).backfill_range(this.computeOverallRange((String)partitionName, request)).estimated_record_count(null).build());
        }
        List partitions = (List)destination$iv$iv;
        PrepareBackfillResponse prepareBackfillResponse = new PrepareBackfillResponse.Builder().partitions(partitions).build();
        Intrinsics.checkNotNullExpressionValue((Object)prepareBackfillResponse, (String)"Builder().partitions(partitions).build()");
        return prepareBackfillResponse;
    }

    @NotNull
    public GetNextBatchRangeResponse getNextBatchRange(@NotNull GetNextBatchRangeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Long l = request.compute_count_limit;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"request.compute_count_limit");
        if (!(((Number)l).longValue() > 0L)) {
            boolean bl = false;
            String string = "batch limit must be > 0";
            throw new IllegalStateException(string.toString());
        }
        if (request.backfill_range.start == null) {
            GetNextBatchRangeResponse getNextBatchRangeResponse = new GetNextBatchRangeResponse.Builder().batches(CollectionsKt.emptyList()).build();
            Intrinsics.checkNotNullExpressionValue((Object)getNextBatchRangeResponse, (String)"Builder()\n        .batch\u2026yList())\n        .build()");
            return getNextBatchRangeResponse;
        }
        BackfillConfig config = this.parametersOperator.constructBackfillConfig(request);
        Object t = this.getBackfill().inTransactionReturning(this.name() + "#JooqBackfillOperator#getNextBatchRange", request.partition_name, (Function1)new Function1<DSLContext, GetNextBatchRangeResponse>(this, request, config){
            final /* synthetic */ JooqBackfillOperator<K, Param> this$0;
            final /* synthetic */ GetNextBatchRangeRequest $request;
            final /* synthetic */ BackfillConfig<Param> $config;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$config = $config;
                super(1);
            }

            public final GetNextBatchRangeResponse invoke(@NotNull DSLContext dslContext) {
                Intrinsics.checkNotNullParameter((Object)dslContext, (String)"dslContext");
                GetNextBatchRangeResponse.Builder builder = new GetNextBatchRangeResponse.Builder();
                Stream stream = Streams.stream((Iterator)((Iterator)((Object)new BatchRangeIterator<K, Param>(this.this$0.getBackfill(), dslContext, this.$request, this.$config))));
                Long l = this.$request.compute_count_limit;
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"request.compute_count_limit");
                return builder.batches(stream.limit(((Number)l).longValue()).collect(Collectors.toList())).build();
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"override fun getNextBatc\u2026       .build()\n    }\n  }");
        return (GetNextBatchRangeResponse)t;
    }

    @NotNull
    public RunBatchResponse runBatch(@NotNull RunBatchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BackfillConfig config = this.parametersOperator.constructBackfillConfig(request);
        Object t = this.getBackfill().inTransactionReturning(this.name() + "#JooqBackfillOperator#runBatch", request.partition_name, (Function1)new Function1<DSLContext, List<K>>(this, config, request){
            final /* synthetic */ JooqBackfillOperator<K, Param> this$0;
            final /* synthetic */ BackfillConfig<Param> $config;
            final /* synthetic */ RunBatchRequest $request;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                this.$request = $request;
                super(1);
            }

            @NotNull
            public final List<K> invoke(@NotNull DSLContext dslContext) {
                Intrinsics.checkNotNullParameter((Object)dslContext, (String)"dslContext");
                SelectConditionStep selectConditionStep = dslContext.select((Collection)this.this$0.getBackfill().getCompoundKeyFields()).from(this.this$0.getBackfill().getTable()).where(this.this$0.getBackfill().filterCondition(this.$config));
                Backfill backfill = this.this$0.getBackfill();
                Backfill backfill2 = this.this$0.getBackfill();
                ByteString byteString = this.$request.batch_range.start;
                Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"request.batch_range.start");
                SelectConditionStep selectConditionStep2 = selectConditionStep.and(backfill.compareCompoundKey(backfill2.fromByteString(byteString), runBatch.keysInRange.1.INSTANCE));
                Backfill backfill3 = this.this$0.getBackfill();
                Backfill backfill4 = this.this$0.getBackfill();
                ByteString byteString2 = this.$request.batch_range.end;
                Intrinsics.checkNotNullExpressionValue((Object)byteString2, (String)"request.batch_range.end");
                return selectConditionStep2.and(backfill3.compareCompoundKey(backfill4.fromByteString(byteString2), runBatch.keysInRange.2.INSTANCE)).orderBy((Collection)this.this$0.getBackfill().getCompoundKeyFields()).fetch(arg_0 -> runBatch.keysInRange.1.invoke$lambda-0(this.this$0, arg_0));
            }

            private static final Object invoke$lambda-0(JooqBackfillOperator this$0, Record it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Backfill backfill = this$0.getBackfill();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return backfill.recordToKey(it);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"K, Param : Any> internal\u2026nse.Builder().build()\n  }");
        List keysInRange2 = (List)t;
        Backfill backfill = this.getBackfill();
        String string = request.partition_name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.partition_name");
        backfill.backfill(new BackfillBatch(string, this.getBackfill().getTransacter(request.partition_name), keysInRange2, config));
        RunBatchResponse runBatchResponse = new RunBatchResponse.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)runBatchResponse, (String)"Builder().build()");
        return runBatchResponse;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KeyRange computeOverallRange(String partitionName, PrepareBackfillRequest request) {
        KeyRange keyRange;
        Object k = this.getBackfill().getUnfilteredBoundaryKeyValue(partitionName, computeOverallRange.1.INSTANCE);
        if (k != null) {
            Object computedRangeStart = k;
            boolean bl = false;
            KeyRange keyRange2 = this.computeOverallRange(partitionName, request, computedRangeStart);
            if (keyRange2 != null) {
                keyRange = keyRange2;
                return keyRange;
            }
        }
        KeyRange keyRange3 = new KeyRange.Builder().build();
        keyRange = keyRange3;
        Intrinsics.checkNotNullExpressionValue((Object)keyRange3, (String)"Builder().build()");
        return keyRange;
    }

    private final KeyRange computeOverallRange(String partitionName, PrepareBackfillRequest request, K computedRangeStart) {
        ByteString byteString;
        ByteString byteString2;
        if (request.range == null || request.range.start == null) {
            byteString2 = this.getBackfill().toByteString(computedRangeStart);
        } else {
            ByteString byteString3 = request.range.start;
            byteString2 = byteString3;
            Intrinsics.checkNotNullExpressionValue((Object)byteString3, (String)"{\n        request.range.start\n      }");
        }
        ByteString rangeStart = byteString2;
        if (request.range == null || request.range.end == null) {
            Object k = this.getBackfill().getUnfilteredBoundaryKeyValue(partitionName, computeOverallRange.rangeEnd.1.INSTANCE);
            if (k == null) {
                throw new IllegalStateException("We should always get the last key value");
            }
            byteString = this.getBackfill().toByteString(k);
        } else {
            ByteString byteString4 = request.range.end;
            byteString = byteString4;
            Intrinsics.checkNotNullExpressionValue((Object)byteString4, (String)"{\n        request.range.end\n      }");
        }
        ByteString rangeEnd2 = byteString;
        KeyRange keyRange = new KeyRange.Builder().start(rangeStart).end(rangeEnd2).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyRange, (String)"Builder()\n      .start(r\u2026(rangeEnd)\n      .build()");
        return keyRange;
    }
}

