/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.s3.internal;

import app.cash.backfila.client.BackfillConfig;
import app.cash.backfila.client.PrepareBackfillConfig;
import app.cash.backfila.client.s3.S3DatasourceBackfill;
import app.cash.backfila.client.s3.shim.S3Service;
import app.cash.backfila.client.spi.BackfilaParametersOperator;
import app.cash.backfila.client.spi.BackfillOperator;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeRequest;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeResponse;
import app.cash.backfila.protos.clientservice.KeyRange;
import app.cash.backfila.protos.clientservice.PrepareBackfillRequest;
import app.cash.backfila.protos.clientservice.PrepareBackfillResponse;
import app.cash.backfila.protos.clientservice.RunBatchRequest;
import app.cash.backfila.protos.clientservice.RunBatchResponse;
import com.google.common.base.Stopwatch;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004:\u0001\u001dB/\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lapp/cash/backfila/client/s3/internal/S3DatasourceBackfillOperator;", "R", "", "P", "Lapp/cash/backfila/client/spi/BackfillOperator;", "backfill", "Lapp/cash/backfila/client/s3/S3DatasourceBackfill;", "parametersOperator", "Lapp/cash/backfila/client/spi/BackfilaParametersOperator;", "s3Service", "Lapp/cash/backfila/client/s3/shim/S3Service;", "(Lapp/cash/backfila/client/s3/S3DatasourceBackfill;Lapp/cash/backfila/client/spi/BackfilaParametersOperator;Lapp/cash/backfila/client/s3/shim/S3Service;)V", "getBackfill", "()Lapp/cash/backfila/client/s3/S3DatasourceBackfill;", "getNextBatchRange", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeResponse;", "request", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeRequest;", "name", "", "prepareBackfill", "Lapp/cash/backfila/protos/clientservice/PrepareBackfillResponse;", "Lapp/cash/backfila/protos/clientservice/PrepareBackfillRequest;", "runBatch", "Lapp/cash/backfila/protos/clientservice/RunBatchResponse;", "Lapp/cash/backfila/protos/clientservice/RunBatchRequest;", "decode", "Lapp/cash/backfila/client/s3/internal/S3DatasourceBackfillOperator$DecodedRange;", "Lapp/cash/backfila/protos/clientservice/KeyRange;", "DecodedRange", "client-s3"})
public final class S3DatasourceBackfillOperator<R, P>
implements BackfillOperator {
    @NotNull
    private final S3DatasourceBackfill<R, P> backfill;
    @NotNull
    private final BackfilaParametersOperator<P> parametersOperator;
    @NotNull
    private final S3Service s3Service;

    public S3DatasourceBackfillOperator(@NotNull S3DatasourceBackfill<R, P> backfill, @NotNull BackfilaParametersOperator<P> parametersOperator, @NotNull S3Service s3Service) {
        Intrinsics.checkNotNullParameter(backfill, (String)"backfill");
        Intrinsics.checkNotNullParameter(parametersOperator, (String)"parametersOperator");
        Intrinsics.checkNotNullParameter((Object)s3Service, (String)"s3Service");
        this.backfill = backfill;
        this.parametersOperator = parametersOperator;
        this.s3Service = s3Service;
    }

    @NotNull
    public S3DatasourceBackfill<R, P> getBackfill() {
        return this.backfill;
    }

    @NotNull
    public String name() {
        String string = this.getBackfill().getClass().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"backfill.javaClass.toString()");
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public PrepareBackfillResponse prepareBackfill(@NotNull PrepareBackfillRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        config = this.parametersOperator.constructBackfillConfig(request);
        this.getBackfill().validate(config);
        v0 = request.range;
        if ((v0 != null ? v0.start : null) != null) ** GOTO lbl-1000
        v1 = request.range;
        if ((v1 != null ? v1.end : null) == null) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (!v2) {
            $i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$1 = false;
            $i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$1 = "Range is currently unsupported for S3 Backfils";
            throw new IllegalArgumentException($i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$1.toString());
        }
        pathPrefix = this.getBackfill().getPrefix(config);
        fileKeys = this.s3Service.listFiles(this.getBackfill().getBucket(config), pathPrefix);
        if (!(((Collection)fileKeys).isEmpty() == false)) {
            $i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$2 = false;
            $i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$2 = "No files found for bucket:" + this.getBackfill().getBucket(config) + " prefix:" + pathPrefix + ". At least one file must exist.";
            throw new IllegalArgumentException($i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$2.toString());
        }
        if (!(fileKeys.size() <= 100)) {
            $i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$3 = false;
            $i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$3 = "Listing files matching the prefix contains " + fileKeys.size() + " which is more than 100 files. Check your prefix. First 3 file keys " + CollectionsKt.slice(fileKeys, (IntRange)new IntRange(0, 2));
            throw new IllegalArgumentException($i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$3.toString());
        }
        $this$map$iv = fileKeys;
        $i$f$map = false;
        var8_14 = $this$map$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            var13_27 = (String)item$iv$iv;
            var17_31 = destination$iv$iv /* !! */ ;
            $i$a$-map-S3DatasourceBackfillOperator$prepareBackfill$postfixes$1 = false;
            var17_31.add(StringsKt.removePrefix((String)it, (CharSequence)pathPrefix));
        }
        postfixes = (List)destination$iv$iv /* !! */ ;
        $this$filter$iv = postfixes;
        $i$f$filter = false;
        destination$iv$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-S3DatasourceBackfillOperator$prepareBackfill$invalidPostfixes$1 = false;
            if (!(ByteString.Companion.encodeUtf8(it).size() > 300)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        invalidPostfixes = (List)destination$iv$iv;
        if (!invalidPostfixes.isEmpty()) {
            $i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$4 = false;
            $i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$4 = "Found invalid postfixes: " + invalidPostfixes;
            throw new IllegalArgumentException($i$a$-require-S3DatasourceBackfillOperator$prepareBackfill$4.toString());
        }
        $this$map$iv = postfixes;
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (E item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-S3DatasourceBackfillOperator$prepareBackfill$invalidPostfixes$1 = (String)item$iv$iv;
            var17_31 = destination$iv$iv;
            $i$a$-map-S3DatasourceBackfillOperator$prepareBackfill$partitions$1 = false;
            var17_31.add(new PrepareBackfillResponse.Partition.Builder().partition_name((String)it).backfill_range(new KeyRange.Builder().start(ByteString.Companion.encodeUtf8("0")).build()).build());
        }
        partitions = (List)destination$iv$iv;
        v3 = new PrepareBackfillResponse.Builder().partitions(partitions).build();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"Builder()\n      .partiti\u2026artitions)\n      .build()");
        return v3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public GetNextBatchRangeResponse getNextBatchRange(@NotNull GetNextBatchRangeRequest request) {
        List list;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PrepareBackfillConfig config = this.parametersOperator.constructBackfillConfig(request).prepareConfig();
        String pathPrefix = this.getBackfill().getPrefix(config);
        int batchSize = (int)request.batch_size.longValue();
        Object object = request.previous_end_key;
        long previousEndKey = object != null && (object = object.utf8()) != null ? Long.parseLong((String)object) : 0L;
        long fileSize = this.s3Service.getFileSize(this.getBackfill().getBucket(config), pathPrefix + request.partition_name);
        if (previousEndKey == fileSize) {
            GetNextBatchRangeResponse getNextBatchRangeResponse = new GetNextBatchRangeResponse.Builder().batches(CollectionsKt.emptyList()).build();
            Intrinsics.checkNotNullExpressionValue((Object)getNextBatchRangeResponse, (String)"Builder().batches(\n     \u2026listOf(),\n      ).build()");
            return getNextBatchRangeResponse;
        }
        if (Intrinsics.areEqual((Object)request.precomputing, (Object)true)) {
            if (!(previousEndKey == 0L)) {
                boolean $i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$22 = false;
                String $i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$22 = "The file size changed between batch calculations.";
                throw new IllegalArgumentException($i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$22.toString());
            }
            GetNextBatchRangeResponse getNextBatchRangeResponse = new GetNextBatchRangeResponse.Builder().batches(CollectionsKt.listOf((Object)new GetNextBatchRangeResponse.Batch.Builder().batch_range(new KeyRange(ByteString.Companion.encodeUtf8("0"), ByteString.Companion.encodeUtf8(String.valueOf(fileSize)))).matching_record_count(Long.valueOf(fileSize)).scanned_record_count(Long.valueOf(fileSize)).build())).build();
            Intrinsics.checkNotNullExpressionValue((Object)getNextBatchRangeResponse, (String)"Builder().batches(\n     \u2026       ),\n      ).build()");
            return getNextBatchRangeResponse;
        }
        BufferedSource fileStream = this.s3Service.getFileStreamStartingAt(this.getBackfill().getBucket(config), pathPrefix + request.partition_name, previousEndKey);
        Closeable closeable = (Closeable)fileStream;
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Object $i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$result$1$222;
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            List recordBytes = new ArrayList();
            Stopwatch stopwatch = Stopwatch.createStarted();
            while (!fileStream.exhausted()) {
                int n = recordBytes.size();
                int n2 = n / batchSize;
                if ((n ^ batchSize) < 0 && n2 * batchSize != n) {
                    --n2;
                }
                long l = n2;
                Long l2 = request.compute_count_limit;
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"request.compute_count_limit");
                if (l >= ((Number)l2).longValue()) break;
                if (request.compute_time_limit_ms != null) {
                    long l3 = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                    Long l4 = request.compute_time_limit_ms;
                    Intrinsics.checkNotNullExpressionValue((Object)l4, (String)"request.compute_time_limit_ms");
                    if (l3 > ((Number)l4).longValue()) break;
                }
                BufferedSource peekSource = fileStream.peek();
                long bytes = this.getBackfill().getRecordStrategy().calculateNextRecordBytes(peekSource);
                if (!(bytes > 0L)) {
                    boolean $i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$result$1$222 = false;
                    String $i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$result$1$222 = "Failed to consume any streamed bytes for " + request.partition_name;
                    throw new IllegalArgumentException($i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$result$1$222.toString());
                }
                $i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$result$1$222 = bytes;
                ((Collection)recordBytes).add($i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$result$1$222);
                fileStream.skip(bytes);
            }
            long offset = 0L;
            offset = previousEndKey;
            List batches = new ArrayList();
            Iterable $this$map$iv = CollectionsKt.chunked((Iterable)recordBytes, (int)batchSize);
            boolean $i$f$map = false;
            $i$a$-require-S3DatasourceBackfillOperator$getNextBatchRange$result$1$222 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                List list2 = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(CollectionsKt.sumOfLong((Iterable)((Iterable)it2)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long size = ((Number)element$iv).longValue();
                boolean bl3 = false;
                ((Collection)batches).add(new GetNextBatchRangeResponse.Batch.Builder().batch_range(new KeyRange(ByteString.Companion.encodeUtf8(String.valueOf(offset)), ByteString.Companion.encodeUtf8(String.valueOf(offset + size)))).matching_record_count(Long.valueOf(size)).scanned_record_count(Long.valueOf(size)).build());
                offset += size;
            }
            list = batches;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        List result = list;
        GetNextBatchRangeResponse getNextBatchRangeResponse = new GetNextBatchRangeResponse.Builder().batches(result).build();
        Intrinsics.checkNotNullExpressionValue((Object)getNextBatchRangeResponse, (String)"Builder()\n      .batches(result)\n      .build()");
        return getNextBatchRangeResponse;
    }

    @NotNull
    public RunBatchResponse runBatch(@NotNull RunBatchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BackfillConfig config = this.parametersOperator.constructBackfillConfig(request);
        String pathPrefix = this.getBackfill().getPrefix(config.prepareConfig());
        KeyRange keyRange = request.batch_range;
        Intrinsics.checkNotNullExpressionValue((Object)keyRange, (String)"request.batch_range");
        DecodedRange batchRange = this.decode(keyRange);
        batchRange.getEnd();
        long amazonS3BatchEnd = batchRange.getEnd() - 1L;
        ByteString byteString = this.s3Service.getWithSeek(this.getBackfill().getBucket(config.prepareConfig()), pathPrefix + request.partition_name, batchRange.getStart(), amazonS3BatchEnd);
        List batch = this.getBackfill().getRecordStrategy().bytesToRecords(byteString);
        this.getBackfill().runBatch(batch, config);
        RunBatchResponse runBatchResponse = new RunBatchResponse.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)runBatchResponse, (String)"Builder()\n      .build()");
        return runBatchResponse;
    }

    private final DecodedRange decode(KeyRange $this$decode) {
        long start = Long.parseLong($this$decode.start.utf8());
        long end = Long.parseLong($this$decode.end.utf8());
        return new DecodedRange(start, end);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lapp/cash/backfila/client/s3/internal/S3DatasourceBackfillOperator$DecodedRange;", "", "start", "", "end", "(JJ)V", "getEnd", "()J", "getStart", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "client-s3"})
    public static final class DecodedRange {
        private final long start;
        private final long end;

        public DecodedRange(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public final long getStart() {
            return this.start;
        }

        public final long getEnd() {
            return this.end;
        }

        public final long component1() {
            return this.start;
        }

        public final long component2() {
            return this.end;
        }

        @NotNull
        public final DecodedRange copy(long start, long end) {
            return new DecodedRange(start, end);
        }

        public static /* synthetic */ DecodedRange copy$default(DecodedRange decodedRange, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = decodedRange.start;
            }
            if ((n & 2) != 0) {
                l2 = decodedRange.end;
            }
            return decodedRange.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "DecodedRange(start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.start);
            result = result * 31 + Long.hashCode(this.end);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecodedRange)) {
                return false;
            }
            DecodedRange decodedRange = (DecodedRange)other;
            if (this.start != decodedRange.start) {
                return false;
            }
            return this.end == decodedRange.end;
        }
    }
}

