//[client-s3](../../../index.md)/[app.cash.backfila.client.s3](../index.md)/[S3DatasourceBackfill](index.md)

# S3DatasourceBackfill

[jvm]\
abstract class [S3DatasourceBackfill](index.md)&lt;[R](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [P](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; : Backfill

## Constructors

| | |
|---|---|
| [S3DatasourceBackfill](-s3-datasource-backfill.md) | [jvm]<br>constructor() |

## Properties

| Name | Summary |
|---|---|
| [recordStrategy](record-strategy.md) | [jvm]<br>abstract val [recordStrategy](record-strategy.md): [RecordStrategy](../../app.cash.backfila.client.s3.record/-record-strategy/index.md)&lt;[R](index.md)&gt;<br>Produces records from the S3 file. |
| [staticPrefix](static-prefix.md) | [jvm]<br>open val [staticPrefix](static-prefix.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Static element of the prefix, this is a helper used by the default getPrefix. Warning: if getPrefix is overridden then this might not be used. |

## Functions

| Name | Summary |
|---|---|
| [getBucket](get-bucket.md) | [jvm]<br>abstract fun [getBucket](get-bucket.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Bucket where the S3 files are located |
| [getPrefix](get-prefix.md) | [jvm]<br>open fun [getPrefix](get-prefix.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Calculates the prefix of S3 objects to process. Defaults to staticPrefix. |
| [runBatch](run-batch.md) | [jvm]<br>open fun [runBatch](run-batch.md)(records: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;@[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)[R](index.md)&gt;, config: BackfillConfig&lt;[P](index.md)&gt;)<br>Called for each batch of records. Override in a backfill to process all records in a batch. |
| [runOne](run-one.md) | [jvm]<br>open fun [runOne](run-one.md)(record: [R](index.md), config: BackfillConfig&lt;[P](index.md)&gt;)<br>Called for each record. Override in a backfill to process one record at a time. |
| [validate](validate.md) | [jvm]<br>open fun [validate](validate.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;)<br>Override this and throw an exception to prevent the backfill from being created. This is also a good place to do any prep work before batches are run. |
