/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.s3.internal;

import app.cash.backfila.client.s3.ForS3Backend;
import app.cash.backfila.client.s3.shim.S3Service;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/cash/backfila/client/s3/internal/RealS3Service;", "Lapp/cash/backfila/client/s3/shim/S3Service;", "amazonS3", "Lcom/amazonaws/services/s3/AmazonS3;", "(Lcom/amazonaws/services/s3/AmazonS3;)V", "getFileSize", "", "bucket", "", "key", "getFileStreamStartingAt", "Lokio/BufferedSource;", "start", "getWithSeek", "Lokio/ByteString;", "seekStart", "seekEnd", "listFiles", "", "keyPrefix", "client-s3"})
@SourceDebugExtension(value={"SMAP\nRealS3Service.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealS3Service.kt\napp/cash/backfila/client/s3/internal/RealS3Service\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1549#2:47\n1620#2,3:48\n*S KotlinDebug\n*F\n+ 1 RealS3Service.kt\napp/cash/backfila/client/s3/internal/RealS3Service\n*L\n23#1:47\n23#1:48,3\n*E\n"})
public final class RealS3Service
implements S3Service {
    @NotNull
    private final AmazonS3 amazonS3;

    @Inject
    public RealS3Service(@ForS3Backend @NotNull AmazonS3 amazonS3) {
        Intrinsics.checkNotNullParameter((Object)amazonS3, (String)"amazonS3");
        this.amazonS3 = amazonS3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> listFiles(@NotNull String bucket, @NotNull String keyPrefix) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
        ObjectListing s3ObjectListing = this.amazonS3.listObjects(bucket, keyPrefix);
        List summaries = s3ObjectListing.getObjectSummaries();
        Intrinsics.checkNotNull((Object)summaries);
        Iterable $this$map$iv = summaries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            S3ObjectSummary s3ObjectSummary = (S3ObjectSummary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public long getFileSize(@NotNull String bucket, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(bucket, key);
        return objectMetadata.getContentLength();
    }

    @Override
    @NotNull
    public BufferedSource getFileStreamStartingAt(@NotNull String bucket, @NotNull String key, long start) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        S3Object s3Object = this.amazonS3.getObject(new GetObjectRequest(bucket, key).withRange(start));
        S3ObjectInputStream s3ObjectInputStream = s3Object.getObjectContent();
        Intrinsics.checkNotNullExpressionValue((Object)s3ObjectInputStream, (String)"getObjectContent(...)");
        return Okio.buffer((Source)Okio.source((InputStream)((InputStream)s3ObjectInputStream)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ByteString getWithSeek(@NotNull String bucket, @NotNull String key, long seekStart, long seekEnd) {
        ByteString byteString;
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        S3Object s3Object = this.amazonS3.getObject(new GetObjectRequest(bucket, key).withRange(seekStart, seekEnd));
        Buffer $this$getWithSeek_u24lambda_u242 = new Buffer();
        boolean bl = false;
        Closeable closeable = (Closeable)s3Object;
        Throwable throwable = null;
        try {
            S3Object it = (S3Object)closeable;
            boolean bl2 = false;
            S3ObjectInputStream s3ObjectInputStream = it.getObjectContent();
            Intrinsics.checkNotNullExpressionValue((Object)s3ObjectInputStream, (String)"getObjectContent(...)");
            $this$getWithSeek_u24lambda_u242.writeAll(Okio.source((InputStream)((InputStream)s3ObjectInputStream)));
            byteString = $this$getWithSeek_u24lambda_u242.readByteString();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byteString;
    }
}

