/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.s3.shim;

import app.cash.backfila.client.s3.shim.S3Service;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\bJ\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R&\u0010\u0004\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lapp/cash/backfila/client/s3/shim/FakeS3Service;", "Lapp/cash/backfila/client/s3/shim/S3Service;", "<init>", "()V", "files", "", "Lkotlin/Pair;", "", "Lokio/ByteString;", "loadResourceDirectory", "", "resourcePath", "addBucketFiles", "bucketDirectory", "Ljava/io/File;", "add", "bucket", "key", "fileContent", "listFiles", "", "keyPrefix", "getFileStreamStartingAt", "Lokio/BufferedSource;", "start", "", "getWithSeek", "seekStart", "seekEnd", "getFileSize", "client-s3"})
@SourceDebugExtension(value={"SMAP\nFakeS3Service.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeS3Service.kt\napp/cash/backfila/client/s3/shim/FakeS3Service\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 FileSystem.kt\nokio/FileSystem\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1317#2,2:72\n1317#2:74\n1318#2:98\n66#3:75\n52#3,4:77\n60#3,10:82\n56#3,3:92\n71#3,3:95\n67#4:76\n68#4:81\n774#5:99\n865#5,2:100\n1557#5:102\n1628#5,3:103\n1#6:106\n*S KotlinDebug\n*F\n+ 1 FakeS3Service.kt\napp/cash/backfila/client/s3/shim/FakeS3Service\n*L\n22#1:72,2\n31#1:74\n31#1:98\n34#1:75\n34#1:77,4\n34#1:82,10\n34#1:92,3\n34#1:95,3\n34#1:76\n34#1:81\n44#1:99\n44#1:100,2\n45#1:102\n45#1:103,3\n*E\n"})
public final class FakeS3Service
implements S3Service {
    @NotNull
    private final Map<Pair<String, String>, ByteString> files = new LinkedHashMap();

    @Inject
    public FakeS3Service() {
    }

    public final void loadResourceDirectory(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        File root = new File(this.getClass().getClassLoader().getResource(resourcePath).getFile());
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)root, null, (int)1, null).maxDepth(1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!it.isDirectory()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (Intrinsics.areEqual((Object)it, (Object)root)) continue;
            this.addBucketFiles(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addBucketFiles(File bucketDirectory) {
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)bucketDirectory, null, (int)1, null);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            ByteString byteString;
            Throwable thrown$iv$iv;
            FakeS3Service fakeS3Service;
            String string2;
            block16: {
                void file$iv;
                void this_$iv;
                Object element$iv = iterator.next();
                File it = (File)element$iv;
                boolean bl = false;
                if (it.isDirectory()) continue;
                String string3 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                String string4 = bucketDirectory.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                String key = StringsKt.removePrefix((String)StringsKt.removePrefix((String)string3, (CharSequence)string4), (CharSequence)"/");
                Intrinsics.checkNotNullExpressionValue((Object)bucketDirectory.getName(), (String)"getName(...)");
                FileSystem fileSystem = FileSystem.SYSTEM;
                String string5 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
                Path path = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string5, (boolean)false, (int)1, null);
                string2 = key;
                fakeS3Service = this;
                boolean bl2 = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source((Path)file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl3 = false;
                    BufferedSource $this$addBucketFiles_u24lambda_u242_u24lambda_u241 = it$iv;
                    boolean bl4 = false;
                    byteString = $this$addBucketFiles_u24lambda_u242_u24lambda_u241.readByteString();
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        byteString = null;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block17: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block17;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            ByteString result$iv$iv = byteString;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            ByteString byteString2 = result$iv$iv;
            fakeS3Service.add(string, string2, byteString2);
        }
    }

    public final void add(@NotNull String bucket, @NotNull String key, @NotNull ByteString fileContent) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        this.files.put((Pair<String, String>)TuplesKt.to((Object)bucket, (Object)key), fileContent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> listFiles(@NotNull String bucket, @NotNull String keyPrefix) {
        void $this$mapTo$iv$iv;
        Pair pair;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
        Iterable $this$filter$iv = this.files.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            String fileBucket = (String)pair.component1();
            String key = (String)pair.component2();
            if (!(Intrinsics.areEqual((Object)fileBucket, (Object)bucket) && StringsKt.startsWith$default((String)key, (String)keyPrefix, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getSecond());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public BufferedSource getFileStreamStartingAt(@NotNull String bucket, @NotNull String key, long start) {
        ByteString remainder;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ByteString byteString = this.files.get(TuplesKt.to((Object)bucket, (Object)key));
        if (byteString == null || (byteString = ByteString.substring$default((ByteString)byteString, (int)((int)start), (int)0, (int)2, null)) == null) {
            byteString = ByteString.EMPTY;
        }
        boolean bl2 = bl = (remainder = byteString).size() != 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Amazon throws 'The requested range is not satisfiable'";
            throw new AssertionError((Object)string);
        }
        return (BufferedSource)new Buffer().write(remainder);
    }

    @Override
    @NotNull
    public ByteString getWithSeek(@NotNull String bucket, @NotNull String key, long seekStart, long seekEnd) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int s3SeekEnd = (int)seekEnd + 1;
        ByteString byteString = this.files.get(TuplesKt.to((Object)bucket, (Object)key));
        if (byteString == null || (byteString = byteString.substring((int)seekStart, s3SeekEnd)) == null) {
            byteString = ByteString.EMPTY;
        }
        return byteString;
    }

    @Override
    public long getFileSize(@NotNull String bucket, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ByteString byteString = this.files.get(TuplesKt.to((Object)bucket, (Object)key));
        return byteString != null ? (long)byteString.size() : 0L;
    }
}

