//[client-s3](../../../index.md)/[app.cash.backfila.client.s3.record](../index.md)/[Utf8StringNewlineStrategy](index.md)

# Utf8StringNewlineStrategy

[jvm]\
open class [Utf8StringNewlineStrategy](index.md)(ignoreBlankLines: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html) = true) : [RecordStrategy](../-record-strategy/index.md)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)&gt; 

Produces single string records separated by newlines.

## Constructors

| | |
|---|---|
| [Utf8StringNewlineStrategy](-utf8-string-newline-strategy.md) | [jvm]<br>constructor(ignoreBlankLines: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html) = true) |

## Functions

| Name | Summary |
|---|---|
| [bytesToRecords](bytes-to-records.md) | [jvm]<br>open override fun [bytesToRecords](bytes-to-records.md)(source: ByteString): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)&gt;<br>Because the batch will always end with a newline unless it is the end of the file. If there is a newline at the end of the file that newline will be considered the end of the file and no record will be processed for the empty string between that last newline and the end of the file. |
| [calculateNextRecordBytes](calculate-next-record-bytes.md) | [jvm]<br>open override fun [calculateNextRecordBytes](calculate-next-record-bytes.md)(source: BufferedSource): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)<br>Calculates the byte offset of the start of the next record. Cannot return 0 as you must make progress on the source. You receive a peeked source so be careful how far ahead you read. |
