/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.static.internal;

import app.cash.backfila.client.BackfillConfig;
import app.cash.backfila.client.spi.BackfilaParametersOperator;
import app.cash.backfila.client.spi.BackfillOperator;
import app.cash.backfila.client.static.StaticDatasourceBackfill;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeRequest;
import app.cash.backfila.protos.clientservice.GetNextBatchRangeResponse;
import app.cash.backfila.protos.clientservice.KeyRange;
import app.cash.backfila.protos.clientservice.PrepareBackfillRequest;
import app.cash.backfila.protos.clientservice.PrepareBackfillResponse;
import app.cash.backfila.protos.clientservice.RunBatchRequest;
import app.cash.backfila.protos.clientservice.RunBatchResponse;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004:\u0002\u001d\u001eB'\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lapp/cash/backfila/client/static/internal/StaticDatasourceBackfillOperator;", "I", "", "P", "Lapp/cash/backfila/client/spi/BackfillOperator;", "backfill", "Lapp/cash/backfila/client/static/StaticDatasourceBackfill;", "parametersOperator", "Lapp/cash/backfila/client/spi/BackfilaParametersOperator;", "(Lapp/cash/backfila/client/static/StaticDatasourceBackfill;Lapp/cash/backfila/client/spi/BackfilaParametersOperator;)V", "getBackfill", "()Lapp/cash/backfila/client/static/StaticDatasourceBackfill;", "getParametersOperator", "()Lapp/cash/backfila/client/spi/BackfilaParametersOperator;", "getNextBatchRange", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeResponse;", "request", "Lapp/cash/backfila/protos/clientservice/GetNextBatchRangeRequest;", "name", "", "prepareBackfill", "Lapp/cash/backfila/protos/clientservice/PrepareBackfillResponse;", "Lapp/cash/backfila/protos/clientservice/PrepareBackfillRequest;", "runBatch", "Lapp/cash/backfila/protos/clientservice/RunBatchResponse;", "Lapp/cash/backfila/protos/clientservice/RunBatchRequest;", "decode", "Lapp/cash/backfila/client/static/internal/StaticDatasourceBackfillOperator$DecodedRange;", "Lapp/cash/backfila/protos/clientservice/KeyRange;", "Companion", "DecodedRange", "client-static"})
public final class StaticDatasourceBackfillOperator<I, P>
implements BackfillOperator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StaticDatasourceBackfill<I, P> backfill;
    @NotNull
    private final BackfilaParametersOperator<P> parametersOperator;
    @NotNull
    private static final String PARTITION = "only";

    public StaticDatasourceBackfillOperator(@NotNull StaticDatasourceBackfill<I, P> backfill, @NotNull BackfilaParametersOperator<P> parametersOperator) {
        Intrinsics.checkNotNullParameter(backfill, (String)"backfill");
        Intrinsics.checkNotNullParameter(parametersOperator, (String)"parametersOperator");
        this.backfill = backfill;
        this.parametersOperator = parametersOperator;
    }

    @NotNull
    public StaticDatasourceBackfill<I, P> getBackfill() {
        return this.backfill;
    }

    @NotNull
    public final BackfilaParametersOperator<P> getParametersOperator() {
        return this.parametersOperator;
    }

    @NotNull
    public String name() {
        String string = this.getBackfill().getClass().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"backfill.javaClass.toString()");
        return string;
    }

    @NotNull
    public PrepareBackfillResponse prepareBackfill(@NotNull PrepareBackfillRequest request) {
        Integer n;
        int n2;
        boolean bl;
        Object object;
        Object object2;
        ByteString byteString;
        int n3;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object3 = request.parameters;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"request.parameters");
        Map map = object3;
        object3 = request.dry_run;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"request.dry_run");
        BackfillConfig config = this.parametersOperator.constructBackfillConfig(map, ((Boolean)object3).booleanValue());
        this.getBackfill().validate(config);
        KeyRange keyRange = request.range;
        if (keyRange == null) {
            n3 = 0;
        } else {
            byteString = keyRange.start;
            if (byteString == null) {
                n3 = 0;
            } else {
                object2 = byteString.utf8();
                if (object2 == null) {
                    n3 = 0;
                } else {
                    object = object2;
                    boolean bl2 = false;
                    bl = false;
                    Object it = object;
                    boolean bl3 = false;
                    Integer n4 = StringsKt.toIntOrNull((String)it);
                    if (n4 == null) {
                        String string = "Start of range must be a number";
                        boolean bl4 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    n3 = n2 = n4.intValue();
                }
            }
        }
        int start = n3;
        object2 = request.range;
        if (object2 == null) {
            n = null;
        } else {
            ByteString byteString2 = object2.end;
            if (byteString2 == null) {
                n = null;
            } else {
                object = byteString2.utf8();
                if (object == null) {
                    n = null;
                } else {
                    Object object4 = object;
                    bl = false;
                    boolean bl5 = false;
                    Object it = object4;
                    boolean bl6 = false;
                    Integer n5 = StringsKt.toIntOrNull((String)it);
                    if (n5 == null) {
                        String string = "End of range must be a number";
                        boolean bl7 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    n = (int)n5;
                }
            }
        }
        byteString = n;
        int end = byteString == null ? this.getBackfill().getStaticDatasource().size() : byteString.intValue();
        boolean bl8 = start >= 0 && end >= 0;
        boolean bl9 = false;
        n2 = 0;
        if (!bl8) {
            boolean bl10 = false;
            String string = "Start and end must be positive integers, start: " + start + " end: " + end;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl8 = start <= end;
        bl9 = false;
        n2 = 0;
        if (!bl8) {
            boolean bl11 = false;
            String string = "Start must be less than or equal to end, start: " + start + " end: " + end;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl8 = start <= this.getBackfill().getStaticDatasource().size();
        bl9 = false;
        n2 = 0;
        if (!bl8) {
            boolean bl12 = false;
            String string = "Start is greater than the static datasource size, start: " + start + " size: " + this.getBackfill().getStaticDatasource().size();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        PrepareBackfillResponse.Partition onlyPartition = new PrepareBackfillResponse.Partition.Builder().partition_name(PARTITION).backfill_range(new KeyRange.Builder().start(ByteString.Companion.encodeUtf8(String.valueOf(start))).end(ByteString.Companion.encodeUtf8(String.valueOf(end))).build()).build();
        PrepareBackfillResponse prepareBackfillResponse = new PrepareBackfillResponse.Builder().partitions(CollectionsKt.listOf((Object)onlyPartition)).build();
        Intrinsics.checkNotNullExpressionValue((Object)prepareBackfillResponse, (String)"Builder()\n      .partiti\u2026artition))\n      .build()");
        return prepareBackfillResponse;
    }

    @NotNull
    public GetNextBatchRangeResponse getNextBatchRange(@NotNull GetNextBatchRangeRequest request) {
        int n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Preconditions.checkArgument((boolean)Intrinsics.areEqual((Object)request.partition_name, (Object)PARTITION), (String)("Attempting to get batch for unknown partition " + request.partition_name), (Object[])new Object[0]);
        int batchSize = (int)request.batch_size.longValue();
        int scanSize = (int)request.scan_size.longValue();
        KeyRange keyRange = request.backfill_range;
        Intrinsics.checkNotNullExpressionValue((Object)keyRange, (String)"request.backfill_range");
        DecodedRange backfillRange = this.decode(keyRange);
        ByteString byteString = request.previous_end_key;
        if (byteString == null) {
            n2 = null;
        } else {
            String string = byteString.utf8();
            if (string == null) {
                n2 = null;
            } else {
                String string2 = string;
                n = 0;
                n2 = Integer.parseInt(string2);
            }
        }
        Integer n3 = n2;
        int batchingStart = n3 == null ? backfillRange.getStart() : n3.intValue();
        boolean bl = false;
        List batches = new ArrayList();
        int n4 = batchingStart + scanSize;
        int n5 = backfillRange.getEnd();
        n = 0;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)batchingStart, (int)Math.min(n4, n5))), (int)batchSize);
        n4 = intProgression.getFirst();
        n5 = intProgression.getLast();
        n = intProgression.getStep();
        if (n > 0 && n4 <= n5 || n < 0 && n5 <= n4) {
            int batchStart;
            do {
                batchStart = n4;
                n4 += n;
                int n6 = batchStart + batchSize;
                int n7 = backfillRange.getEnd();
                boolean bl2 = false;
                int batchEnd = Math.min(n6, n7);
                Collection collection = batches;
                GetNextBatchRangeResponse.Batch batch = new GetNextBatchRangeResponse.Batch.Builder().batch_range(new KeyRange.Builder().start(ByteString.Companion.encodeUtf8(String.valueOf(batchStart))).end(ByteString.Companion.encodeUtf8(String.valueOf(batchEnd))).build()).matching_record_count(Long.valueOf(batchEnd - batchStart)).scanned_record_count(Long.valueOf(batchEnd - batchStart)).build();
                bl2 = false;
                collection.add(batch);
            } while (batchStart != n5);
        }
        intProgression = new GetNextBatchRangeResponse.Builder().batches(batches).build();
        Intrinsics.checkNotNullExpressionValue((Object)intProgression, (String)"Builder()\n      .batches(batches)\n      .build()");
        return intProgression;
    }

    @NotNull
    public RunBatchResponse runBatch(@NotNull RunBatchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Preconditions.checkArgument((boolean)Intrinsics.areEqual((Object)request.partition_name, (Object)PARTITION), (String)("Attempting to get batch for unknown partition " + request.partition_name), (Object[])new Object[0]);
        KeyRange keyRange = request.batch_range;
        Intrinsics.checkNotNullExpressionValue((Object)keyRange, (String)"request.batch_range");
        DecodedRange batchRange = this.decode(keyRange);
        Object object = request.parameters;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"request.parameters");
        Map map = object;
        object = request.dry_run;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"request.dry_run");
        BackfillConfig config = this.parametersOperator.constructBackfillConfig(map, ((Boolean)object).booleanValue());
        List batch = this.getBackfill().getStaticDatasource().subList(batchRange.getStart(), batchRange.getEnd());
        this.getBackfill().runBatch(batch, config);
        RunBatchResponse runBatchResponse = new RunBatchResponse.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)runBatchResponse, (String)"Builder()\n      .build()");
        return runBatchResponse;
    }

    private final DecodedRange decode(KeyRange $this$decode) {
        String string = $this$decode.start.utf8();
        boolean bl = false;
        int start = Integer.parseInt(string);
        String string2 = $this$decode.end.utf8();
        boolean bl2 = false;
        int end = Integer.parseInt(string2);
        return new DecodedRange(start, end);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lapp/cash/backfila/client/static/internal/StaticDatasourceBackfillOperator$DecodedRange;", "", "start", "", "end", "(II)V", "getEnd", "()I", "getStart", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "client-static"})
    public static final class DecodedRange {
        private final int start;
        private final int end;

        public DecodedRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final DecodedRange copy(int start, int end) {
            return new DecodedRange(start, end);
        }

        public static /* synthetic */ DecodedRange copy$default(DecodedRange decodedRange, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = decodedRange.start;
            }
            if ((n3 & 2) != 0) {
                n2 = decodedRange.end;
            }
            return decodedRange.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "DecodedRange(start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecodedRange)) {
                return false;
            }
            DecodedRange decodedRange = (DecodedRange)other;
            if (this.start != decodedRange.start) {
                return false;
            }
            return this.end == decodedRange.end;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lapp/cash/backfila/client/static/internal/StaticDatasourceBackfillOperator$Companion;", "", "()V", "PARTITION", "", "client-static"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

