//[client-static](../../../index.md)/[app.cash.backfila.client.stat](../index.md)/[StaticDatasourceBackfill](index.md)

# StaticDatasourceBackfill

[jvm]\
abstract class [StaticDatasourceBackfill](index.md)&lt;[I](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [P](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; : [StaticDatasourceBackfillBase](../-static-datasource-backfill-base/index.md)&lt;[I](index.md), [P](index.md)&gt;

## Constructors

| | |
|---|---|
| [StaticDatasourceBackfill](-static-datasource-backfill.md) | [jvm]<br>constructor() |

## Properties

| Name | Summary |
|---|---|
| [itemType](../-static-datasource-backfill-base/item-type.md) | [jvm]<br>val [itemType](../-static-datasource-backfill-base/item-type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[I](index.md)&gt; |
| [staticDatasource](static-datasource.md) | [jvm]<br>abstract val [staticDatasource](static-datasource.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[I](index.md)&gt;<br>This provides the static list of items that the backfill will iterate over. |

## Functions

| Name | Summary |
|---|---|
| [getStaticDatasource](get-static-datasource.md) | [jvm]<br>open override fun [getStaticDatasource](get-static-datasource.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[I](index.md)&gt; |
| [runBatch](../-static-datasource-backfill-base/run-batch.md) | [jvm]<br>open fun [runBatch](../-static-datasource-backfill-base/run-batch.md)(items: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;@[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)[I](index.md)&gt;, config: BackfillConfig&lt;[P](index.md)&gt;)<br>Called for each batch of matching records. Override in a backfill to process all records in a batch. |
| [runOne](../-static-datasource-backfill-base/run-one.md) | [jvm]<br>open fun [runOne](../-static-datasource-backfill-base/run-one.md)(item: [I](index.md), config: BackfillConfig&lt;[P](index.md)&gt;)<br>Called for each matching record. Override in a backfill to process one record at a time. |
| [validate](../-static-datasource-backfill-base/validate.md) | [jvm]<br>open fun [validate](../-static-datasource-backfill-base/validate.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;)<br>Override this and throw an exception to prevent the backfill from being created. This is also a good place to do any prep work before batches are run. |
