//[client-static](../../../index.md)/[app.cash.backfila.client.stat.parameters](../index.md)/[ParametersDatasourceBackfill](index.md)

# ParametersDatasourceBackfill

[jvm]\
abstract class [ParametersDatasourceBackfill](index.md)&lt;[I](index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-any/index.html), [P](index.md) : [DatasourceParameters](../-datasource-parameters/index.md)&lt;[I](index.md)&gt;&gt; : [StaticDatasourceBackfillBase](../../app.cash.backfila.client.stat/-static-datasource-backfill-base/index.md)&lt;[I](index.md), [P](index.md)&gt; 

This backfill type is a sub variant of the [StaticDatasourceBackfillBase](../../app.cash.backfila.client.stat/-static-datasource-backfill-base/index.md).

It uses a parameter populated in the Backfila UI as the datasource for the backfill.If you have too much data to fit in a parameter consider using a different client such as the S3 client.

## Constructors

| | |
|---|---|
| [ParametersDatasourceBackfill](-parameters-datasource-backfill.md) | [jvm]<br>constructor() |

## Properties

| Name | Summary |
|---|---|
| [itemType](../../app.cash.backfila.client.stat/-static-datasource-backfill-base/item-type.md) | [jvm]<br>val [itemType](../../app.cash.backfila.client.stat/-static-datasource-backfill-base/item-type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.reflect/-k-class/index.html)&lt;[I](index.md)&gt; |

## Functions

| Name | Summary |
|---|---|
| [getStaticDatasource](get-static-datasource.md) | [jvm]<br>open override fun [getStaticDatasource](get-static-datasource.md)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[I](index.md)&gt; |
| [runBatch](index.md#-482955558%2FFunctions%2F717303874) | [jvm]<br>open fun [runBatch](index.md#-482955558%2FFunctions%2F717303874)(items: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;@[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)[I](index.md)&gt;, config: BackfillConfig&lt;[P](index.md)&gt;)<br>Called for each batch of matching records. Override in a backfill to process all records in a batch. |
| [runOne](index.md#-810225124%2FFunctions%2F717303874) | [jvm]<br>open fun [runOne](index.md#-810225124%2FFunctions%2F717303874)(item: [I](index.md), config: BackfillConfig&lt;[P](index.md)&gt;)<br>Called for each matching record. Override in a backfill to process one record at a time. |
| [validate](index.md#1593993802%2FFunctions%2F717303874) | [jvm]<br>open fun [validate](index.md#1593993802%2FFunctions%2F717303874)(config: PrepareBackfillConfig&lt;[P](index.md)&gt;)<br>Override this and throw an exception to prevent the backfill from being created. This is also a good place to do any prep work before batches are run. |
