/*
 * Decompiled with CFR 0.152.
 */
package app.cash.backfila.client.testing;

import app.cash.backfila.embedded.BackfillRun;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.AbstractAssert;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0000J\u0006\u0010\u0006\u001a\u00020\u0000J\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010\b\u001a\u00020\u0000J\u0006\u0010\t\u001a\u00020\u0000J\u0006\u0010\n\u001a\u00020\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/cash/backfila/client/testing/BackfillRunAssert;", "Lorg/assertj/core/api/AbstractAssert;", "Lapp/cash/backfila/embedded/BackfillRun;", "backfillRun", "(Lapp/cash/backfila/embedded/BackfillRun;)V", "hasBatchesToRun", "hasNoBatchesToRun", "isComplete", "isFinishedPrecomputing", "isFinishedScanning", "isNotComplete", "client-testing"})
public final class BackfillRunAssert
extends AbstractAssert<BackfillRunAssert, BackfillRun<?>> {
    @NotNull
    private final BackfillRun<?> backfillRun;

    public BackfillRunAssert(@NotNull BackfillRun<?> backfillRun) {
        Intrinsics.checkNotNullParameter(backfillRun, (String)"backfillRun");
        super(backfillRun, BackfillRunAssert.class);
        this.backfillRun = backfillRun;
    }

    @NotNull
    public final BackfillRunAssert isFinishedPrecomputing() {
        if (!this.backfillRun.finishedPrecomputing()) {
            this.failWithMessage("Expected the backfill run of type " + this.backfillRun.getBackfill().getClass().getSimpleName() + " to be finished precomputing but it isn't.", new Object[0]);
        }
        return this;
    }

    @NotNull
    public final BackfillRunAssert isFinishedScanning() {
        if (!this.backfillRun.finishedScanning()) {
            this.failWithMessage("Expected the backfill run of type " + this.backfillRun.getBackfill().getClass().getSimpleName() + " to be finished scanning but it isn't.", new Object[0]);
        }
        return this;
    }

    @NotNull
    public final BackfillRunAssert hasNoBatchesToRun() {
        if (!((Collection)this.backfillRun.getBatchesToRunSnapshot()).isEmpty()) {
            this.failWithMessage("Expected the backfill run of type " + this.backfillRun.getBackfill().getClass().getSimpleName() + " to have no batches to run but it has " + this.backfillRun.getBatchesToRunSnapshot().size() + " pending batches.", new Object[0]);
        }
        return this;
    }

    @NotNull
    public final BackfillRunAssert hasBatchesToRun() {
        if (this.backfillRun.getBatchesToRunSnapshot().isEmpty()) {
            this.failWithMessage("Expected the backfill run of type " + this.backfillRun.getBackfill().getClass().getSimpleName() + " to have batches to run but there are no pending batches.", new Object[0]);
        }
        return this;
    }

    @NotNull
    public final BackfillRunAssert isComplete() {
        if (!this.backfillRun.complete()) {
            this.failWithMessage("Expected the backfill run of type " + this.backfillRun.getBackfill().getClass().getSimpleName() + " to be complete but it isn't. finished scanning? " + this.backfillRun.finishedScanning() + " , batches left to run " + this.backfillRun.getBatchesToRunSnapshot().size(), new Object[0]);
        }
        return this;
    }

    @NotNull
    public final BackfillRunAssert isNotComplete() {
        if (this.backfillRun.complete()) {
            this.failWithMessage("Expected the backfill run of type " + this.backfillRun.getBackfill().getClass().getSimpleName() + " to be incomplete but it is done. finished scanning? " + this.backfillRun.finishedScanning() + " , batches left to run " + this.backfillRun.getBatchesToRunSnapshot().size(), new Object[0]);
        }
        return this;
    }
}

