import { IAction, IRootState, SimpleReduxSaga } from "@misk/simpleredux";
import { Map } from "immutable";
/**
 * Actions
 * string enum of the defined actions that is used as type enforcement for Reducer and Sagas
 * arguments
 */
export declare enum HOME {
    DINOSAUR = "HOME_DINOSAUR",
    SUCCESS = "HOME_SUCCESS",
    FAILURE = "HOME_FAILURE"
}
/**
 * Dispatch Object
 * Object of functions that dispatch Actions with standard defaults and any required passed in input
 * dispatch Object is used within containers to initiate any saga provided functionality
 */
export interface IHomePayload {
    data?: any;
    error: any;
    loading: boolean;
    success: boolean;
}
export interface IDispatchHome {
    homeDinosaur: (data: any, fieldTag: string, formTag: string) => IAction<HOME.DINOSAUR, IHomePayload>;
    homeFailure: (error: any) => IAction<HOME.FAILURE, IHomePayload>;
    homeSuccess: (data: any) => IAction<HOME.SUCCESS, IHomePayload>;
}
export declare const dispatchHome: IDispatchHome;
export declare function watchHomeSagas(): SimpleReduxSaga;
/**
 * Duck Reducer
 * Merges dispatched action objects on to the existing (or initial) state to generate new state
 */
export declare const HomeReducer: (state: any, action: IAction<HOME, {}>) => any;
/**
 * State Interface
 * Provides a complete Typescript interface for the object on state that this duck manages
 * Consumed by the root reducer in ./ducks index to update global state
 * Duck state is attached at the root level of global state
 */
export interface IHomeState extends IRootState {
    [key: string]: any;
}
export interface IHomeImmutableState extends Map<string, any> {
    toJS: () => IHomeState;
}
