import { IDispatchSimpleForm, IDispatchSimpleNetwork, ISimpleFormState, ISimpleNetworkState, SimpleReduxSaga } from "@misk/simpleredux";
import { LocationChangeAction, RouterState } from "connected-react-router";
import { History } from "history";
import { AnyAction, Reducer } from "redux";
import { IDispatchHome, IHomeState } from "./home";
export * from "./home";
/**
 * Redux Store State
 */
export interface IState {
    home: IHomeState;
    router: Reducer<RouterState, LocationChangeAction>;
    simpleForm: ISimpleFormState;
    simpleNetwork: ISimpleNetworkState;
}
/**
 * Dispatcher
 */
export interface IDispatchProps extends IDispatchSimpleForm, IDispatchSimpleNetwork, IDispatchHome {
}
export declare const rootDispatcher: IDispatchProps;
/**
 * State Selectors
 */
export declare const rootSelectors: (state: IState) => {
    home: any;
    router: Reducer<RouterState<{}>, LocationChangeAction<{}>>;
    simpleForm: any;
    simpleNetwork: any;
};
/**
 * Reducers
 */
export declare const rootReducer: (history: History) => Reducer<any, AnyAction>;
/**
 * Sagas
 */
export declare function rootSaga(): SimpleReduxSaga;
/**
 * Map Dispatch/State to Props
 */
export declare const mapStateToProps: (state: IState) => {
    home: any;
    router: Reducer<RouterState<{}>, LocationChangeAction<{}>>;
    simpleForm: any;
    simpleNetwork: any;
};
export declare const mapDispatchToProps: IDispatchProps;
