//[service](../../../index.md)/[app.cash.backfila.service.persistence](../index.md)/[DbBackfillRun](index.md)

# DbBackfillRun

[jvm]\
@Entity()

class [DbBackfillRun](index.md) : DbUnsharded<[DbBackfillRun](index.md)> , DbTimestampedEntity

Tracks the state of a created backfill.

## Constructors

| | |
|---|---|
| [DbBackfillRun](-db-backfill-run.md) | [jvm]<br>fun [DbBackfillRun](-db-backfill-run.md)(service_id: Id<[DbService](../-db-service/index.md)>, registered_backfill_id: Id<[DbRegisteredBackfill](../-db-registered-backfill/index.md)>, parameter_map: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), ByteString>, state: [BackfillState](../-backfill-state/index.md), created_by_user: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, scan_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), batch_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), num_threads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), backoff_schedule: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, dry_run: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), extra_sleep_ms: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [DbBackfillRun](-db-backfill-run.md) | [jvm]<br>fun [DbBackfillRun](-db-backfill-run.md)() |

## Functions

| Name | Summary |
|---|---|
| [backoffSchedule](backoff-schedule.md) | [jvm]<br>fun [backoffSchedule](backoff-schedule.md)(): <ERROR CLASS> |
| [complete](complete.md) | [jvm]<br>fun [complete](complete.md)() |
| [parameters](parameters.md) | [jvm]<br>fun [parameters](parameters.md)(): <ERROR CLASS> |
| [partitions](partitions.md) | [jvm]<br>fun [partitions](partitions.md)(session: Session, queryFactory: Query.Factory): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[DbRunPartition](../-db-run-partition/index.md)> |
| [setState](set-state.md) | [jvm]<br>fun [setState](set-state.md)(session: Session, queryFactory: Query.Factory, state: [BackfillState](../-backfill-state/index.md)) |

## Properties

| Name | Summary |
|---|---|
| [approved_at](approved_at.md) | [jvm]<br>var [approved_at](approved_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)? = null |
| [approved_by_user](approved_by_user.md) | [jvm]<br>var [approved_by_user](approved_by_user.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null |
| [backoff_schedule](backoff_schedule.md) | [jvm]<br>var [backoff_schedule](backoff_schedule.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null<br>Comma separated list of delays for consecutive retries in milliseconds, e.g. |
| [batch_size](batch_size.md) | [jvm]<br>var [batch_size](batch_size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0 |
| [created_at](created_at.md) | [jvm]<br>open lateinit override var [created_at](created_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |
| [created_by_user](created_by_user.md) | [jvm]<br>var [created_by_user](created_by_user.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null |
| [dry_run](dry_run.md) | [jvm]<br>var [dry_run](dry_run.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false |
| [extra_sleep_ms](extra_sleep_ms.md) | [jvm]<br>var [extra_sleep_ms](extra_sleep_ms.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0<br>Sleep that is added after every successful RunBatch. |
| [id](id.md) | [jvm]<br>open lateinit override var [id](id.md): Id<[DbBackfillRun](index.md)> |
| [num_threads](num_threads.md) | [jvm]<br>var [num_threads](num_threads.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0 |
| [parameter_map](parameter_map.md) | [jvm]<br>var [parameter_map](parameter_map.md): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>? = null |
| [pipeline_target_backfill_id](pipeline_target_backfill_id.md) | [jvm]<br>var [pipeline_target_backfill_id](pipeline_target_backfill_id.md): Id<[DbRegisteredBackfill](../-db-registered-backfill/index.md)>? = null |
| [registered_backfill](registered_backfill.md) | [jvm]<br>lateinit var [registered_backfill](registered_backfill.md): [DbRegisteredBackfill](../-db-registered-backfill/index.md) |
| [registered_backfill_id](registered_backfill_id.md) | [jvm]<br>lateinit var [registered_backfill_id](registered_backfill_id.md): Id<[DbRegisteredBackfill](../-db-registered-backfill/index.md)><br>Immutably stores the data configured by the client service for this backfill. |
| [scan_size](scan_size.md) | [jvm]<br>var [scan_size](scan_size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0 |
| [service](service.md) | [jvm]<br>lateinit var [service](service.md): [DbService](../-db-service/index.md) |
| [service_id](service_id.md) | [jvm]<br>lateinit var [service_id](service_id.md): Id<[DbService](../-db-service/index.md)> |
| [state](state.md) | [jvm]<br>lateinit var [state](state.md): [BackfillState](../-backfill-state/index.md) |
| [updated_at](updated_at.md) | [jvm]<br>open lateinit override var [updated_at](updated_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |
| [version](version.md) | [jvm]<br>var [version](version.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0 |
