//[service](../../../index.md)/[app.cash.backfila.service.runner](../index.md)/[BackfillRunner](index.md)

# BackfillRunner

[jvm]\
class [BackfillRunner](index.md)

Coordinator of the backfill run. Starts a few actors as coroutines and updates the lease.

## Types

| Name | Summary |
|---|---|
| [BackfillMetaData](-backfill-meta-data/index.md) | [jvm]<br>data class [BackfillMetaData](-backfill-meta-data/index.md)(**backfillRunId**: Id<[DbBackfillRun](../../app.cash.backfila.service.persistence/-db-backfill-run/index.md)>, **pkeyCursor**: ByteString?, **pkeyStart**: ByteString?, **pkeyEnd**: ByteString?, **parameters**: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), ByteString>?, **batchSize**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **scanSize**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **dryRun**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **numThreads**: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), **precomputingDone**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **precomputingPkeyCursor**: ByteString?, **computedScannedRecordCount**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **computedMatchingRecordCount**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **extraSleepMs**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **backoffSchedule**: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)>, **backfilledScannedRecordCount**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **backfilledMatchingRecordCount**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |
| [Factory](-factory/index.md) | [jvm]<br>class [Factory](-factory/index.md) |

## Functions

| Name | Summary |
|---|---|
| [clearLease](clear-lease.md) | [jvm]<br>fun [clearLease](clear-lease.md)() |
| [logLabel](log-label.md) | [jvm]<br>fun [logLabel](log-label.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [onRpcFailure](on-rpc-failure.md) | [jvm]<br>suspend fun [onRpcFailure](on-rpc-failure.md)(exception: [Exception](https://docs.oracle.com/javase/8/docs/api/java/lang/Exception.html), action: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), elapsed: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)) |
| [onRpcSuccess](on-rpc-success.md) | [jvm]<br>fun [onRpcSuccess](on-rpc-success.md)() |
| [run](run.md) | [jvm]<br>fun [run](run.md)() |
| [runBatchAsync](run-batch-async.md) | [jvm]<br>fun [runBatchAsync](run-batch-async.md)(scope: CoroutineScope, batch: GetNextBatchRangeResponse.Batch, pipelinedData: PipelinedData? = null): Deferred<RunBatchResponse> |
| [start](start.md) | [jvm]<br>fun [start](start.md)(coroutineScope: CoroutineScope) |
| [stop](stop.md) | [jvm]<br>fun [stop](stop.md)() |

## Properties

| Name | Summary |
|---|---|
| [backfillName](backfill-name.md) | [jvm]<br>val [backfillName](backfill-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [backfillRunId](backfill-run-id.md) | [jvm]<br>val [backfillRunId](backfill-run-id.md): Id<[DbBackfillRun](../../app.cash.backfila.service.persistence/-db-backfill-run/index.md)> |
| [client](client.md) | [jvm]<br>val [client](client.md): <ERROR CLASS> |
| [factory](factory.md) | [jvm]<br>val [factory](factory.md): [BackfillRunner.Factory](-factory/index.md) |
| [globalBackoff](global-backoff.md) | [jvm]<br>val [globalBackoff](global-backoff.md): [Backoff](../-backoff/index.md)<br>Backoff for all RPCs for this runner. |
| [metadata](metadata.md) | [jvm]<br>lateinit var [metadata](metadata.md): [BackfillRunner.BackfillMetaData](-backfill-meta-data/index.md)<br>Metadata about the backfill from the database. |
| [metricLabels](metric-labels.md) | [jvm]<br>val [metricLabels](metric-labels.md): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)> |
| [partitionId](partition-id.md) | [jvm]<br>val [partitionId](partition-id.md): Id<[DbRunPartition](../../app.cash.backfila.service.persistence/-db-run-partition/index.md)> |
| [partitionName](partition-name.md) | [jvm]<br>val [partitionName](partition-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [runBatchBackoff](run-batch-backoff.md) | [jvm]<br>val [runBatchBackoff](run-batch-backoff.md): [Backoff](../-backoff/index.md)<br>Backoff just for RunBatch RPCs. |
