//[service](../../../index.md)/[app.cash.backfila.service.scheduler](../index.md)/[RunnerSchedulerService](index.md)

# RunnerSchedulerService

[jvm]\
@Singleton()

class [RunnerSchedulerService](index.md)@Inject()constructor(**runnerExecutorService**: ListeningExecutorService, **leaseHunter**: [LeaseHunter](../-lease-hunter/index.md)) : AbstractExecutionThreadService

Runs a background thread, looking for unleased backfills to run.

When one is found, a runner thread is created to work on the backfill. On shutdown, the runners are stopped so the leases can be eagerly released.

## Constructors

| | |
|---|---|
| [RunnerSchedulerService](-runner-scheduler-service.md) | [jvm]<br>@Inject()<br>fun [RunnerSchedulerService](-runner-scheduler-service.md)(runnerExecutorService: ListeningExecutorService, leaseHunter: [LeaseHunter](../-lease-hunter/index.md)) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [addListener](index.md#-2055783903%2FFunctions%2F-220060515) | [jvm]<br>override fun [addListener](index.md#-2055783903%2FFunctions%2F-220060515)(listener: Service.Listener, executor: [Executor](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executor.html)) |
| [awaitRunning](index.md#-1472847199%2FFunctions%2F-220060515) | [jvm]<br>override fun [awaitRunning](index.md#-1472847199%2FFunctions%2F-220060515)()<br>override fun [awaitRunning](index.md#-1748631656%2FFunctions%2F-220060515)(timeout: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html))<br>override fun [awaitRunning](index.md#-1237133165%2FFunctions%2F-220060515)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)) |
| [awaitTerminated](index.md#939788375%2FFunctions%2F-220060515) | [jvm]<br>override fun [awaitTerminated](index.md#939788375%2FFunctions%2F-220060515)()<br>override fun [awaitTerminated](index.md#1323705294%2FFunctions%2F-220060515)(timeout: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html))<br>override fun [awaitTerminated](index.md#1536055197%2FFunctions%2F-220060515)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)) |
| [executor](index.md#1546037015%2FFunctions%2F-220060515) | [jvm]<br>open fun [executor](index.md#1546037015%2FFunctions%2F-220060515)(): [Executor](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executor.html) |
| [failureCause](index.md#1596359147%2FFunctions%2F-220060515) | [jvm]<br>override fun [failureCause](index.md#1596359147%2FFunctions%2F-220060515)(): [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html) |
| [isRunning](index.md#-987185925%2FFunctions%2F-220060515) | [jvm]<br>override fun [isRunning](index.md#-987185925%2FFunctions%2F-220060515)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [serviceName](index.md#57672944%2FFunctions%2F-220060515) | [jvm]<br>open fun [serviceName](index.md#57672944%2FFunctions%2F-220060515)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [startAsync](index.md#248223568%2FFunctions%2F-220060515) | [jvm]<br>@CanIgnoreReturnValue()<br>override fun [startAsync](index.md#248223568%2FFunctions%2F-220060515)(): Service |
| [state](index.md#1166636703%2FFunctions%2F-220060515) | [jvm]<br>override fun [state](index.md#1166636703%2FFunctions%2F-220060515)(): Service.State |
| [stopAsync](index.md#1628039734%2FFunctions%2F-220060515) | [jvm]<br>@CanIgnoreReturnValue()<br>override fun [stopAsync](index.md#1628039734%2FFunctions%2F-220060515)(): Service |
| [toString](index.md#1654594462%2FFunctions%2F-220060515) | [jvm]<br>open override fun [toString](index.md#1654594462%2FFunctions%2F-220060515)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
