//[service](../../index.md)/[app.cash.backfila.dashboard](index.md)

# Package app.cash.backfila.dashboard

## Types

| Name | Summary |
|---|---|
| [AppRedirectAction](-app-redirect-action/index.md) | [jvm]<br>class [AppRedirectAction](-app-redirect-action/index.md) : WebAction |
| [BackfilaApp](-backfila-app/index.md) | [jvm]<br>@Qualifier()<br>@[Target](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-target/index.html)(allowedTargets = [[AnnotationTarget.FIELD](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-f-i-e-l-d/index.html), [AnnotationTarget.FUNCTION](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-f-u-n-c-t-i-o-n/index.html)])<br>annotation class [BackfilaApp](-backfila-app/index.md)<br>Dashboard Annotation used for all tabs bound in the Backfila App |
| [BackfilaDashboardModule](-backfila-dashboard-module/index.md) | [jvm]<br>class [BackfilaDashboardModule](-backfila-dashboard-module/index.md)(**deployment**: Deployment) : KAbstractModule |
| [BackfilaWebActionsModule](-backfila-web-actions-module/index.md) | [jvm]<br>class [BackfilaWebActionsModule](-backfila-web-actions-module/index.md) : KAbstractModule |
| [BackfillStateToggler](-backfill-state-toggler/index.md) | [jvm]<br>class [BackfillStateToggler](-backfill-state-toggler/index.md)@Inject()constructor(**transacter**: Transacter, **queryFactory**: Query.Factory, **slackHelper**: [SlackHelper](../app.cash.backfila.service/-slack-helper/index.md)) |
| [CloneBackfillAction](-clone-backfill-action/index.md) | [jvm]<br>class [CloneBackfillAction](-clone-backfill-action/index.md)@Inject()constructor(**caller**: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)()ActionScoped<MiskCaller?>, **transacter**: Transacter, **queryFactory**: Query.Factory, **connectorProvider**: [ConnectorProvider](../app.cash.backfila.client/-connector-provider/index.md)) : WebAction |
| [CloneBackfillRequest](-clone-backfill-request/index.md) | [jvm]<br>data class [CloneBackfillRequest](-clone-backfill-request/index.md)(**scan_size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **batch_size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **num_threads**: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), **range_clone_type**: [RangeCloneType](-range-clone-type/index.md), **pkey_range_start**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **pkey_range_end**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **parameter_map**: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), ByteString>, **dry_run**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **backoff_schedule**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **extra_sleep_ms**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [CloneBackfillResponse](-clone-backfill-response/index.md) | [jvm]<br>data class [CloneBackfillResponse](-clone-backfill-response/index.md)(**id**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [CreateBackfillAction](-create-backfill-action/index.md) | [jvm]<br>class [CreateBackfillAction](-create-backfill-action/index.md)@Inject()constructor(**caller**: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)()ActionScoped<MiskCaller?>, **backfillCreator**: [BackfillCreator](../app.cash.backfila/-backfill-creator/index.md)) : WebAction |
| [GetBackfillRunsAction](-get-backfill-runs-action/index.md) | [jvm]<br>class [GetBackfillRunsAction](-get-backfill-runs-action/index.md)@Inject()constructor(**transacter**: Transacter, **queryFactory**: Query.Factory) : WebAction |
| [GetBackfillRunsResponse](-get-backfill-runs-response/index.md) | [jvm]<br>data class [GetBackfillRunsResponse](-get-backfill-runs-response/index.md)(**running_backfills**: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[UiBackfillRun](-ui-backfill-run/index.md)>, **paused_backfills**: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[UiBackfillRun](-ui-backfill-run/index.md)>, **next_pagination_token**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |
| [GetBackfillStatusAction](-get-backfill-status-action/index.md) | [jvm]<br>class [GetBackfillStatusAction](-get-backfill-status-action/index.md)@Inject()constructor(**transacter**: Transacter, **queryFactory**: Query.Factory) : WebAction |
| [GetBackfillStatusResponse](-get-backfill-status-response/index.md) | [jvm]<br>data class [GetBackfillStatusResponse](-get-backfill-status-response/index.md)(**service_name**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), **variant**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), **name**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), **state**: [BackfillState](../app.cash.backfila.service.persistence/-backfill-state/index.md), **parameters**: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>?, **batch_size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **scan_size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **dry_run**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **num_threads**: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), **created_at**: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html), **created_by_user**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **extra_sleep_ms**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **backoff_schedule**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **partitions**: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[UiPartition](-ui-partition/index.md)>, **event_logs**: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[UiEventLog](-ui-event-log/index.md)>) |
| [GetRegisteredBackfillsAction](-get-registered-backfills-action/index.md) | [jvm]<br>class [GetRegisteredBackfillsAction](-get-registered-backfills-action/index.md)@Inject()constructor(**transacter**: Transacter, **queryFactory**: Query.Factory) : WebAction |
| [GetRegisteredBackfillsResponse](-get-registered-backfills-response/index.md) | [jvm]<br>data class [GetRegisteredBackfillsResponse](-get-registered-backfills-response/index.md)(**backfills**: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[RegisteredBackfill](-registered-backfill/index.md)>) |
| [GetServicesAction](-get-services-action/index.md) | [jvm]<br>class [GetServicesAction](-get-services-action/index.md)@Inject()constructor(**transacter**: Transacter, **queryFactory**: Query.Factory) : WebAction |
| [GetServiceVariantsAction](-get-service-variants-action/index.md) | [jvm]<br>class [GetServiceVariantsAction](-get-service-variants-action/index.md)@Inject()constructor(**transacter**: Transacter, **queryFactory**: Query.Factory) : WebAction |
| [RangeCloneType](-range-clone-type/index.md) | [jvm]<br>enum [RangeCloneType](-range-clone-type/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)<[RangeCloneType](-range-clone-type/index.md)> |
| [RegisteredBackfill](-registered-backfill/index.md) | [jvm]<br>data class [RegisteredBackfill](-registered-backfill/index.md)(**name**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), **parameterNames**: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>) |
| [RootRedirectAction](-root-redirect-action/index.md) | [jvm]<br>class [RootRedirectAction](-root-redirect-action/index.md) : WebAction |
| [StartBackfillAction](-start-backfill-action/index.md) | [jvm]<br>class [StartBackfillAction](-start-backfill-action/index.md)@Inject()constructor(**caller**: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)()ActionScoped<MiskCaller?>, **backfillStateToggler**: [BackfillStateToggler](-backfill-state-toggler/index.md)) : WebAction |
| [StartBackfillRequest](-start-backfill-request/index.md) | [jvm]<br>class [StartBackfillRequest](-start-backfill-request/index.md) |
| [StartBackfillResponse](-start-backfill-response/index.md) | [jvm]<br>class [StartBackfillResponse](-start-backfill-response/index.md) |
| [StopAllBackfillsAction](-stop-all-backfills-action/index.md) | [jvm]<br>class [StopAllBackfillsAction](-stop-all-backfills-action/index.md)@Inject()constructor(**caller**: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)()ActionScoped<MiskCaller?>, **backfillStateToggler**: [BackfillStateToggler](-backfill-state-toggler/index.md), **transacter**: Transacter, **queryFactory**: Query.Factory) : WebAction |
| [StopAllBackfillsRequest](-stop-all-backfills-request/index.md) | [jvm]<br>class [StopAllBackfillsRequest](-stop-all-backfills-request/index.md) |
| [StopAllBackfillsResponse](-stop-all-backfills-response/index.md) | [jvm]<br>class [StopAllBackfillsResponse](-stop-all-backfills-response/index.md) |
| [StopBackfillAction](-stop-backfill-action/index.md) | [jvm]<br>class [StopBackfillAction](-stop-backfill-action/index.md)@Inject()constructor(**caller**: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)()ActionScoped<MiskCaller?>, **backfillStateToggler**: [BackfillStateToggler](-backfill-state-toggler/index.md)) : WebAction |
| [StopBackfillRequest](-stop-backfill-request/index.md) | [jvm]<br>class [StopBackfillRequest](-stop-backfill-request/index.md) |
| [StopBackfillResponse](-stop-backfill-response/index.md) | [jvm]<br>class [StopBackfillResponse](-stop-backfill-response/index.md) |
| [UiBackfillRun](-ui-backfill-run/index.md) | [jvm]<br>data class [UiBackfillRun](-ui-backfill-run/index.md)(**id**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), **name**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), **state**: [BackfillState](../app.cash.backfila.service.persistence/-backfill-state/index.md), **dry_run**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **created_at**: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html), **created_by_user**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **last_active_at**: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html), **precomputing_done**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **computed_matching_record_count**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **backfilled_matching_record_count**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [UiEventLog](-ui-event-log/index.md) | [jvm]<br>data class [UiEventLog](-ui-event-log/index.md)(**occurred_at**: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html), **type**: [DbEventLog.Type](../app.cash.backfila.service.persistence/-db-event-log/-type/index.md), **user**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **partition_name**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), **extra_data**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |
| [UiPartition](-ui-partition/index.md) | [jvm]<br>data class [UiPartition](-ui-partition/index.md)(**id**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **name**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), **state**: [BackfillState](../app.cash.backfila.service.persistence/-backfill-state/index.md), **pkey_cursor**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **pkey_start**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **pkey_end**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **precomputing_done**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **precomputing_pkey_cursor**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **computed_scanned_record_count**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **computed_matching_record_count**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **backfilled_scanned_record_count**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **backfilled_matching_record_count**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), **scanned_records_per_minute**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **matching_records_per_minute**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?) |
| [UpdateBackfillAction](-update-backfill-action/index.md) | [jvm]<br>class [UpdateBackfillAction](-update-backfill-action/index.md)@Inject()constructor(**caller**: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)()ActionScoped<MiskCaller?>, **transacter**: Transacter) : WebAction |
| [UpdateBackfillRequest](-update-backfill-request/index.md) | [jvm]<br>data class [UpdateBackfillRequest](-update-backfill-request/index.md)(**scan_size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **batch_size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **num_threads**: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)?, **backoff_schedule**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **extra_sleep_ms**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?) |
| [UpdateBackfillResponse](-update-backfill-response/index.md) | [jvm]<br>class [UpdateBackfillResponse](-update-backfill-response/index.md) |
| [ViewLogsAction](-view-logs-action/index.md) | [jvm]<br>class [ViewLogsAction](-view-logs-action/index.md)@Inject()constructor(**transacter**: Transacter, **viewLogsUrlProvider**: [ViewLogsUrlProvider](-view-logs-url-provider/index.md)) : WebAction |
| [ViewLogsUrlProvider](-view-logs-url-provider/index.md) | [jvm]<br>interface [ViewLogsUrlProvider](-view-logs-url-provider/index.md) |
