//[service](../../../index.md)/[app.cash.backfila.service.persistence](../index.md)/[DbRegisteredBackfill](index.md)

# DbRegisteredBackfill

[jvm]\
@Entity

class [DbRegisteredBackfill](index.md) : DbUnsharded&lt;[DbRegisteredBackfill](index.md)&gt; , DbTimestampedEntity

Stores the set of backfills that a service has registered as runnable.

## Constructors

| | |
|---|---|
| [DbRegisteredBackfill](-db-registered-backfill.md) | [jvm]<br>constructor(service_id: Id&lt;[DbService](../-db-service/index.md)&gt;, name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), parameters: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Parameter&gt;, type_provided: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, type_consumed: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, requires_approval: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), delete_by: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)?)constructor() |

## Properties

| Name | Summary |
|---|---|
| [active](active.md) | [jvm]<br>var [active](active.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)?<br>When the backfill is updated or deleted on the client service, we stop showing it, but we keep it for historic references. |
| [created_at](created_at.md) | [jvm]<br>open lateinit override var [created_at](created_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |
| [delete_by](delete_by.md) | [jvm]<br>var [delete_by](delete_by.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)?<br>Notes when this backfill should no longer be useful and the code should be deleted. This is used to power removal reminders. It guarantees that reminders will not occur until after this date. This defaults to as soon as possible if it is missing. |
| [deleted_in_service_at](deleted_in_service_at.md) | [jvm]<br>var [deleted_in_service_at](deleted_in_service_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)? |
| [id](id.md) | [jvm]<br>open lateinit override var [id](id.md): Id&lt;[DbRegisteredBackfill](index.md)&gt; |
| [name](name.md) | [jvm]<br>lateinit var [name](name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [parameters](parameters.md) | [jvm]<br>var [parameters](parameters.md): [MutableSet](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-set/index.html)&lt;[DbRegisteredParameter](../-db-registered-parameter/index.md)&gt; |
| [requires_approval](requires_approval.md) | [jvm]<br>var [requires_approval](requires_approval.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [service](service.md) | [jvm]<br>lateinit var [service](service.md): [DbService](../-db-service/index.md) |
| [service_id](service_id.md) | [jvm]<br>lateinit var [service_id](service_id.md): Id&lt;[DbService](../-db-service/index.md)&gt; |
| [type_consumed](type_consumed.md) | [jvm]<br>var [type_consumed](type_consumed.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [type_provided](type_provided.md) | [jvm]<br>var [type_provided](type_provided.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [updated_at](updated_at.md) | [jvm]<br>open lateinit override var [updated_at](updated_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |

## Functions

| Name | Summary |
|---|---|
| [deactivate](deactivate.md) | [jvm]<br>fun [deactivate](deactivate.md)(clock: [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html)) |
| [equalConfig](equal-config.md) | [jvm]<br>fun [equalConfig](equal-config.md)(other: [DbRegisteredBackfill](index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>True if the variables configured by the client service are equal to what is stored. |
| [parameterNames](parameter-names.md) | [jvm]<br>fun [parameterNames](parameter-names.md)(): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
