//[service](../../../index.md)/[app.cash.backfila.service.runner.statemachine](../index.md)/[RateCounter](index.md)

# RateCounter

[jvm]\
class [RateCounter](index.md)(clock: [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html), lookbackSeconds: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) = 60)

Calculates a sum of counts for a time period, defaulting to the last minute.

## Constructors

| | |
|---|---|
| [RateCounter](-rate-counter.md) | [jvm]<br>constructor(clock: [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html), lookbackSeconds: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) = 60) |

## Types

| Name | Summary |
|---|---|
| [Entry](-entry/index.md) | [jvm]<br>data class [Entry](-entry/index.md)(val time: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), var count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)) |

## Functions

| Name | Summary |
|---|---|
| [add](add.md) | [jvm]<br>fun [add](add.md)(count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)) |
| [projectedRate](projected-rate.md) | [jvm]<br>fun [projectedRate](projected-rate.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)<br>Get the sum, or if lookbackSeconds has not passed yet, a projected rate per lookbackSeconds based on time passed. |
| [sum](sum.md) | [jvm]<br>fun [sum](sum.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) |
