//[service](../../../index.md)/[app.cash.backfila.service.runner](../index.md)/[BackfillRunner](index.md)

# BackfillRunner

[jvm]\
class [BackfillRunner](index.md)

Coordinator of the backfill run. Starts a few actors as coroutines and updates the lease.

## Types

| Name | Summary |
|---|---|
| [BackfillMetaData](-backfill-meta-data/index.md) | [jvm]<br>data class [BackfillMetaData](-backfill-meta-data/index.md)(val backfillRunId: Id&lt;[DbBackfillRun](../../app.cash.backfila.service.persistence/-db-backfill-run/index.md)&gt;, val pkeyCursor: ByteString?, val pkeyStart: ByteString?, val pkeyEnd: ByteString?, val parameters: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), ByteString&gt;?, val batchSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val scanSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val dryRun: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html), val numThreads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html), val precomputingDone: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html), val precomputingPkeyCursor: ByteString?, val computedScannedRecordCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val computedMatchingRecordCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val extraSleepMs: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val backoffSchedule: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)&gt;, val backfilledScannedRecordCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val backfilledMatchingRecordCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)) |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |
| [Factory](-factory/index.md) | [jvm]<br>class [Factory](-factory/index.md) |

## Properties

| Name | Summary |
|---|---|
| [backfillName](backfill-name.md) | [jvm]<br>val [backfillName](backfill-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html) |
| [backfillRunId](backfill-run-id.md) | [jvm]<br>val [backfillRunId](backfill-run-id.md): Id&lt;[DbBackfillRun](../../app.cash.backfila.service.persistence/-db-backfill-run/index.md)&gt; |
| [client](client.md) | [jvm]<br>val [client](client.md): [BackfilaCallbackConnector](../../app.cash.backfila.client/-backfila-callback-connector/index.md) |
| [factory](factory.md) | [jvm]<br>val [factory](factory.md): [BackfillRunner.Factory](-factory/index.md) |
| [globalBackoff](global-backoff.md) | [jvm]<br>val [globalBackoff](global-backoff.md): [Backoff](../-backoff/index.md)<br>Backoff for all RPCs for this runner. |
| [metadata](metadata.md) | [jvm]<br>lateinit var [metadata](metadata.md): [BackfillRunner.BackfillMetaData](-backfill-meta-data/index.md)<br>Metadata about the backfill from the database. Refreshed regularly. |
| [metricLabels](metric-labels.md) | [jvm]<br>val [metricLabels](metric-labels.md): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-array/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)&gt; |
| [partitionId](partition-id.md) | [jvm]<br>val [partitionId](partition-id.md): Id&lt;[DbRunPartition](../../app.cash.backfila.service.persistence/-db-run-partition/index.md)&gt; |
| [partitionName](partition-name.md) | [jvm]<br>val [partitionName](partition-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html) |
| [runBatchBackoff](run-batch-backoff.md) | [jvm]<br>val [runBatchBackoff](run-batch-backoff.md): [Backoff](../-backoff/index.md)<br>Backoff just for RunBatch RPCs. |

## Functions

| Name | Summary |
|---|---|
| [clearLease](clear-lease.md) | [jvm]<br>fun [clearLease](clear-lease.md)() |
| [logLabel](log-label.md) | [jvm]<br>fun [logLabel](log-label.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html) |
| [onRpcFailure](on-rpc-failure.md) | [jvm]<br>suspend fun [onRpcFailure](on-rpc-failure.md)(exception: [Exception](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-exception/index.html), action: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), elapsed: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)) |
| [onRpcSuccess](on-rpc-success.md) | [jvm]<br>fun [onRpcSuccess](on-rpc-success.md)() |
| [run](run.md) | [jvm]<br>fun [run](run.md)() |
| [runBatchAsync](run-batch-async.md) | [jvm]<br>fun [runBatchAsync](run-batch-async.md)(scope: CoroutineScope, batch: GetNextBatchRangeResponse.Batch, pipelinedData: PipelinedData? = null): Deferred&lt;RunBatchResponse&gt; |
| [start](start.md) | [jvm]<br>fun [start](start.md)(coroutineScope: CoroutineScope) |
| [stop](stop.md) | [jvm]<br>fun [stop](stop.md)() |
