//[service](../../../index.md)/[app.cash.backfila.service.persistence](../index.md)/[DbRunPartition](index.md)

# DbRunPartition

[jvm]\
@Entity

class [DbRunPartition](index.md) : DbUnsharded&lt;[DbRunPartition](index.md)&gt; , DbTimestampedEntity

Backfill runs can have many partitions, e.g. one per database shard. Each partition tracks cursors individually. They are also leased individually. All partitions of a run have the same running or paused state.

## Constructors

| | |
|---|---|
| [DbRunPartition](-db-run-partition.md) | [jvm]<br>constructor(backfill_run_id: Id&lt;[DbBackfillRun](../-db-backfill-run/index.md)&gt;, partition_name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), backfill_range: KeyRange, run_state: [BackfillState](../-backfill-state/index.md), estimated_record_count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)?)constructor() |

## Properties

| Name | Summary |
|---|---|
| [backfill_run](backfill_run.md) | [jvm]<br>lateinit var [backfill_run](backfill_run.md): [DbBackfillRun](../-db-backfill-run/index.md) |
| [backfill_run_id](backfill_run_id.md) | [jvm]<br>lateinit var [backfill_run_id](backfill_run_id.md): Id&lt;[DbBackfillRun](../-db-backfill-run/index.md)&gt; |
| [backfilled_matching_record_count](backfilled_matching_record_count.md) | [jvm]<br>var [backfilled_matching_record_count](backfilled_matching_record_count.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) |
| [backfilled_scanned_record_count](backfilled_scanned_record_count.md) | [jvm]<br>var [backfilled_scanned_record_count](backfilled_scanned_record_count.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) |
| [computed_matching_record_count](computed_matching_record_count.md) | [jvm]<br>var [computed_matching_record_count](computed_matching_record_count.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)<br>How many records in the data set that match the criteria and will be backfilled. Not correct until precomputing is done. |
| [computed_scanned_record_count](computed_scanned_record_count.md) | [jvm]<br>var [computed_scanned_record_count](computed_scanned_record_count.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)<br>How many records in the data set. Not correct until precomputing is done. |
| [created_at](created_at.md) | [jvm]<br>open lateinit override var [created_at](created_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |
| [estimated_record_count](estimated_record_count.md) | [jvm]<br>var [estimated_record_count](estimated_record_count.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)? |
| [id](id.md) | [jvm]<br>open lateinit override var [id](id.md): Id&lt;[DbRunPartition](index.md)&gt; |
| [lease_expires_at](lease_expires_at.md) | [jvm]<br>lateinit var [lease_expires_at](lease_expires_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |
| [lease_token](lease_token.md) | [jvm]<br>var [lease_token](lease_token.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? |
| [matching_records_per_minute](matching_records_per_minute.md) | [jvm]<br>var [matching_records_per_minute](matching_records_per_minute.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)? |
| [partition_name](partition_name.md) | [jvm]<br>lateinit var [partition_name](partition_name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html) |
| [pkey_cursor](pkey_cursor.md) | [jvm]<br>var [pkey_cursor](pkey_cursor.md): ByteString?<br>The primary key values only make sense in the context of the client service. We provide them to the client service when needed. We store them transparently as byte strings because they can be any type. |
| [pkey_range_end](pkey_range_end.md) | [jvm]<br>var [pkey_range_end](pkey_range_end.md): ByteString? |
| [pkey_range_start](pkey_range_start.md) | [jvm]<br>var [pkey_range_start](pkey_range_start.md): ByteString? |
| [precomputing_done](precomputing_done.md) | [jvm]<br>var [precomputing_done](precomputing_done.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html) |
| [precomputing_pkey_cursor](precomputing_pkey_cursor.md) | [jvm]<br>var [precomputing_pkey_cursor](precomputing_pkey_cursor.md): ByteString?<br>Cursor used to precompute the size of the data. Precomputing is done when this equals pkey_range_end. |
| [run_state](run_state.md) | [jvm]<br>lateinit var [run_state](run_state.md): [BackfillState](../-backfill-state/index.md)<br>State of the backfill run, kept in sync with backfill_runs to allow indexing on this and the lease column. |
| [scanned_records_per_minute](scanned_records_per_minute.md) | [jvm]<br>var [scanned_records_per_minute](scanned_records_per_minute.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)? |
| [updated_at](updated_at.md) | [jvm]<br>open lateinit override var [updated_at](updated_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |
| [version](version.md) | [jvm]<br>var [version](version.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) |

## Functions

| Name | Summary |
|---|---|
| [backfillRange](backfill-range.md) | [jvm]<br>fun [backfillRange](backfill-range.md)(): KeyRange |
| [clearLease](clear-lease.md) | [jvm]<br>fun [clearLease](clear-lease.md)() |
