//[service](../../index.md)/[app.cash.backfila.dashboard](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [AppRedirectAction](-app-redirect-action/index.md) | [jvm]<br>class [AppRedirectAction](-app-redirect-action/index.md) : WebAction |
| [BackfilaApp](-backfila-app/index.md) | [jvm]<br>@Qualifier<br>@[Target](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.annotation/-target/index.html)(allowedTargets = [[AnnotationTarget.FIELD](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.annotation/-annotation-target/-f-i-e-l-d/index.html), [AnnotationTarget.FUNCTION](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.annotation/-annotation-target/-f-u-n-c-t-i-o-n/index.html)])<br>annotation class [BackfilaApp](-backfila-app/index.md)<br>Dashboard Annotation used for all tabs bound in the Backfila App |
| [BackfilaDashboardModule](-backfila-dashboard-module/index.md) | [jvm]<br>class [BackfilaDashboardModule](-backfila-dashboard-module/index.md)(val deployment: Deployment) : KAbstractModule |
| [BackfilaWebActionsModule](-backfila-web-actions-module/index.md) | [jvm]<br>class [BackfilaWebActionsModule](-backfila-web-actions-module/index.md) : KAbstractModule |
| [BackfillStateToggler](-backfill-state-toggler/index.md) | [jvm]<br>class [BackfillStateToggler](-backfill-state-toggler/index.md)@Injectconstructor(transacter: Transacter, queryFactory: Query.Factory, backfillRunListeners: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-set/index.html)&lt;[BackfillRunListener](../app.cash.backfila.service.listener/-backfill-run-listener/index.md)&gt;) |
| [CloneBackfillAction](-clone-backfill-action/index.md) | [jvm]<br>class [CloneBackfillAction](-clone-backfill-action/index.md)@Injectconstructor(caller: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)ActionScoped&lt;MiskCaller?&gt;, transacter: Transacter, queryFactory: Query.Factory, connectorProvider: [ConnectorProvider](../app.cash.backfila.client/-connector-provider/index.md)) : WebAction |
| [CloneBackfillRequest](-clone-backfill-request/index.md) | [jvm]<br>data class [CloneBackfillRequest](-clone-backfill-request/index.md)(val scan_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) = 1000, val batch_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) = 100, val num_threads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html) = 5, val range_clone_type: [RangeCloneType](-range-clone-type/index.md), val pkey_range_start: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null, val pkey_range_end: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null, val parameter_map: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), ByteString&gt; = mapOf(), val dry_run: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html) = true, val backoff_schedule: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null, val extra_sleep_ms: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) = 0) |
| [CloneBackfillResponse](-clone-backfill-response/index.md) | [jvm]<br>data class [CloneBackfillResponse](-clone-backfill-response/index.md)(val id: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)) |
| [CreateBackfillAction](-create-backfill-action/index.md) | [jvm]<br>class [CreateBackfillAction](-create-backfill-action/index.md)@Injectconstructor(caller: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)ActionScoped&lt;MiskCaller?&gt;, backfillCreator: [BackfillCreator](../app.cash.backfila/-backfill-creator/index.md)) : WebAction |
| [GetBackfillRunsAction](-get-backfill-runs-action/index.md) | [jvm]<br>class [GetBackfillRunsAction](-get-backfill-runs-action/index.md)@Injectconstructor(transacter: Transacter, queryFactory: Query.Factory) : WebAction |
| [GetBackfillRunsResponse](-get-backfill-runs-response/index.md) | [jvm]<br>data class [GetBackfillRunsResponse](-get-backfill-runs-response/index.md)(val running_backfills: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[UiBackfillRun](-ui-backfill-run/index.md)&gt;, val paused_backfills: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[UiBackfillRun](-ui-backfill-run/index.md)&gt;, val next_pagination_token: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?) |
| [GetBackfillStatusAction](-get-backfill-status-action/index.md) | [jvm]<br>class [GetBackfillStatusAction](-get-backfill-status-action/index.md)@Injectconstructor(transacter: Transacter, queryFactory: Query.Factory) : WebAction |
| [GetBackfillStatusResponse](-get-backfill-status-response/index.md) | [jvm]<br>data class [GetBackfillStatusResponse](-get-backfill-status-response/index.md)(val service_name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val variant: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val state: [BackfillState](../app.cash.backfila.service.persistence/-backfill-state/index.md), val parameters: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)&gt;?, val batch_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val scan_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val dry_run: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html), val num_threads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html), val created_at: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html), val created_by_user: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val extra_sleep_ms: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val backoff_schedule: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val partitions: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[UiPartition](-ui-partition/index.md)&gt;, val event_logs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[UiEventLog](-ui-event-log/index.md)&gt;) |
| [GetRegisteredBackfillsAction](-get-registered-backfills-action/index.md) | [jvm]<br>class [GetRegisteredBackfillsAction](-get-registered-backfills-action/index.md)@Injectconstructor(transacter: Transacter, queryFactory: Query.Factory) : WebAction |
| [GetRegisteredBackfillsResponse](-get-registered-backfills-response/index.md) | [jvm]<br>data class [GetRegisteredBackfillsResponse](-get-registered-backfills-response/index.md)(val backfills: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[RegisteredBackfill](-registered-backfill/index.md)&gt;) |
| [GetServicesAction](-get-services-action/index.md) | [jvm]<br>class [GetServicesAction](-get-services-action/index.md)@Injectconstructor(transacter: Transacter, queryFactory: Query.Factory) : WebAction |
| [GetServiceVariantsAction](-get-service-variants-action/index.md) | [jvm]<br>class [GetServiceVariantsAction](-get-service-variants-action/index.md)@Injectconstructor(transacter: Transacter, queryFactory: Query.Factory) : WebAction |
| [RangeCloneType](-range-clone-type/index.md) | [jvm]<br>enum [RangeCloneType](-range-clone-type/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-enum/index.html)&lt;[RangeCloneType](-range-clone-type/index.md)&gt; |
| [RegisteredBackfill](-registered-backfill/index.md) | [jvm]<br>data class [RegisteredBackfill](-registered-backfill/index.md)(val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val parameterNames: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)&gt;) |
| [RootRedirectAction](-root-redirect-action/index.md) | [jvm]<br>class [RootRedirectAction](-root-redirect-action/index.md) : WebAction |
| [StartBackfillAction](-start-backfill-action/index.md) | [jvm]<br>class [StartBackfillAction](-start-backfill-action/index.md)@Injectconstructor(caller: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)ActionScoped&lt;MiskCaller?&gt;, backfillStateToggler: [BackfillStateToggler](-backfill-state-toggler/index.md)) : WebAction |
| [StartBackfillRequest](-start-backfill-request/index.md) | [jvm]<br>class [StartBackfillRequest](-start-backfill-request/index.md) |
| [StartBackfillResponse](-start-backfill-response/index.md) | [jvm]<br>class [StartBackfillResponse](-start-backfill-response/index.md) |
| [StopAllBackfillsAction](-stop-all-backfills-action/index.md) | [jvm]<br>class [StopAllBackfillsAction](-stop-all-backfills-action/index.md)@Injectconstructor(caller: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)ActionScoped&lt;MiskCaller?&gt;, backfillStateToggler: [BackfillStateToggler](-backfill-state-toggler/index.md), transacter: Transacter, queryFactory: Query.Factory) : WebAction |
| [StopAllBackfillsRequest](-stop-all-backfills-request/index.md) | [jvm]<br>class [StopAllBackfillsRequest](-stop-all-backfills-request/index.md) |
| [StopAllBackfillsResponse](-stop-all-backfills-response/index.md) | [jvm]<br>class [StopAllBackfillsResponse](-stop-all-backfills-response/index.md) |
| [StopBackfillAction](-stop-backfill-action/index.md) | [jvm]<br>class [StopBackfillAction](-stop-backfill-action/index.md)@Injectconstructor(caller: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)ActionScoped&lt;MiskCaller?&gt;, backfillStateToggler: [BackfillStateToggler](-backfill-state-toggler/index.md)) : WebAction |
| [StopBackfillRequest](-stop-backfill-request/index.md) | [jvm]<br>class [StopBackfillRequest](-stop-backfill-request/index.md) |
| [StopBackfillResponse](-stop-backfill-response/index.md) | [jvm]<br>class [StopBackfillResponse](-stop-backfill-response/index.md) |
| [UiBackfillRun](-ui-backfill-run/index.md) | [jvm]<br>data class [UiBackfillRun](-ui-backfill-run/index.md)(val id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val state: [BackfillState](../app.cash.backfila.service.persistence/-backfill-state/index.md), val dry_run: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html), val created_at: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html), val created_by_user: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val last_active_at: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html), val precomputing_done: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html), val computed_matching_record_count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val backfilled_matching_record_count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)) |
| [UiEventLog](-ui-event-log/index.md) | [jvm]<br>data class [UiEventLog](-ui-event-log/index.md)(val occurred_at: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html), val type: [DbEventLog.Type](../app.cash.backfila.service.persistence/-db-event-log/-type/index.md), val user: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val partition_name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val extra_data: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?) |
| [UiPartition](-ui-partition/index.md) | [jvm]<br>data class [UiPartition](-ui-partition/index.md)(val id: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val state: [BackfillState](../app.cash.backfila.service.persistence/-backfill-state/index.md), val pkey_cursor: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val pkey_start: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val pkey_end: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val precomputing_done: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html), val precomputing_pkey_cursor: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, val computed_scanned_record_count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val computed_matching_record_count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val backfilled_scanned_record_count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val backfilled_matching_record_count: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), val scanned_records_per_minute: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)?, val matching_records_per_minute: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)?) |
| [UpdateBackfillAction](-update-backfill-action/index.md) | [jvm]<br>class [UpdateBackfillAction](-update-backfill-action/index.md)@Injectconstructor(caller: @[JvmSuppressWildcards](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.jvm/-jvm-suppress-wildcards/index.html)ActionScoped&lt;MiskCaller?&gt;, transacter: Transacter) : WebAction |
| [UpdateBackfillRequest](-update-backfill-request/index.md) | [jvm]<br>data class [UpdateBackfillRequest](-update-backfill-request/index.md)(val scan_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)? = null, val batch_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)? = null, val num_threads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html)? = null, val backoff_schedule: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null, val extra_sleep_ms: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)? = null) |
| [UpdateBackfillResponse](-update-backfill-response/index.md) | [jvm]<br>class [UpdateBackfillResponse](-update-backfill-response/index.md) |
| [ViewLogsAction](-view-logs-action/index.md) | [jvm]<br>class [ViewLogsAction](-view-logs-action/index.md)@Injectconstructor(transacter: Transacter, viewLogsUrlProvider: [ViewLogsUrlProvider](-view-logs-url-provider/index.md)) : WebAction |
| [ViewLogsUrlProvider](-view-logs-url-provider/index.md) | [jvm]<br>interface [ViewLogsUrlProvider](-view-logs-url-provider/index.md) |
