//[service](../../../index.md)/[app.cash.backfila.service.persistence](../index.md)/[DbBackfillRun](index.md)

# DbBackfillRun

[jvm]\
@Entity

class [DbBackfillRun](index.md) : DbUnsharded&lt;[DbBackfillRun](index.md)&gt; , DbTimestampedEntity

Tracks the state of a created backfill.

## Constructors

| | |
|---|---|
| [DbBackfillRun](-db-backfill-run.md) | [jvm]<br>constructor(service_id: Id&lt;[DbService](../-db-service/index.md)&gt;, registered_backfill_id: Id&lt;[DbRegisteredBackfill](../-db-registered-backfill/index.md)&gt;, parameter_map: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), ByteString&gt;, state: [BackfillState](../-backfill-state/index.md), created_by_user: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, scan_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), batch_size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html), num_threads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html), backoff_schedule: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?, dry_run: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html), extra_sleep_ms: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html))constructor() |

## Properties

| Name | Summary |
|---|---|
| [approved_at](approved_at.md) | [jvm]<br>var [approved_at](approved_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)? |
| [approved_by_user](approved_by_user.md) | [jvm]<br>var [approved_by_user](approved_by_user.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? |
| [backoff_schedule](backoff_schedule.md) | [jvm]<br>var [backoff_schedule](backoff_schedule.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)?<br>Comma separated list of delays for consecutive retries in milliseconds, e.g. 1000,2000 |
| [batch_size](batch_size.md) | [jvm]<br>var [batch_size](batch_size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) |
| [created_at](created_at.md) | [jvm]<br>open lateinit override var [created_at](created_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |
| [created_by_user](created_by_user.md) | [jvm]<br>var [created_by_user](created_by_user.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? |
| [dry_run](dry_run.md) | [jvm]<br>var [dry_run](dry_run.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-boolean/index.html) |
| [extra_sleep_ms](extra_sleep_ms.md) | [jvm]<br>var [extra_sleep_ms](extra_sleep_ms.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html)<br>Sleep that is added after every successful RunBatch. To be used when automatic backpressure is not available. |
| [id](id.md) | [jvm]<br>open lateinit override var [id](id.md): Id&lt;[DbBackfillRun](index.md)&gt; |
| [num_threads](num_threads.md) | [jvm]<br>var [num_threads](num_threads.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html) |
| [parameter_map](parameter_map.md) | [jvm]<br>var [parameter_map](parameter_map.md): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)&gt;? |
| [pipeline_target_backfill_id](pipeline_target_backfill_id.md) | [jvm]<br>var [pipeline_target_backfill_id](pipeline_target_backfill_id.md): Id&lt;[DbRegisteredBackfill](../-db-registered-backfill/index.md)&gt;? |
| [registered_backfill](registered_backfill.md) | [jvm]<br>lateinit var [registered_backfill](registered_backfill.md): [DbRegisteredBackfill](../-db-registered-backfill/index.md) |
| [registered_backfill_id](registered_backfill_id.md) | [jvm]<br>lateinit var [registered_backfill_id](registered_backfill_id.md): Id&lt;[DbRegisteredBackfill](../-db-registered-backfill/index.md)&gt;<br>Immutably stores the data configured by the client service for this backfill. |
| [scan_size](scan_size.md) | [jvm]<br>var [scan_size](scan_size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) |
| [service](service.md) | [jvm]<br>lateinit var [service](service.md): [DbService](../-db-service/index.md) |
| [service_id](service_id.md) | [jvm]<br>lateinit var [service_id](service_id.md): Id&lt;[DbService](../-db-service/index.md)&gt; |
| [state](state.md) | [jvm]<br>lateinit var [state](state.md): [BackfillState](../-backfill-state/index.md) |
| [updated_at](updated_at.md) | [jvm]<br>open lateinit override var [updated_at](updated_at.md): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |
| [version](version.md) | [jvm]<br>var [version](version.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) |

## Functions

| Name | Summary |
|---|---|
| [backoffSchedule](backoff-schedule.md) | [jvm]<br>fun [backoffSchedule](backoff-schedule.md)(): &lt;Error class: unknown class&gt;? |
| [complete](complete.md) | [jvm]<br>fun [complete](complete.md)() |
| [parameters](parameters.md) | [jvm]<br>fun [parameters](parameters.md)(): &lt;Error class: unknown class&gt; |
| [partitions](partitions.md) | [jvm]<br>fun [partitions](partitions.md)(session: Session, queryFactory: Query.Factory): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[DbRunPartition](../-db-run-partition/index.md)&gt; |
| [setState](set-state.md) | [jvm]<br>fun [setState](set-state.md)(session: Session, queryFactory: Query.Factory, state: [BackfillState](../-backfill-state/index.md)) |
