//[service](../../index.md)/[app.cash.backfila.service.runner.statemachine](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [AwaitingRun](-awaiting-run/index.md) | [jvm]<br>data class [AwaitingRun](-awaiting-run/index.md)(val batch: GetNextBatchRangeResponse.Batch, val runBatchRpc: Deferred&lt;RunBatchResponse&gt;, val startedAt: [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)) |
| [BatchAwaiter](-batch-awaiter/index.md) | [jvm]<br>class [BatchAwaiter](-batch-awaiter/index.md)(backfillRunner: [BackfillRunner](../app.cash.backfila.service.runner/-backfill-runner/index.md), receiveChannel: ReceiveChannel&lt;[AwaitingRun](-awaiting-run/index.md)&gt;, rpcBackpressureChannel: ReceiveChannel&lt;[Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-unit/index.html)&gt;)<br>Receives RunBatch RPC futures from the BatchRunner and handles the results, potentially enqueueing a retry. |
| [BatchPrecomputer](-batch-precomputer/index.md) | [jvm]<br>class [BatchPrecomputer](-batch-precomputer/index.md)(backfillRunner: [BackfillRunner](../app.cash.backfila.service.runner/-backfill-runner/index.md)) |
| [BatchQueuer](-batch-queuer/index.md) | [jvm]<br>class [BatchQueuer](-batch-queuer/index.md)(backfillRunner: [BackfillRunner](../app.cash.backfila.service.runner/-backfill-runner/index.md), numThreads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html))<br>Sends RPCs to the client service to compute batch ranges and sends them along a channel to the BatchQueuer. |
| [BatchRunner](-batch-runner/index.md) | [jvm]<br>class [BatchRunner](-batch-runner/index.md)(backfillRunner: [BackfillRunner](../app.cash.backfila.service.runner/-backfill-runner/index.md), nextBatchChannel: ReceiveChannel&lt;GetNextBatchRangeResponse.Batch&gt;, numThreads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html))<br>Receives batch ranges from the BatchQueuer and starts RPCs to the client service to run batches. The futures are sent along a channel and are handled in the BatchAwaiter. |
| [RateCounter](-rate-counter/index.md) | [jvm]<br>class [RateCounter](-rate-counter/index.md)(clock: [Clock](https://docs.oracle.com/javase/8/docs/api/java/time/Clock.html), lookbackSeconds: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-long/index.html) = 60)<br>Calculates a sum of counts for a time period, defaulting to the last minute. |
| [RunBatchException](-run-batch-exception/index.md) | [jvm]<br>class [RunBatchException](-run-batch-exception/index.md)(val stackTrace: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)) : [Exception](https://docs.oracle.com/javase/8/docs/api/java/lang/Exception.html) |
| [VariableCapacityChannel](-variable-capacity-channel/index.md) | [jvm]<br>class [VariableCapacityChannel](-variable-capacity-channel/index.md)&lt;[T](-variable-capacity-channel/index.md)&gt;(capacity: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html), queueSizeChangeListener: ([Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-unit/index.html) = {}) |
