//[service](../../../index.md)/[app.cash.backfila.service](../index.md)/[BackfilaConfig](index.md)

# BackfilaConfig

[jvm]\
data class [BackfilaConfig](index.md)(val backfill_runner_threads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html)?, val data_source_clusters: DataSourceClustersConfig, val slack: SlackConfig?, val web_url_root: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), val minimum_batches_per_get_next_batch_call: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html) = 1, val batch_queue_thread_multiplier: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html) = 2, val support_button_label: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null, val support_button_url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null) : Config

## Constructors

| | |
|---|---|
| [BackfilaConfig](-backfila-config.md) | [jvm]<br>constructor(backfill_runner_threads: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html)?, data_source_clusters: DataSourceClustersConfig, slack: SlackConfig?, web_url_root: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html), minimum_batches_per_get_next_batch_call: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html) = 1, batch_queue_thread_multiplier: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html) = 2, support_button_label: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null, support_button_url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null) |

## Properties

| Name | Summary |
|---|---|
| [backfill_runner_threads](backfill_runner_threads.md) | [jvm]<br>val [backfill_runner_threads](backfill_runner_threads.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html)? |
| [batch_queue_thread_multiplier](batch_queue_thread_multiplier.md) | [jvm]<br>val [batch_queue_thread_multiplier](batch_queue_thread_multiplier.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html) = 2<br>For every thread of a backfill, sets the max number of batches to keep queued. |
| [data_source_clusters](data_source_clusters.md) | [jvm]<br>val [data_source_clusters](data_source_clusters.md): DataSourceClustersConfig |
| [minimum_batches_per_get_next_batch_call](minimum_batches_per_get_next_batch_call.md) | [jvm]<br>val [minimum_batches_per_get_next_batch_call](minimum_batches_per_get_next_batch_call.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-int/index.html) = 1<br>Sets the minimum number of batches to compute per GetNextBatch call. |
| [slack](slack.md) | [jvm]<br>val [slack](slack.md): SlackConfig?<br>Configures Slack API for Backfila Slackbot to notify on backfill status changes. |
| [support_button_label](support_button_label.md) | [jvm]<br>val [support_button_label](support_button_label.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null<br>Support banner shows up on all pages and can point to a Slack channel or other support method, if null banner not shown. |
| [support_button_url](support_button_url.md) | [jvm]<br>val [support_button_url](support_button_url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)? = null<br>Support banner shows up on all pages and can point to a Slack channel or other support method, if null banner not shown. |
| [web_url_root](web_url_root.md) | [jvm]<br>val [web_url_root](web_url_root.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin-stdlib/kotlin/-string/index.html)<br>Used to construct absolute links to the dashboard, ie. from the Backfila Slackbot. |
