/*
 * Decompiled with CFR 0.152.
 */
package app.cash.licensee;

import app.cash.licensee.DependencyConfig;
import app.cash.licensee.DependencyCoordinates;
import app.cash.licensee.DependencyResolutionResult;
import app.cash.licensee.IgnoredData;
import app.cash.licensee.PomInfo;
import app.cash.licensee.PomLicense;
import app.cash.licensee.PomScm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Scm;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Category;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001al\u0010\u0000\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00100\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0005H\u0002\u001a&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001dH\u0000\u00a8\u0006\u001e"}, d2={"loadDependencyCoordinates", "Lapp/cash/licensee/DependencyResolutionResult;", "logger", "Lorg/gradle/api/logging/Logger;", "root", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "config", "Lapp/cash/licensee/DependencyConfig;", "toDependencyCoordinates", "Lapp/cash/licensee/DependencyCoordinates;", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "", "unusedGroupIds", "", "", "unusedCoordinates", "Lkotlin/Pair;", "destination", "seen", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "depth", "", "isPlatform", "", "loadPomInfo", "Lapp/cash/licensee/PomInfo;", "pom", "Lorg/apache/maven/model/Model;", "getRawModel", "Lkotlin/Function1;", "licensee"})
@SourceDebugExtension(value={"SMAP\ndependencyGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dependencyGraph.kt\napp/cash/licensee/DependencyGraphKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1#2:220\n1628#3,3:221\n*S KotlinDebug\n*F\n+ 1 dependencyGraph.kt\napp/cash/licensee/DependencyGraphKt\n*L\n213#1:221,3\n*E\n"})
public final class DependencyGraphKt {
    @NotNull
    public static final DependencyResolutionResult loadDependencyCoordinates(@NotNull Logger logger, @NotNull ResolvedComponentResult root, @NotNull DependencyConfig config) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List warnings = new ArrayList();
        Set unusedGroupIds = CollectionsKt.toMutableSet((Iterable)config.getIgnoredGroupIds().keySet());
        Set unusedCoordinates = new LinkedHashSet();
        for (Map.Entry<String, Map<String, IgnoredData>> iterator : config.getIgnoredCoordinates().entrySet()) {
            String groupId = iterator.getKey();
            Map<String, IgnoredData> artifacts = iterator.getValue();
            boolean redundant = config.getIgnoredGroupIds().containsKey(groupId);
            for (String artifactId : artifacts.keySet()) {
                if (redundant) {
                    ((Collection)warnings).add("Ignore for " + groupId + ":" + artifactId + " is redundant as " + groupId + " is also ignored");
                    continue;
                }
                ((Collection)unusedCoordinates).add(TuplesKt.to((Object)groupId, (Object)artifactId));
            }
        }
        Set coordinates = new LinkedHashSet();
        DependencyGraphKt.loadDependencyCoordinates(logger, root, config, unusedGroupIds, unusedCoordinates, coordinates, new LinkedHashSet(), 1);
        for (String unusedGroupId : unusedGroupIds) {
            ((Collection)warnings).add("Dependency ignore for " + unusedGroupId + " is unused");
        }
        for (Pair pair : unusedCoordinates) {
            String groupId = (String)pair.component1();
            String artifactId = (String)pair.component2();
            ((Collection)warnings).add("Dependency ignore for " + groupId + ":" + artifactId + " is unused");
        }
        return new DependencyResolutionResult(coordinates, warnings);
    }

    @NotNull
    public static final DependencyCoordinates toDependencyCoordinates(@NotNull ModuleComponentIdentifier $this$toDependencyCoordinates) {
        Intrinsics.checkNotNullParameter((Object)$this$toDependencyCoordinates, (String)"<this>");
        String string = $this$toDependencyCoordinates.getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
        String string2 = $this$toDependencyCoordinates.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModule(...)");
        String string3 = $this$toDependencyCoordinates.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
        return new DependencyCoordinates(string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadDependencyCoordinates(Logger logger, ResolvedComponentResult root, DependencyConfig config, Set<String> unusedGroupIds, Set<Pair<String, String>> unusedCoordinates, Set<DependencyCoordinates> destination, Set<ComponentIdentifier> seen, int depth) {
        StringBuilder stringBuilder;
        ComponentIdentifier id = root.getId();
        boolean processTransitiveDependencies = true;
        String ignoreSuffix = null;
        if (id instanceof ProjectComponentIdentifier) {
            ignoreSuffix = " ignoring because project dependency";
        } else if (DependencyGraphKt.isPlatform(root)) {
            ignoreSuffix = " ignoring because platform dependency";
        } else if (id instanceof ModuleComponentIdentifier) {
            if (Intrinsics.areEqual((Object)((ModuleComponentIdentifier)id).getGroup(), (Object)"") && Intrinsics.areEqual((Object)((ModuleComponentIdentifier)id).getVersion(), (Object)"")) {
                ignoreSuffix = " ignoring because flat-dir repository artifact has no metadata";
            } else {
                IgnoredData ignoredData;
                IgnoredData ignoredData2;
                IgnoredData ignoredData3;
                IgnoredData it;
                IgnoredData ignoredData4;
                Map<String, IgnoredData> map = config.getIgnoredGroupIds().get(((ModuleComponentIdentifier)id).getGroup());
                if (map != null) {
                    it = ignoredData4 = map;
                    boolean bl = false;
                    ((Collection)unusedGroupIds).remove(((ModuleComponentIdentifier)id).getGroup());
                    ignoredData3 = ignoredData4;
                } else {
                    ignoredData3 = ignoredData2 = null;
                }
                if (ignoredData3 == null) {
                    map = config.getIgnoredCoordinates().get(((ModuleComponentIdentifier)id).getGroup());
                    if (map != null && (ignoredData4 = (IgnoredData)map.get(((ModuleComponentIdentifier)id).getModule())) != null) {
                        IgnoredData it2 = it = ignoredData4;
                        boolean bl = false;
                        ((Collection)unusedCoordinates).remove(TuplesKt.to((Object)((ModuleComponentIdentifier)id).getGroup(), (Object)((ModuleComponentIdentifier)id).getModule()));
                        ignoredData2 = it;
                    } else {
                        ignoredData2 = null;
                    }
                }
                if ((ignoredData = ignoredData2) != null) {
                    StringBuilder $this$loadDependencyCoordinates_u24lambda_u242 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$loadDependencyCoordinates_u24lambda_u242.append(" ignoring");
                    if (ignoredData.getTransitive()) {
                        $this$loadDependencyCoordinates_u24lambda_u242.append(" [transitive=true]");
                    }
                    if (ignoredData.getReason() != null) {
                        $this$loadDependencyCoordinates_u24lambda_u242.append(" because ");
                        $this$loadDependencyCoordinates_u24lambda_u242.append(ignoredData.getReason());
                    }
                    String string = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    ignoreSuffix = string;
                    processTransitiveDependencies = !ignoredData.getTransitive();
                } else {
                    ((Collection)destination).add(DependencyGraphKt.toDependencyCoordinates((ModuleComponentIdentifier)id));
                }
            }
        } else {
            throw new IllegalStateException(("Unknown dependency " + id.getClass() + ": " + id).toString());
        }
        if (logger.isInfoEnabled()) {
            void $this$loadDependencyCoordinates_u24lambda_u244;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder = stringBuilder2;
            Logger logger2 = logger;
            boolean bl = false;
            int n = 0;
            while (n < depth) {
                int it = n++;
                boolean bl2 = false;
                $this$loadDependencyCoordinates_u24lambda_u244.append("  ");
            }
            $this$loadDependencyCoordinates_u24lambda_u244.append(id);
            if (ignoreSuffix != null) {
                $this$loadDependencyCoordinates_u24lambda_u244.append(ignoreSuffix);
            }
            String string = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            logger2.info(string);
        }
        if (processTransitiveDependencies) {
            for (DependencyResult dependency : root.getDependencies()) {
                if (!(dependency instanceof ResolvedDependencyResult)) continue;
                ResolvedComponentResult selected = ((ResolvedDependencyResult)dependency).getSelected();
                ComponentIdentifier componentIdentifier = selected.getId();
                Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"getId(...)");
                if (!seen.add(componentIdentifier)) continue;
                Intrinsics.checkNotNull((Object)selected);
                DependencyGraphKt.loadDependencyCoordinates(logger, selected, config, unusedGroupIds, unusedCoordinates, destination, seen, depth + 1);
            }
        }
    }

    private static final boolean isPlatform(ResolvedComponentResult $this$isPlatform) {
        List list = $this$isPlatform.getVariants();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVariants(...)");
        ResolvedVariantResult resolvedVariantResult = (ResolvedVariantResult)CollectionsKt.singleOrNull((List)list);
        if (resolvedVariantResult == null) {
            return false;
        }
        ResolvedVariantResult singleVariant = resolvedVariantResult;
        Attribute stringAttribute = Attribute.of((String)Category.CATEGORY_ATTRIBUTE.getName(), String.class);
        String string = (String)singleVariant.getAttributes().getAttribute(stringAttribute);
        if (string == null) {
            return false;
        }
        String category = string;
        String string2 = category;
        return Intrinsics.areEqual((Object)string2, (Object)"enforced-platform") || Intrinsics.areEqual((Object)string2, (Object)"platform");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final PomInfo loadPomInfo(@NotNull Model pom, @NotNull Function1<? super String, ? extends Model> getRawModel) {
        Set set;
        Collection it;
        List list;
        String string;
        String url;
        String string2;
        Model model;
        Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
        Intrinsics.checkNotNullParameter(getRawModel, (String)"getRawModel");
        Parent parent = pom.getParent();
        if (parent != null) {
            Parent it2 = parent;
            boolean bl = false;
            model = (Model)getRawModel.invoke((Object)(it2.getGroupId() + ":" + it2.getArtifactId() + ":" + it2.getVersion()));
        } else {
            model = null;
        }
        Model parentRawModel = model;
        Scm pomScm = pom.getScm();
        if (parentRawModel != null) {
            Boolean bl;
            Scm parentScm = parentRawModel.getScm();
            Object object = parentScm;
            Boolean bl2 = object != null && (object = object.getChildScmUrlInheritAppendPath()) != null ? Boolean.valueOf(Boolean.parseBoolean((String)object)) : (bl = null);
            if (bl == null) {
                string2 = pomScm;
                if (string2 == null || (string2 = string2.getUrl()) == null || (string2 = StringsKt.removeSuffix((String)string2, (CharSequence)("/" + pom.getArtifactId()))) == null) {
                    Scm scm = parentScm;
                    string2 = scm != null ? scm.getUrl() : null;
                }
            } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                string2 = parentScm.getUrl();
            } else {
                if (!Intrinsics.areEqual((Object)bl, (Object)true)) throw new NoWhenBranchMatchedException();
                Scm scm = pomScm;
                string2 = scm != null ? scm.getUrl() : null;
            }
        } else {
            Scm scm = pomScm;
            string2 = url = scm != null ? scm.getUrl() : null;
        }
        if ((string = pom.getName()) == null) {
            Model model2 = parentRawModel;
            string = model2 != null ? model2.getName() : null;
        }
        List list2 = list = pom.getLicenses();
        String string3 = string;
        boolean bl = false;
        boolean bl3 = it.isEmpty();
        String string4 = string3;
        List list3 = !bl3 ? list : null;
        if (list3 == null) {
            Model model3 = parentRawModel;
            list3 = model3 != null ? model3.getLicenses() : null;
        }
        if (list3 != null) {
            void destination$iv;
            Iterable iterable = list3;
            it = new LinkedHashSet();
            string3 = string4;
            boolean $i$f$mapTo = false;
            for (Object item$iv : iterable) {
                void it3;
                License license = (License)item$iv;
                void var15_14 = destination$iv;
                boolean bl4 = false;
                var15_14.add(new PomLicense(it3.getName(), it3.getUrl()));
            }
            string4 = string3;
            set = (Set)destination$iv;
        } else {
            set = SetsKt.emptySet();
        }
        PomScm pomScm2 = new PomScm(url);
        Set set2 = set;
        String string5 = string4;
        return new PomInfo(string5, set2, pomScm2);
    }
}

