/*
 * Decompiled with CFR 0.152.
 */
package app.cash.licensee;

import app.cash.licensee.ArtifactDetail;
import app.cash.licensee.DependencyCoordinates;
import app.cash.licensee.SpdxLicense;
import app.cash.licensee.UnknownLicense;
import app.cash.licensee.ValidationConfig;
import app.cash.licensee.ValidationResult;
import app.cash.licensee.ValidationResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u00a8\u0006\u0007"}, d2={"validateArtifacts", "Lapp/cash/licensee/ValidationResults;", "validationConfig", "Lapp/cash/licensee/ValidationConfig;", "artifacts", "", "Lapp/cash/licensee/ArtifactDetail;", "licensee"})
@SourceDebugExtension(value={"SMAP\nlicenseValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 licenseValidation.kt\napp/cash/licensee/LicenseValidationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1755#2,3:174\n1872#2,3:177\n295#2,2:180\n*S KotlinDebug\n*F\n+ 1 licenseValidation.kt\napp/cash/licensee/LicenseValidationKt\n*L\n108#1:174,3\n125#1:177,3\n132#1:180,2\n*E\n"})
public final class LicenseValidationKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ValidationResults validateArtifacts(@NotNull ValidationConfig validationConfig, @NotNull List<ArtifactDetail> artifacts) {
        Intrinsics.checkNotNullParameter((Object)validationConfig, (String)"validationConfig");
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        List configResults = new ArrayList();
        Map artifactResultMap = new LinkedHashMap();
        Set unusedAllowedIdentifiers = CollectionsKt.toMutableSet((Iterable)validationConfig.getAllowedIdentifiers());
        Map unusedAllowedUrls = MapsKt.toMutableMap(validationConfig.getAllowedUrls());
        Set unusedAllowedCoordinates = CollectionsKt.toMutableSet((Iterable)validationConfig.getAllowedCoordinates().keySet());
        for (ArtifactDetail artifact : artifacts) {
            int n;
            boolean bl;
            Iterable $this$any$iv;
            DependencyCoordinates dependencyCoordinates;
            List artifactResults;
            block23: {
                artifactResults = new ArrayList();
                dependencyCoordinates = new DependencyCoordinates(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                boolean validated = false;
                for (SpdxLicense spdxLicense : artifact.getSpdxLicenses()) {
                    if (validationConfig.getAllowedIdentifiers().contains(spdxLicense.getIdentifier())) {
                        ((Collection)unusedAllowedIdentifiers).remove(spdxLicense.getIdentifier());
                        ((Collection)artifactResults).add(new ValidationResult.Info("SPDX identifier '" + spdxLicense.getIdentifier() + "' allowed"));
                        validated = true;
                        break;
                    }
                    if (!validationConfig.getAllowedUrls().containsKey(spdxLicense.getUrl())) continue;
                    unusedAllowedUrls.remove(spdxLicense.getUrl());
                    ((Collection)artifactResults).add(new ValidationResult.Warning("License URL '" + spdxLicense.getUrl() + "' was allowed but could use SPDX identifier '" + spdxLicense.getIdentifier() + "'"));
                    validated = true;
                    break;
                }
                if (!validated) {
                    for (UnknownLicense unknownLicense : artifact.getUnknownLicenses()) {
                        if (unknownLicense.getUrl() == null || !validationConfig.getAllowedUrls().containsKey(unknownLicense.getUrl())) continue;
                        unusedAllowedUrls.remove(unknownLicense.getUrl());
                        String reason = validationConfig.getAllowedUrls().get(unknownLicense.getUrl());
                        Object object = reason;
                        ((Collection)artifactResults).add(new ValidationResult.Info("Unknown license URL '" + unknownLicense.getUrl() + "' allowed" + (String)(object != null ? " because " + (String)object : "")));
                        validated = true;
                        break;
                    }
                }
                if (!validated) {
                    for (SpdxLicense spdxLicense : artifact.getSpdxLicenses()) {
                        ((Collection)artifactResults).add(new ValidationResult.Error("SPDX identifier '" + spdxLicense.getIdentifier() + "' is NOT allowed"));
                    }
                    for (UnknownLicense unknownLicense : artifact.getUnknownLicenses()) {
                        ((Collection)artifactResults).add(new ValidationResult.Error(unknownLicense.getUrl() == null ? "Unknown license name '" + unknownLicense.getName() + "' with no URL is NOT allowed" : "Unknown license URL '" + unknownLicense.getUrl() + "' is NOT allowed"));
                    }
                    if (artifact.getSpdxLicenses().isEmpty() && artifact.getUnknownLicenses().isEmpty()) {
                        ((Collection)artifactResults).add(new ValidationResult.Error("Artifact declares no licenses!"));
                    }
                }
                $this$any$iv = artifactResults;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValidationResult it = (ValidationResult)element$iv;
                        n = 0;
                        if (!(it instanceof ValidationResult.Error)) continue;
                        bl = true;
                        break block23;
                    }
                    bl = false;
                }
            }
            if (bl) {
                if (validationConfig.getAllowedCoordinates().containsKey(dependencyCoordinates)) {
                    String string;
                    StringBuilder $i$f$any;
                    ((Collection)unusedAllowedCoordinates).remove(dependencyCoordinates);
                    $this$any$iv = artifactResults;
                    StringBuilder $this$validateArtifacts_u24lambda_u241 = $i$f$any = new StringBuilder();
                    boolean bl2 = false;
                    $this$validateArtifacts_u24lambda_u241.append("Coordinate version is allowed");
                    String reason = validationConfig.getAllowedCoordinates().get(dependencyCoordinates);
                    if (reason != null) {
                        $this$validateArtifacts_u24lambda_u241.append(" because ");
                        $this$validateArtifacts_u24lambda_u241.append(reason);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$any.toString(), (String)"toString(...)");
                    $this$any$iv.add(new ValidationResult.Info(string));
                    Iterable $this$forEachIndexed$iv = artifactResults;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void result;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ValidationResult validationResult = (ValidationResult)item$iv;
                        int index = n;
                        boolean bl3 = false;
                        if (!(result instanceof ValidationResult.Error)) continue;
                        artifactResults.set(index, new ValidationResult.Info(((ValidationResult.Error)result).getMessage()));
                    }
                } else {
                    Object v2;
                    block24: {
                        void $this$firstOrNull$iv;
                        Iterable $i$f$forEachIndexed = validationConfig.getAllowedCoordinates().keySet();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            DependencyCoordinates it = (DependencyCoordinates)element$iv;
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)it.getGroup(), (Object)artifact.getGroupId()) && Intrinsics.areEqual((Object)it.getArtifact(), (Object)artifact.getArtifactId()))) continue;
                            v2 = element$iv;
                            break block24;
                        }
                        v2 = null;
                    }
                    DependencyCoordinates candidate = v2;
                    if (candidate != null) {
                        ((Collection)artifactResults).add(new ValidationResult.Warning("Coordinates match an allowed dependency but version does not match (" + candidate.getVersion() + " != " + artifact.getVersion() + ")"));
                    }
                }
            }
            artifactResultMap.put(artifact, artifactResults);
        }
        for (String unusedAllowedIdentifier : unusedAllowedIdentifiers) {
            ((Collection)configResults).add(new ValidationResult.Warning("Allowed SPDX identifier '" + unusedAllowedIdentifier + "' is unused"));
        }
        for (String unusedAllowedUrl : unusedAllowedUrls.keySet()) {
            ((Collection)configResults).add(new ValidationResult.Warning("Allowed license URL '" + unusedAllowedUrl + "' is unused"));
        }
        for (DependencyCoordinates unusedAllowedCoordinate : unusedAllowedCoordinates) {
            ((Collection)configResults).add(new ValidationResult.Warning("Allowed dependency '" + unusedAllowedCoordinate.getGroup() + ":" + unusedAllowedCoordinate.getArtifact() + ":" + unusedAllowedCoordinate.getVersion() + "' is unused"));
        }
        return new ValidationResults(configResults, artifactResultMap);
    }
}

