/*
 * Decompiled with CFR 0.152.
 */
package app.cash.licensee;

import app.cash.licensee.ArtifactDetail;
import app.cash.licensee.ArtifactScm;
import app.cash.licensee.DependencyCoordinates;
import app.cash.licensee.LicensesKt;
import app.cash.licensee.PomInfo;
import app.cash.licensee.PomLicense;
import app.cash.licensee.PomScm;
import app.cash.licensee.SpdxId;
import app.cash.licensee.SpdxLicense;
import app.cash.licensee.UnknownLicense;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0000\u001a\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001*\u00020\fH\u0002\u001a\f\u0010\r\u001a\u00020\u000b*\u00020\u000eH\u0000\"\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"normalizeLicenseInfo", "", "Lapp/cash/licensee/ArtifactDetail;", "coordinateToPomInfo", "", "Lapp/cash/licensee/DependencyCoordinates;", "Lapp/cash/licensee/PomInfo;", "detailsComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "toSpdx", "Lapp/cash/licensee/SpdxLicense;", "Lapp/cash/licensee/PomLicense;", "toSpdxLicense", "Lapp/cash/licensee/SpdxId;", "licensee"})
@SourceDebugExtension(value={"SMAP\nlicenses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 licenses.kt\napp/cash/licensee/LicensesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1#2:77\n1557#3:78\n1628#3,3:79\n*S KotlinDebug\n*F\n+ 1 licenses.kt\napp/cash/licensee/LicensesKt\n*L\n55#1:78\n55#1:79,3\n*E\n"})
public final class LicensesKt {
    @NotNull
    private static final Comparator<ArtifactDetail> detailsComparator;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ArtifactDetail> normalizeLicenseInfo(@NotNull Map<DependencyCoordinates, PomInfo> coordinateToPomInfo) {
        Intrinsics.checkNotNullParameter(coordinateToPomInfo, (String)"coordinateToPomInfo");
        List artifactDetails = new ArrayList();
        for (Map.Entry<DependencyCoordinates, PomInfo> entry : coordinateToPomInfo.entrySet()) {
            ArtifactScm artifactScm;
            DependencyCoordinates id = entry.getKey();
            PomInfo pomInfo = entry.getValue();
            Set spdxLicenses = new LinkedHashSet();
            Set unknownLicenses = new LinkedHashSet();
            for (PomLicense license : pomInfo.getLicenses()) {
                List<SpdxLicense> spdxLicense = LicensesKt.toSpdx(license);
                if (!((Collection)spdxLicense).isEmpty()) {
                    CollectionsKt.addAll((Collection)spdxLicenses, (Iterable)spdxLicense);
                    continue;
                }
                ((Collection)unknownLicenses).add(new UnknownLicense(license.getName(), license.getUrl()));
            }
            Collection collection = artifactDetails;
            String string = id.getGroup();
            String string2 = id.getArtifact();
            String string3 = id.getVersion();
            String string4 = pomInfo.getName();
            Set set = spdxLicenses;
            Set set2 = unknownLicenses;
            Object object = pomInfo.getScm();
            if (object != null && (object = ((PomScm)object).getUrl()) != null) {
                void p0;
                Object object2 = object;
                Set set3 = set2;
                Set set4 = set;
                String string5 = string4;
                String string6 = string3;
                String string7 = string2;
                String string8 = string;
                boolean bl = false;
                ArtifactScm artifactScm2 = new ArtifactScm((String)p0);
                string = string8;
                string2 = string7;
                string3 = string6;
                string4 = string5;
                set = set4;
                set2 = set3;
                artifactScm = artifactScm2;
            } else {
                artifactScm = null;
            }
            ArtifactScm artifactScm3 = artifactScm;
            Set set5 = set2;
            Set set6 = set;
            String string9 = string4;
            String string10 = string3;
            String string11 = string2;
            String string12 = string;
            collection.add(new ArtifactDetail(string12, string11, string10, string9, set6, set5, artifactScm3));
        }
        CollectionsKt.sortWith((List)artifactDetails, detailsComparator);
        return artifactDetails;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SpdxLicense> toSpdx(PomLicense $this$toSpdx) {
        List list;
        if ($this$toSpdx.getUrl() != null) {
            void $this$mapTo$iv$iv;
            List<SpdxId> licenses = SpdxId.Companion.findByUrl$licensee($this$toSpdx.getUrl());
            Iterable $this$map$iv = licenses;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void license;
                SpdxId spdxId = (SpdxId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LicensesKt.toSpdxLicense((SpdxId)license));
            }
            list = (List)destination$iv$iv;
        } else {
            SpdxId license;
            list = $this$toSpdx.getName() != null ? ((license = SpdxId.Companion.findByIdentifier($this$toSpdx.getName())) != null ? CollectionsKt.listOf((Object)LicensesKt.toSpdxLicense(license)) : CollectionsKt.emptyList()) : CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final SpdxLicense toSpdxLicense(@NotNull SpdxId $this$toSpdxLicense) {
        Intrinsics.checkNotNullParameter((Object)$this$toSpdxLicense, (String)"<this>");
        return new SpdxLicense($this$toSpdxLicense.getId(), $this$toSpdxLicense.getName(), $this$toSpdxLicense.getUrl());
    }

    static {
        Function1[] function1Array = new Function1[]{detailsComparator.1.INSTANCE, detailsComparator.2.INSTANCE, detailsComparator.3.INSTANCE};
        detailsComparator = ComparisonsKt.compareBy((Function1[])function1Array);
    }
}

