/*
 * Decompiled with CFR 0.152.
 */
package app.cash.nostrino.model;

import app.cash.nostrino.crypto.CipherText;
import app.cash.nostrino.crypto.PubKey;
import app.cash.nostrino.message.NostrMessageAdapter;
import app.cash.nostrino.model.EncryptedDm;
import app.cash.nostrino.model.EventContent;
import app.cash.nostrino.model.TagsKt;
import app.cash.nostrino.model.TextNote;
import app.cash.nostrino.model.UserMetaData;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\nH\u00c6\u0003J\t\u0010 \u001a\u00020\u000bH\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u0006\u0010\f\u001a\u00020\"J[\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\bH\u00d6\u0001J\t\u0010(\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lapp/cash/nostrino/model/Event;", "", "id", "Lokio/ByteString;", "pubKey", "createdAt", "Ljava/time/Instant;", "kind", "", "tags", "", "", "content", "sig", "(Lokio/ByteString;Lokio/ByteString;Ljava/time/Instant;ILjava/util/List;Ljava/lang/String;Lokio/ByteString;)V", "getContent", "()Ljava/lang/String;", "getCreatedAt", "()Ljava/time/Instant;", "getId", "()Lokio/ByteString;", "getKind", "()I", "getPubKey", "getSig", "getTags", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "Lapp/cash/nostrino/model/EventContent;", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "lib"})
public final class Event {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString id;
    @NotNull
    private final ByteString pubKey;
    @NotNull
    private final Instant createdAt;
    private final int kind;
    @NotNull
    private final List<List<String>> tags;
    @NotNull
    private final String content;
    @NotNull
    private final ByteString sig;
    @NotNull
    private static final Map<Integer, JsonAdapter<UserMetaData>> adapters = MapsKt.mapOf((Pair)TuplesKt.to((Object)0, (Object)NostrMessageAdapter.Companion.getMoshi().adapter(UserMetaData.class)));

    public Event(@NotNull ByteString id, @Json(name="pubkey") @NotNull ByteString pubKey2, @Json(name="created_at") @NotNull Instant createdAt, int kind, @NotNull List<? extends List<String>> tags, @NotNull String content, @NotNull ByteString sig) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)pubKey2, (String)"pubKey");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        this.id = id;
        this.pubKey = pubKey2;
        this.createdAt = createdAt;
        this.kind = kind;
        this.tags = tags;
        this.content = content;
        this.sig = sig;
    }

    @NotNull
    public final ByteString getId() {
        return this.id;
    }

    @NotNull
    public final ByteString getPubKey() {
        return this.pubKey;
    }

    @NotNull
    public final Instant getCreatedAt() {
        return this.createdAt;
    }

    public final int getKind() {
        return this.kind;
    }

    @NotNull
    public final List<List<String>> getTags() {
        return this.tags;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final ByteString getSig() {
        return this.sig;
    }

    @NotNull
    public final EventContent content() {
        EventContent eventContent;
        switch (this.kind) {
            case 1: {
                eventContent = new TextNote(this.content);
                break;
            }
            case 4: {
                PubKey pubKey2 = TagsKt.pubKey(this.tags);
                Intrinsics.checkNotNull((Object)pubKey2);
                eventContent = new EncryptedDm(pubKey2, CipherText.Companion.parse(this.content));
                break;
            }
            default: {
                JsonAdapter<UserMetaData> jsonAdapter = adapters.get(this.kind);
                UserMetaData userMetaData2 = jsonAdapter != null ? (UserMetaData)jsonAdapter.fromJson(this.content) : null;
                Intrinsics.checkNotNull((Object)userMetaData2);
                eventContent = userMetaData2;
            }
        }
        return eventContent;
    }

    @NotNull
    public final ByteString component1() {
        return this.id;
    }

    @NotNull
    public final ByteString component2() {
        return this.pubKey;
    }

    @NotNull
    public final Instant component3() {
        return this.createdAt;
    }

    public final int component4() {
        return this.kind;
    }

    @NotNull
    public final List<List<String>> component5() {
        return this.tags;
    }

    @NotNull
    public final String component6() {
        return this.content;
    }

    @NotNull
    public final ByteString component7() {
        return this.sig;
    }

    @NotNull
    public final Event copy(@NotNull ByteString id, @Json(name="pubkey") @NotNull ByteString pubKey2, @Json(name="created_at") @NotNull Instant createdAt, int kind, @NotNull List<? extends List<String>> tags, @NotNull String content, @NotNull ByteString sig) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)pubKey2, (String)"pubKey");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
        return new Event(id, pubKey2, createdAt, kind, tags, content, sig);
    }

    public static /* synthetic */ Event copy$default(Event event, ByteString byteString, ByteString byteString2, Instant instant, int n, List list, String string, ByteString byteString3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            byteString = event.id;
        }
        if ((n2 & 2) != 0) {
            byteString2 = event.pubKey;
        }
        if ((n2 & 4) != 0) {
            instant = event.createdAt;
        }
        if ((n2 & 8) != 0) {
            n = event.kind;
        }
        if ((n2 & 0x10) != 0) {
            list = event.tags;
        }
        if ((n2 & 0x20) != 0) {
            string = event.content;
        }
        if ((n2 & 0x40) != 0) {
            byteString3 = event.sig;
        }
        return event.copy(byteString, byteString2, instant, n, list, string, byteString3);
    }

    @NotNull
    public String toString() {
        return "Event(id=" + this.id + ", pubKey=" + this.pubKey + ", createdAt=" + this.createdAt + ", kind=" + this.kind + ", tags=" + this.tags + ", content=" + this.content + ", sig=" + this.sig + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.pubKey.hashCode();
        result = result * 31 + this.createdAt.hashCode();
        result = result * 31 + Integer.hashCode(this.kind);
        result = result * 31 + ((Object)this.tags).hashCode();
        result = result * 31 + this.content.hashCode();
        result = result * 31 + this.sig.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Event)) {
            return false;
        }
        Event event = (Event)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)event.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pubKey, (Object)event.pubKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdAt, (Object)event.createdAt)) {
            return false;
        }
        if (this.kind != event.kind) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tags, event.tags)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.content, (Object)event.content)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sig, (Object)event.sig);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R>\u0010\u0003\u001a2\u0012\u0004\u0012\u00020\u0005\u0012(\u0012&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/cash/nostrino/model/Event$Companion;", "", "()V", "adapters", "", "", "Lcom/squareup/moshi/JsonAdapter;", "Lapp/cash/nostrino/model/UserMetaData;", "kotlin.jvm.PlatformType", "lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

