/*
 * Decompiled with CFR 0.152.
 */
package app.cash.nostrino.crypto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ2\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0003J,\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019J+\u0010\u001a\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rH\u0003\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0007J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u001fJ#\u0010 \u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010!\u001a\u00020\"H\u0007\u00a2\u0006\u0002\u0010#J)\u0010$\u001a\u00020\"2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006)"}, d2={"Lapp/cash/nostrino/crypto/Bech32Serde;", "", "()V", "alphabet", "", "charToFive", "", "", "[Ljava/lang/Byte;", "checksum", "hrp", "data", "encoding", "Lapp/cash/nostrino/crypto/Bech32Serde$Encoding;", "(Ljava/lang/String;[Ljava/lang/Byte;Lapp/cash/nostrino/crypto/Bech32Serde$Encoding;)[Ljava/lang/Byte;", "decode", "Lkotlin/Triple;", "bech32", "noChecksum", "", "decodeBytes", "", "eight2five", "input", "Lokio/ByteString;", "(Lokio/ByteString;)[Ljava/lang/Byte;", "encode", "int5s", "(Ljava/lang/String;[Ljava/lang/Byte;Lapp/cash/nostrino/crypto/Bech32Serde$Encoding;)Ljava/lang/String;", "encodeBytes", "expand", "(Ljava/lang/String;)[Ljava/lang/Byte;", "five2eight", "offset", "", "([Ljava/lang/Byte;I)[B", "polymod", "values", "values1", "([Ljava/lang/Byte;[Ljava/lang/Byte;)I", "Encoding", "lib"})
public final class Bech32Serde {
    @NotNull
    public static final Bech32Serde INSTANCE;
    @NotNull
    private static final String alphabet = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    @NotNull
    private static final Byte[] charToFive;

    private Bech32Serde() {
    }

    @JvmStatic
    @NotNull
    public static final String encodeBytes(@NotNull String hrp, @NotNull ByteString data, @NotNull Encoding encoding) {
        Intrinsics.checkNotNullParameter((Object)hrp, (String)"hrp");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        return Bech32Serde.encode(hrp, Bech32Serde.eight2five(data), encoding);
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    private static final String encode(String hrp, Byte[] int5s, Encoding encoding) {
        v0 = hrp.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)v0, (Object)hrp)) ** GOTO lbl-1000
        v1 = hrp.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)v1, (Object)hrp)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        if (!v2) {
            $i$a$-require-Bech32Serde$encode$1 = false;
            $i$a$-require-Bech32Serde$encode$1 = "mixed case strings are not valid bech32 prefixes";
            throw new IllegalArgumentException($i$a$-require-Bech32Serde$encode$1.toString());
        }
        data = ArraysKt.toTypedArray((byte[])ArraysKt.toByteArray((Byte[])int5s));
        checksum = WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()] == 1 ? new Byte[]{} : Bech32Serde.INSTANCE.checksum(hrp, (Byte[])data, encoding);
        var5_7 = ArraysKt.plus((Object[])data, (Object[])checksum);
        var15_8 = hrp;
        $i$f$map = false;
        var7_10 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
        $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            var13_16 = ((Number)item$iv$iv).byteValue();
            var16_18 = destination$iv$iv;
            $i$a$-map-Bech32Serde$encode$2 = false;
            var16_18.add(Character.valueOf("qpzry9x8gf2tvdw0s3jn54khce6mua7l".charAt((int)i)));
        }
        return var15_8 + "1" + StringsKt.concatToString((char[])CollectionsKt.toCharArray((Collection)((List)destination$iv$iv)));
    }

    private final Byte[] checksum(String hrp, Byte[] data, Encoding encoding) {
        Byte[] values = (Byte[])ArraysKt.plus((Object[])this.expand(hrp), (Object[])data);
        Byte[] byteArray = new Byte[]{(byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0};
        int poly = this.polymod(values, byteArray) ^ encoding.getConstant();
        int n = 0;
        Byte[] byteArray2 = new Byte[6];
        while (n < 6) {
            int n2 = n++;
            byteArray2[n2] = (byte)(poly >> 5 * (5 - n2) & 0x1F);
        }
        return byteArray2;
    }

    private final Byte[] expand(String hrp) {
        int n = 0;
        int n2 = hrp.length() + 1 + hrp.length();
        Byte[] byteArray = new Byte[n2];
        while (n < n2) {
            int n3 = n++;
            byteArray[n3] = 0;
        }
        Byte[] result = byteArray;
        n2 = hrp.length();
        for (int i = 0; i < n2; ++i) {
            result[i] = (byte)(hrp.charAt(i) >> 5);
            result[hrp.length() + 1 + i] = (byte)(hrp.charAt(i) & 0x1F);
        }
        result[hrp.length()] = 0;
        return result;
    }

    private final int polymod(Byte[] values, Byte[] values1) {
        Integer[] integerArray = new Integer[]{996825010, 642813549, 513874426, 1027748829, 705979059};
        Integer[] GEN = integerArray;
        int chk = 0;
        chk = 1;
        Byte[][] byteArrayArray = new Byte[][]{values, values1};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])((Object[])byteArrayArray));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Byte[] vs = (Byte[])element$iv;
            boolean bl = false;
            Byte[] $this$forEach$iv2 = vs;
            boolean $i$f$forEach2 = false;
            for (Byte element$iv2 : $this$forEach$iv2) {
                byte v = ((Number)element$iv2).byteValue();
                boolean bl2 = false;
                int b = chk >> 25;
                chk = (chk & 0x1FFFFFF) << 5 ^ v;
                for (int i = 0; i < 6; ++i) {
                    if ((b >> i & 1) == 0) continue;
                    chk ^= GEN[i].intValue();
                }
            }
        }
        return chk;
    }

    @JvmStatic
    @NotNull
    public static final Byte[] eight2five(@NotNull ByteString input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long buffer = 0L;
        ArrayList<Byte> output = new ArrayList<Byte>();
        int count = 0;
        byte[] $this$forEach$iv = input.toByteArray();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            byte element$iv;
            byte b = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            buffer = buffer << 8 | (long)b & 0xFFL;
            count += 8;
            while (count >= 5) {
                output.add((byte)(buffer >> count - 5 & 0x1FL));
                count -= 5;
            }
        }
        if (count > 0) {
            output.add((byte)(buffer << 5 - count & 0x1FL));
        }
        Collection $this$toTypedArray$iv = output;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Byte[0]);
    }

    @JvmStatic
    @NotNull
    public static final Triple<String, byte[], Encoding> decodeBytes(@NotNull String bech32, boolean noChecksum) {
        Intrinsics.checkNotNullParameter((Object)bech32, (String)"bech32");
        Triple<String, Byte[], Encoding> triple = Bech32Serde.decode(bech32, noChecksum);
        String hrp = (String)triple.component1();
        Byte[] int5s = (Byte[])triple.component2();
        Encoding encoding = (Encoding)((Object)triple.component3());
        return new Triple((Object)hrp, (Object)Bech32Serde.five2eight(int5s, 0), (Object)encoding);
    }

    public static /* synthetic */ Triple decodeBytes$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Bech32Serde.decodeBytes(string, bl);
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    private static final Triple<String, Byte[], Encoding> decode(String bech32, boolean noChecksum) {
        v0 = bech32.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)v0, (Object)bech32)) ** GOTO lbl-1000
        v1 = bech32.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        if (Intrinsics.areEqual((Object)v1, (Object)bech32)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        if (!v2) {
            $i$a$-require-Bech32Serde$decode$1 = false;
            $i$a$-require-Bech32Serde$decode$1 = "mixed case strings are not valid bech32";
            throw new IllegalArgumentException($i$a$-require-Bech32Serde$decode$1.toString());
        }
        $this$forEach$iv = bech32;
        $i$f$forEach = false;
        for (var4_6 = 0; var4_6 < $this$forEach$iv.length(); ++var4_6) {
            it = element$iv = $this$forEach$iv.charAt(var4_6);
            $i$a$-forEach-Bech32Serde$decode$2 = 0;
            var8_15 = it;
            if (33 <= var8_15 ? var8_15 < 127 : false) continue;
            $i$a$-require-Bech32Serde$decode$2$1 = false;
            $i$a$-require-Bech32Serde$decode$2$1 = "invalid character ";
            throw new IllegalArgumentException($i$a$-require-Bech32Serde$decode$2$1.toString());
        }
        v3 = bech32.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        input = v3;
        pos = StringsKt.lastIndexOf$default((CharSequence)input, (char)'1', (int)0, (boolean)false, (int)6, null);
        hrp = StringsKt.take((String)input, (int)pos);
        element$iv = hrp.length();
        if (!(1 <= element$iv ? element$iv < 84 : false)) {
            $i$a$-require-Bech32Serde$decode$3 = 0;
            $i$a$-require-Bech32Serde$decode$3 = "hrp must contain 1 to 83 characters";
            throw new IllegalArgumentException($i$a$-require-Bech32Serde$decode$3.toString());
        }
        $i$a$-require-Bech32Serde$decode$3 = 0;
        $i$a$-forEach-Bech32Serde$decode$2 = input.length() - pos - 1;
        var8_16 = new Byte[$i$a$-forEach-Bech32Serde$decode$2];
        while ($i$a$-require-Bech32Serde$decode$3 < $i$a$-forEach-Bech32Serde$decode$2) {
            $i$a$-require-Bech32Serde$decode$2$1 = $i$a$-require-Bech32Serde$decode$3++;
            var8_16[$i$a$-require-Bech32Serde$decode$2$1] = (byte)0;
        }
        i = 0;
        data = var8_16;
        $i$a$-forEach-Bech32Serde$decode$2 = ArraysKt.getLastIndex((Object[])data);
        if (i <= $i$a$-forEach-Bech32Serde$decode$2) {
            while (true) {
                data[i] = Bech32Serde.charToFive[input.charAt(pos + 1 + i)];
                if (i == $i$a$-forEach-Bech32Serde$decode$2) break;
                ++i;
            }
        }
        if (noChecksum) {
            v4 = new Triple((Object)hrp, (Object)data, (Object)Encoding.Beck32WithoutChecksum);
        } else {
            $i$a$-forEach-Bech32Serde$decode$2 = Bech32Serde.INSTANCE.polymod(Bech32Serde.INSTANCE.expand(hrp), (Byte[])data);
            if ($i$a$-forEach-Bech32Serde$decode$2 == Encoding.Bech32.getConstant()) {
                v5 = Encoding.Bech32;
            } else if ($i$a$-forEach-Bech32Serde$decode$2 == Encoding.Bech32m.getConstant()) {
                v5 = Encoding.Bech32m;
            } else {
                throw new IllegalArgumentException("invalid checksum for " + bech32);
            }
            encoding = v5;
            $this$toTypedArray$iv = ArraysKt.dropLast((Object[])data, (int)6);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            v6 = new Triple((Object)hrp, (Object)thisCollection$iv.toArray(new Byte[0]), (Object)encoding);
            v4 = v6;
        }
        return v4;
    }

    static /* synthetic */ Triple decode$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return Bech32Serde.decode(string, bl);
    }

    @JvmStatic
    @NotNull
    public static final byte[] five2eight(@NotNull Byte[] input, int offset) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long buffer = 0L;
        ArrayList<Byte> output = new ArrayList<Byte>();
        int count = 0;
        int i = offset;
        int n = ArraysKt.getLastIndex((Object[])input);
        if (i <= n) {
            while (true) {
                byte b = input[i];
                buffer = buffer << 5 | (long)b & 0x1FL;
                count += 5;
                while (count >= 8) {
                    output.add((byte)(buffer >> count - 8 & 0xFFL));
                    count -= 8;
                }
                if (i == n) break;
                ++i;
            }
        }
        if (!(count <= 4)) {
            boolean $i$a$-require-Bech32Serde$five2eight$32 = false;
            String $i$a$-require-Bech32Serde$five2eight$32 = "Zero-padding of more than 4 bits";
            throw new IllegalArgumentException($i$a$-require-Bech32Serde$five2eight$32.toString());
        }
        if (!((buffer & (1L << count) - 1L) == 0L)) {
            boolean bl = false;
            String string = "Non-zero padding in 8-to-5 conversion";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.toByteArray((Collection)output);
    }

    static {
        Bech32Serde $this$charToFive_u24lambda_u240 = INSTANCE = new Bech32Serde();
        boolean bl = false;
        int n = 0;
        Byte[] byteArray = new Byte[255];
        while (n < 255) {
            int n2 = n++;
            byteArray[n2] = -1;
        }
        Byte[] t = byteArray;
        int i = 0;
        int n3 = StringsKt.getLastIndex((CharSequence)alphabet);
        if (i <= n3) {
            while (true) {
                t[alphabet.charAt((int)i)] = (byte)i;
                if (i == n3) break;
                ++i;
            }
        }
        charToFive = t;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lapp/cash/nostrino/crypto/Bech32Serde$Encoding;", "", "constant", "", "(Ljava/lang/String;II)V", "getConstant", "()I", "Bech32", "Bech32m", "Beck32WithoutChecksum", "lib"})
    public static final class Encoding
    extends Enum<Encoding> {
        private final int constant;
        public static final /* enum */ Encoding Bech32 = new Encoding(1);
        public static final /* enum */ Encoding Bech32m = new Encoding(734539939);
        public static final /* enum */ Encoding Beck32WithoutChecksum = new Encoding(0);
        private static final /* synthetic */ Encoding[] $VALUES;

        private Encoding(int constant) {
            this.constant = constant;
        }

        public final int getConstant() {
            return this.constant;
        }

        public static Encoding[] values() {
            return (Encoding[])$VALUES.clone();
        }

        public static Encoding valueOf(String value) {
            return Enum.valueOf(Encoding.class, value);
        }

        static {
            $VALUES = encodingArray = new Encoding[]{Encoding.Bech32, Encoding.Bech32m, Encoding.Beck32WithoutChecksum};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Encoding.values().length];
            try {
                nArray[Encoding.Beck32WithoutChecksum.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

