/*
 * Decompiled with CFR 0.152.
 */
package app.cash.nostrino.crypto;

import app.cash.nostrino.crypto.PubKey;
import app.cash.nostrino.crypto.SecKey;
import java.security.Key;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lapp/cash/nostrino/crypto/CipherText;", "", "cipherText", "Lokio/ByteString;", "iv", "(Lokio/ByteString;Lokio/ByteString;)V", "getCipherText", "()Lokio/ByteString;", "getIv", "component1", "component2", "copy", "decipher", "", "from", "Lapp/cash/nostrino/crypto/PubKey;", "to", "Lapp/cash/nostrino/crypto/SecKey;", "equals", "", "other", "hashCode", "", "toString", "Companion", "lib"})
public final class CipherText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString cipherText;
    @NotNull
    private final ByteString iv;

    public CipherText(@NotNull ByteString cipherText, @NotNull ByteString iv) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        this.cipherText = cipherText;
        this.iv = iv;
    }

    @NotNull
    public final ByteString getCipherText() {
        return this.cipherText;
    }

    @NotNull
    public final ByteString getIv() {
        return this.iv;
    }

    @NotNull
    public String toString() {
        return this.cipherText.base64() + "?iv=" + this.iv.base64();
    }

    @NotNull
    public final String decipher(@NotNull PubKey from, @NotNull SecKey to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        byte[] sharedSecret = to.sharedSecretWith(from);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)new SecretKeySpec(sharedSecret, "AES"), new IvParameterSpec(this.iv.toByteArray()));
        byte[] byArray = cipher.doFinal(this.cipherText.toByteArray());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(cipherText.toByteArray())");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }

    @NotNull
    public final ByteString component1() {
        return this.cipherText;
    }

    @NotNull
    public final ByteString component2() {
        return this.iv;
    }

    @NotNull
    public final CipherText copy(@NotNull ByteString cipherText, @NotNull ByteString iv) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        return new CipherText(cipherText, iv);
    }

    public static /* synthetic */ CipherText copy$default(CipherText cipherText, ByteString byteString, ByteString byteString2, int n, Object object) {
        if ((n & 1) != 0) {
            byteString = cipherText.cipherText;
        }
        if ((n & 2) != 0) {
            byteString2 = cipherText.iv;
        }
        return cipherText.copy(byteString, byteString2);
    }

    public int hashCode() {
        int result = this.cipherText.hashCode();
        result = result * 31 + this.iv.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CipherText)) {
            return false;
        }
        CipherText cipherText = (CipherText)other;
        if (!Intrinsics.areEqual((Object)this.cipherText, (Object)cipherText.cipherText)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.iv, (Object)cipherText.iv);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lapp/cash/nostrino/crypto/CipherText$Companion;", "", "()V", "parse", "Lapp/cash/nostrino/crypto/CipherText;", "value", "", "lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CipherText parse(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object object = new String[]{"?iv="};
            List parts = StringsKt.split$default((CharSequence)value, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (!(parts.size() == 2)) {
                boolean $i$a$-require-CipherText$Companion$parse$22 = false;
                String $i$a$-require-CipherText$Companion$parse$22 = "Invalid cipherText (should be \"${cipher}?iv=${iv}\"): " + value;
                throw new IllegalArgumentException($i$a$-require-CipherText$Companion$parse$22.toString());
            }
            try {
                ByteString byteString = ByteString.Companion.decodeBase64((String)parts.get(0));
                Intrinsics.checkNotNull((Object)byteString);
                ByteString byteString2 = ByteString.Companion.decodeBase64((String)parts.get(1));
                Intrinsics.checkNotNull((Object)byteString2);
                object = new CipherText(byteString, byteString2);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Invalid cipherText (bad base64): " + value);
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

