/*
 * Decompiled with CFR 0.152.
 */
package app.cash.nostrino.crypto;

import app.cash.nostrino.crypto.Bech32Serde;
import app.cash.nostrino.crypto.Key;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\b\u0010\u0012\u001a\u00020\bH\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001c"}, d2={"Lapp/cash/nostrino/crypto/PubKey;", "Lapp/cash/nostrino/crypto/Key;", "key", "Lokio/ByteString;", "(Lokio/ByteString;)V", "getKey", "()Lokio/ByteString;", "npub", "", "getNpub", "()Ljava/lang/String;", "npub$delegate", "Lkotlin/Lazy;", "shortForm", "getShortForm", "shortForm$delegate", "component1", "copy", "encoded", "equals", "", "other", "", "hashCode", "", "hex", "toString", "Companion", "lib"})
public final class PubKey
implements Key {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString key;
    @NotNull
    private final Lazy npub$delegate;
    @NotNull
    private final Lazy shortForm$delegate;
    @NotNull
    private static final Regex shortBech32Regex = new Regex("npub1([a-z\\d]{8})[a-z\\d]{42}([a-z\\d]{8})");

    public PubKey(@NotNull ByteString key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
        this.npub$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PubKey this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Bech32Serde.encodeBytes("npub", this.this$0.getKey(), Bech32Serde.Encoding.Bech32);
            }
        }));
        this.shortForm$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PubKey this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return PubKey.access$getShortBech32Regex$cp().replace((CharSequence)this.this$0.getNpub(), "$1:$2");
            }
        }));
    }

    @NotNull
    public final ByteString getKey() {
        return this.key;
    }

    @NotNull
    public final String getNpub() {
        Lazy lazy = this.npub$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String encoded() {
        return this.getNpub();
    }

    @NotNull
    public String toString() {
        return "PubKey(key=" + this.key.hex() + ")";
    }

    @NotNull
    public final String getShortForm() {
        Lazy lazy = this.shortForm$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String hex() {
        return this.key.hex();
    }

    @NotNull
    public final ByteString component1() {
        return this.key;
    }

    @NotNull
    public final PubKey copy(@NotNull ByteString key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new PubKey(key);
    }

    public static /* synthetic */ PubKey copy$default(PubKey pubKey2, ByteString byteString, int n, Object object) {
        if ((n & 1) != 0) {
            byteString = pubKey2.key;
        }
        return pubKey2.copy(byteString);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PubKey)) {
            return false;
        }
        PubKey pubKey2 = (PubKey)other;
        return Intrinsics.areEqual((Object)this.key, (Object)pubKey2.key);
    }

    public static final /* synthetic */ Regex access$getShortBech32Regex$cp() {
        return shortBech32Regex;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/cash/nostrino/crypto/PubKey$Companion;", "", "()V", "shortBech32Regex", "Lkotlin/text/Regex;", "parse", "Lapp/cash/nostrino/crypto/PubKey;", "bech32", "", "lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PubKey parse(@NotNull String bech32) {
            Intrinsics.checkNotNullParameter((Object)bech32, (String)"bech32");
            Triple<String, byte[], Bech32Serde.Encoding> triple = Bech32Serde.decodeBytes(bech32, false);
            String hrp = (String)triple.component1();
            byte[] key = (byte[])triple.component2();
            if (!Intrinsics.areEqual((Object)hrp, (Object)"npub")) {
                boolean bl = false;
                String string = "Unsupported encoding hrp=" + hrp;
                throw new IllegalArgumentException(string.toString());
            }
            return new PubKey(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])key, (int)0, (int)0, (int)3, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

