/*
 * Decompiled with CFR 0.152.
 */
package app.cash.nostrino.crypto;

import app.cash.nostrino.crypto.Bech32Serde;
import app.cash.nostrino.crypto.CipherText;
import app.cash.nostrino.crypto.Key;
import app.cash.nostrino.crypto.PubKey;
import fr.acinq.secp256k1.Hex;
import fr.acinq.secp256k1.Secp256k1;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\b\u0010\u0014\u001a\u00020\bH\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\bJ\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020\bH\u0016J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J\b\u0010%\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lapp/cash/nostrino/crypto/SecKey;", "Lapp/cash/nostrino/crypto/Key;", "key", "Lokio/ByteString;", "(Lokio/ByteString;)V", "getKey", "()Lokio/ByteString;", "nsec", "", "getNsec", "()Ljava/lang/String;", "nsec$delegate", "Lkotlin/Lazy;", "pubKey", "Lapp/cash/nostrino/crypto/PubKey;", "getPubKey", "()Lapp/cash/nostrino/crypto/PubKey;", "pubKey$delegate", "component1", "copy", "encoded", "encrypt", "Lapp/cash/nostrino/crypto/CipherText;", "to", "plainText", "equals", "", "other", "", "hashCode", "", "hex", "sharedSecretWith", "", "pub", "sign", "payload", "toString", "Companion", "lib"})
public final class SecKey
implements Key {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString key;
    @NotNull
    private final Lazy nsec$delegate;
    @NotNull
    private final Lazy pubKey$delegate;

    public SecKey(@NotNull ByteString key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
        this.nsec$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ SecKey this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Bech32Serde.encodeBytes("nsec", this.this$0.getKey(), Bech32Serde.Encoding.Bech32);
            }
        }));
        this.pubKey$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PubKey>(this){
            final /* synthetic */ SecKey this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PubKey invoke() {
                byte[] byArray = Secp256k1.Companion.pubKeyCompress(Secp256k1.Companion.pubkeyCreate(this.this$0.getKey().toByteArray()));
                int n = 1;
                int n2 = 33;
                return new PubKey(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2), (int)0, (int)0, (int)3, null));
            }
        }));
    }

    @NotNull
    public final ByteString getKey() {
        return this.key;
    }

    @NotNull
    public String toString() {
        return "SecKey(\u2588\u2588\u2588)";
    }

    @NotNull
    public final String getNsec() {
        Lazy lazy = this.nsec$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String encoded() {
        return this.getNsec();
    }

    @Override
    @NotNull
    public String hex() {
        return this.key.hex();
    }

    @NotNull
    public final PubKey getPubKey() {
        Lazy lazy = this.pubKey$delegate;
        return (PubKey)lazy.getValue();
    }

    @NotNull
    public final ByteString sign(@NotNull ByteString payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])Secp256k1.Companion.signSchnorr(payload.toByteArray(), this.key.toByteArray(), null), (int)0, (int)0, (int)3, null);
    }

    @NotNull
    public final byte[] sharedSecretWith(@NotNull PubKey pub) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        byte[] byArray = Secp256k1.Companion.pubKeyTweakMul(ArraysKt.plus((byte[])Hex.decode((String)"02"), (byte[])pub.getKey().toByteArray()), this.key.toByteArray());
        int n = 1;
        int n2 = 33;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    @NotNull
    public final CipherText encrypt(@NotNull PubKey to, @NotNull String plainText) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (java.security.Key)new SecretKeySpec(this.sharedSecretWith(to), "AES"), new IvParameterSpec(iv));
        String string = plainText;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] encrypted = cipher.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)encrypted, (String)"encrypted");
        return new CipherText(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])encrypted, (int)0, (int)0, (int)3, null), ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])iv, (int)0, (int)0, (int)3, null));
    }

    @NotNull
    public final ByteString component1() {
        return this.key;
    }

    @NotNull
    public final SecKey copy(@NotNull ByteString key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new SecKey(key);
    }

    public static /* synthetic */ SecKey copy$default(SecKey secKey, ByteString byteString, int n, Object object) {
        if ((n & 1) != 0) {
            byteString = secKey.key;
        }
        return secKey.copy(byteString);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SecKey)) {
            return false;
        }
        SecKey secKey = (SecKey)other;
        return Intrinsics.areEqual((Object)this.key, (Object)secKey.key);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lapp/cash/nostrino/crypto/SecKey$Companion;", "", "()V", "parse", "Lapp/cash/nostrino/crypto/SecKey;", "bech32", "", "lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecKey parse(@NotNull String bech32) {
            Intrinsics.checkNotNullParameter((Object)bech32, (String)"bech32");
            Triple<String, byte[], Bech32Serde.Encoding> triple = Bech32Serde.decodeBytes(bech32, false);
            String hrp = (String)triple.component1();
            byte[] key = (byte[])triple.component2();
            if (!Intrinsics.areEqual((Object)hrp, (Object)"nsec")) {
                boolean bl = false;
                String string = "Unsupported encoding hrp=" + hrp;
                throw new IllegalArgumentException(string.toString());
            }
            return new SecKey(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])key, (int)0, (int)0, (int)3, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

